/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.log;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.util.StackTraceUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;

public class LogUtil {
    public static final int STACK_TRACE_LENGTH = 20;
    public static final boolean REMOVE_UNKNOWN_SOURCE = true;

    public static void debug(Log log, Properties props) {
        if (log.isDebugEnabled()) {
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter(true, props.size() + 1);
            props.list(new PrintWriter(unsyncStringWriter));
            log.debug(unsyncStringWriter.toString());
        }
    }

    public static void log(Log log, Throwable t) {
        if (t instanceof JspException) {
            LogUtil.log(log, (JspException)t);
        } else if (t instanceof ServletException) {
            LogUtil.log(log, (ServletException)t);
        } else {
            Throwable cause = t.getCause();
            if (cause != null) {
                LogUtil.log(log, cause);
            } else {
                LogUtil._log(log, t);
            }
        }
    }

    public static void log(Log log, JspException jspe) {
        Throwable cause = jspe.getRootCause();
        if (cause == null) {
            cause = jspe;
        }
        if (cause != jspe && cause instanceof JspException) {
            LogUtil.log(log, (JspException)cause);
        } else if (cause instanceof ServletException) {
            LogUtil.log(log, (ServletException)cause);
        } else {
            LogUtil._log(log, cause);
        }
    }

    public static void log(Log log, ServletException se) {
        Throwable cause = se.getRootCause();
        if (cause == null) {
            cause = se;
        }
        if (cause instanceof JspException) {
            LogUtil.log(log, (JspException)cause);
        } else if (cause != se && cause instanceof ServletException) {
            LogUtil.log(log, (ServletException)cause);
        } else {
            LogUtil._log(log, cause);
        }
    }

    private static void _log(Log log, Throwable cause) {
        StackTraceElement[] steArray = cause.getStackTrace();
        if (steArray.length > 20) {
            int count = 0;
            ArrayList<StackTraceElement> steList = new ArrayList<StackTraceElement>();
            for (int i = 0; i < steArray.length; ++i) {
                StackTraceElement ste = steArray[i];
                String className = ste.getClassName();
                boolean addElement = true;
                if (ste.getLineNumber() < 0) {
                    addElement = false;
                }
                if (className.startsWith("$") || className.startsWith("java.lang.reflect.") || className.startsWith("org.springframework.") || className.startsWith("sun.reflect.")) {
                    addElement = false;
                }
                if (addElement) {
                    steList.add(ste);
                    ++count;
                }
                if (count >= 20) break;
            }
            steArray = steList.toArray(new StackTraceElement[steList.size()]);
            cause.setStackTrace(steArray);
        }
        log.error(StackTraceUtil.getStackTrace(cause));
    }
}

