/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;

public class MessageBusUtil {
    private static MessageBusUtil _instance = new MessageBusUtil();
    private MessageBus _messageBus;
    private MessageSender _messageSender;
    private SynchronousMessageSender _synchronousMessageSender;

    public static void addDestination(Destination destination) {
        _instance._addDestination(destination);
    }

    public static Message createResponseMessage(Message requestMessage) {
        Message responseMessage = new Message();
        responseMessage.setDestinationName(requestMessage.getResponseDestinationName());
        responseMessage.setResponseId(requestMessage.getResponseId());
        return responseMessage;
    }

    public static Message createResponseMessage(Message requestMessage, Object payload) {
        Message responseMessage = MessageBusUtil.createResponseMessage(requestMessage);
        responseMessage.setPayload(payload);
        return responseMessage;
    }

    public static MessageBus getMessageBus() {
        return MessageBusUtil._instance._messageBus;
    }

    public static MessageSender getMessageSender() {
        return MessageBusUtil._instance._messageSender;
    }

    public static boolean hasMessageListener(String destination) {
        return _instance._hasMessageListener(destination);
    }

    public static void init(MessageBus messageBus, MessageSender messageSender, SynchronousMessageSender synchronousMessageSender) {
        _instance._init(messageBus, messageSender, synchronousMessageSender);
    }

    public static void registerMessageListener(String destinationName, MessageListener messageListener) {
        _instance._registerMessageListener(destinationName, messageListener);
    }

    public static void removeDestination(String destinationName) {
        _instance._removeDestination(destinationName);
    }

    public static void sendMessage(String destinationName, Message message) {
        _instance._sendMessage(destinationName, message);
    }

    public static void sendMessage(String destinationName, Object payload) {
        _instance._sendMessage(destinationName, payload);
    }

    public static Object sendSynchronousMessage(String destinationName, Message message) throws MessageBusException {
        return _instance._sendSynchronousMessage(destinationName, message);
    }

    public static Object sendSynchronousMessage(String destinationName, Message message, long timeout) throws MessageBusException {
        return _instance._sendSynchronousMessage(destinationName, message, timeout);
    }

    public static Object sendSynchronousMessage(String destinationName, Object payload) throws MessageBusException {
        return _instance._sendSynchronousMessage(destinationName, payload, null);
    }

    public static Object sendSynchronousMessage(String destinationName, Object payload, long timeout) throws MessageBusException {
        return _instance._sendSynchronousMessage(destinationName, payload, null, timeout);
    }

    public static Object sendSynchronousMessage(String destinationName, Object payload, String responseDestinationName) throws MessageBusException {
        return _instance._sendSynchronousMessage(destinationName, payload, responseDestinationName);
    }

    public static Object sendSynchronousMessage(String destinationName, Object payload, String responseDestinationName, long timeout) throws MessageBusException {
        return _instance._sendSynchronousMessage(destinationName, payload, responseDestinationName, timeout);
    }

    public static boolean unregisterMessageListener(String destinationName, MessageListener messageListener) {
        return _instance._unregisterMessageListener(destinationName, messageListener);
    }

    private MessageBusUtil() {
    }

    private void _addDestination(Destination destination) {
        this._messageBus.addDestination(destination);
    }

    private boolean _hasMessageListener(String destinationName) {
        return this._messageBus.hasMessageListener(destinationName);
    }

    private void _init(MessageBus messageBus, MessageSender messageSender, SynchronousMessageSender synchronousMessageSender) {
        this._messageBus = messageBus;
        this._messageSender = messageSender;
        this._synchronousMessageSender = synchronousMessageSender;
    }

    private void _registerMessageListener(String destinationName, MessageListener messageListener) {
        this._messageBus.registerMessageListener(destinationName, messageListener);
    }

    private void _removeDestination(String destinationName) {
        this._messageBus.removeDestination(destinationName);
    }

    private void _sendMessage(String destinationName, Message message) {
        this._messageBus.sendMessage(destinationName, message);
    }

    private void _sendMessage(String destinationName, Object payload) {
        Message message = new Message();
        message.setPayload(payload);
        this._sendMessage(destinationName, message);
    }

    private Object _sendSynchronousMessage(String destinationName, Message message) throws MessageBusException {
        return this._synchronousMessageSender.send(destinationName, message);
    }

    private Object _sendSynchronousMessage(String destinationName, Message message, long timeout) throws MessageBusException {
        return this._synchronousMessageSender.send(destinationName, message, timeout);
    }

    private Object _sendSynchronousMessage(String destinationName, Object payload, String responseDestinationName) throws MessageBusException {
        Message message = new Message();
        message.setResponseDestinationName(responseDestinationName);
        message.setPayload(payload);
        return this._sendSynchronousMessage(destinationName, message);
    }

    private Object _sendSynchronousMessage(String destinationName, Object payload, String responseDestinationName, long timeout) throws MessageBusException {
        Message message = new Message();
        message.setResponseDestinationName(responseDestinationName);
        message.setPayload(payload);
        return this._sendSynchronousMessage(destinationName, message, timeout);
    }

    private boolean _unregisterMessageListener(String destinationName, MessageListener messageListener) {
        return this._messageBus.unregisterMessageListener(destinationName, messageListener);
    }
}

