/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialDestination
extends BaseDestination {
    private static final int _WORKERS_CORE_SIZE = 1;
    private static final int _WORKERS_MAX_SIZE = 1;

    public SerialDestination() {
    }

    public SerialDestination(String name) {
        super(name, 1, 1);
    }

    @Override
    protected void dispatch(final Set<MessageListener> messageListeners, final Message message) {
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        Runnable runnable = new Runnable(){

            public void run() {
                for (MessageListener messageListener : messageListeners) {
                    messageListener.receive(message);
                }
            }
        };
        threadPoolExecutor.execute(runnable);
    }
}

