/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.jmx;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseDestinationEventListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.jmx.DestinationManager;
import com.liferay.portal.kernel.messaging.jmx.DestinationStatisticsManager;
import com.liferay.portal.kernel.messaging.jmx.MessageBusManager;
import java.util.Collection;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JMXMessageListener
extends BaseDestinationEventListener {
    private static Log log = LogFactoryUtil.getLog(JMXMessageListener.class);
    private MBeanServer _mBeanServer;
    private MessageBus _messageBus;

    public void destinationAdded(Destination destination) {
        try {
            this.registerDestination(destination);
        }
        catch (Exception e) {
            log.error("Unable to register destination " + destination.getName(), e);
        }
    }

    public void destinationRemoved(Destination destination) {
        try {
            this.unregisterDestination(destination);
        }
        catch (Exception e) {
            log.error("Unable to unregister destination " + destination.getName(), e);
        }
    }

    public void destroy() throws Exception {
        block5: {
            Collection<Destination> destinations = this._messageBus.getDestinations();
            for (Destination destination : destinations) {
                try {
                    this.unregisterDestination(destination);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Unable to unregister destination " + destination.getName(), e);
                }
            }
            try {
                this._mBeanServer.unregisterMBean(MessageBusManager.createObjectName());
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn("Unable to unregister message bus manager", e);
            }
        }
    }

    public void init() throws Exception {
        block6: {
            if (this._mBeanServer == null || this._messageBus == null) {
                throw new IllegalStateException("MBean server and message bus are not configured");
            }
            try {
                this._replaceMBeanRegistration(new MessageBusManager(this._messageBus), MessageBusManager.createObjectName());
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn("Unable to register message bus manager", e);
            }
        }
        Collection<Destination> destinations = this._messageBus.getDestinations();
        for (Destination destination : destinations) {
            try {
                this.registerDestination(destination);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn("Unable to register destination " + destination.getName(), e);
            }
        }
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this._mBeanServer = mBeanServer;
    }

    public void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }

    protected void registerDestination(Destination destination) throws Exception {
        String destinationName = destination.getName();
        this._replaceMBeanRegistration(new DestinationManager(destination), DestinationManager.createObjectName(destinationName));
        this._replaceMBeanRegistration(new DestinationStatisticsManager(destination), DestinationStatisticsManager.createObjectName(destinationName));
    }

    protected void unregisterDestination(Destination destination) throws Exception {
        String destinationName = destination.getName();
        this._mBeanServer.unregisterMBean(DestinationManager.createObjectName(destinationName));
        this._mBeanServer.unregisterMBean(DestinationStatisticsManager.createObjectName(destinationName));
    }

    private void _replaceMBeanRegistration(Object object, ObjectName objectName) throws Exception {
        try {
            this._mBeanServer.registerMBean(object, objectName);
        }
        catch (InstanceAlreadyExistsException iaee) {
            this._mBeanServer.unregisterMBean(objectName);
            this._mBeanServer.registerMBean(object, objectName);
        }
    }
}

