/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.portal.kernel.messaging.proxy.MessagingProxy;
import com.liferay.portal.kernel.messaging.proxy.ProxyMode;
import com.liferay.portal.kernel.util.MethodInvoker;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.NullWrapper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ProxyRequest
implements Serializable {
    private boolean _hasReturnValue;
    private MethodWrapper _methodWrapper;
    private boolean _synchronous;

    public ProxyRequest(Method method, Object[] arguments) throws Exception {
        MessagingProxy messagingProxy;
        Class<?>[] argumentTypes = method.getParameterTypes();
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] != null) continue;
            arguments[i] = new NullWrapper(argumentTypes[i].getName());
        }
        this._methodWrapper = new MethodWrapper(method, arguments);
        this._hasReturnValue = false;
        if (method.getReturnType() != Void.TYPE) {
            this._hasReturnValue = true;
        }
        if ((messagingProxy = method.getAnnotation(MessagingProxy.class)) == null) {
            messagingProxy = method.getDeclaringClass().getAnnotation(MessagingProxy.class);
        }
        if (messagingProxy != null && messagingProxy.mode().equals((Object)ProxyMode.SYNC)) {
            this._synchronous = true;
        }
    }

    public Object execute(Object object) throws Exception {
        try {
            return MethodInvoker.invoke(this._methodWrapper, object);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
    }

    public MethodWrapper getMethodWrapper() {
        return this._methodWrapper;
    }

    public boolean hasReturnValue() {
        return this._hasReturnValue;
    }

    public boolean isSynchronous() {
        return this._synchronous;
    }
}

