/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.sender;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageListener;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUID;

public class DefaultSynchronousMessageSender
implements SynchronousMessageSender {
    private static Log _log = LogFactoryUtil.getLog(DefaultSynchronousMessageSender.class);
    private MessageBus _messageBus;
    private PortalUUID _portalUUID;
    private long _timeout;

    public DefaultSynchronousMessageSender() {
    }

    public DefaultSynchronousMessageSender(MessageBus messageBus, PortalUUID portalUUID, long timeout) {
        this._messageBus = messageBus;
        this._portalUUID = portalUUID;
        this._timeout = timeout;
    }

    public Object send(String destinationName, Message message) throws MessageBusException {
        return this.send(destinationName, message, this._timeout);
    }

    public Object send(String destinationName, Message message, long timeout) throws MessageBusException {
        Destination destination = this._messageBus.getDestination(destinationName);
        if (destination == null) {
            if (_log.isInfoEnabled()) {
                _log.info("Destination " + destinationName + " is not configured");
            }
            return null;
        }
        if (destination.getMessageListenerCount() == 0) {
            if (_log.isInfoEnabled()) {
                _log.info("Destination " + destinationName + " does not have any message listeners");
            }
            return null;
        }
        message.setDestinationName(destinationName);
        String responseDestinationName = message.getResponseDestinationName();
        if (Validator.isNull(responseDestinationName) || !this._messageBus.hasDestination(responseDestinationName)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Response destination " + responseDestinationName + " is not configured");
            }
            message.setResponseDestinationName("liferay/message_bus/default_response");
        }
        String responseId = this._portalUUID.generate();
        message.setResponseId(responseId);
        SynchronousMessageListener synchronousMessageListener = new SynchronousMessageListener(this._messageBus, message, timeout);
        return synchronousMessageListener.send();
    }

    public Object sendMessage(String destination, Message message) throws MessageBusException {
        return this.send(destination, message);
    }

    public Object sendMessage(String destination, Message message, long timeout) throws MessageBusException {
        return this.send(destination, message, timeout);
    }

    public void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }

    public void setPortalUUID(PortalUUID portalUUID) {
        this._portalUUID = portalUUID;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }
}

