/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.plugin;

import com.liferay.portal.kernel.plugin.PluginPackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotePluginPackageRepository {
    public static final String LOCAL_URL = "LOCAL_URL";
    public static final String SETTING_USE_DOWNLOAD_URL = "use-download-url";
    private Map<String, PluginPackage> _artifactURLIndex = new HashMap<String, PluginPackage>();
    private Map<String, List<PluginPackage>> _groupAndArtifactIndex = new HashMap<String, List<PluginPackage>>();
    private Map<String, PluginPackage> _moduleIdIndex = new HashMap<String, PluginPackage>();
    private List<PluginPackage> _pluginPackages = new ArrayList<PluginPackage>();
    private String _repositoryURL;
    private Properties _settings = null;
    private Set<String> _tags = new TreeSet<String>();

    public RemotePluginPackageRepository(String repositoryURL) {
        this._repositoryURL = repositoryURL;
    }

    public void addPluginPackage(PluginPackage pluginPackage) {
        PluginPackage existingPackage = this._moduleIdIndex.get(pluginPackage.getModuleId());
        if (existingPackage != null) {
            return;
        }
        this._artifactURLIndex.put(pluginPackage.getArtifactURL(), pluginPackage);
        this._moduleIdIndex.put(pluginPackage.getModuleId(), pluginPackage);
        this._addToGroupAndArtifactIndex(pluginPackage.getGroupId(), pluginPackage.getArtifactId(), pluginPackage);
        this._pluginPackages.add(pluginPackage);
        this._tags.addAll(pluginPackage.getTags());
    }

    public PluginPackage findPluginByArtifactURL(String artifactURL) {
        return this._artifactURLIndex.get(artifactURL);
    }

    public PluginPackage findPluginPackageByModuleId(String moduleId) {
        return this._moduleIdIndex.get(moduleId);
    }

    public List<PluginPackage> findPluginsByGroupIdAndArtifactId(String groupId, String artifactId) {
        return this._groupAndArtifactIndex.get(groupId + "/" + artifactId);
    }

    public List<PluginPackage> getPluginPackages() {
        return this._pluginPackages;
    }

    public String getRepositoryURL() {
        return this._repositoryURL;
    }

    public Properties getSettings() {
        return this._settings;
    }

    public Set<String> getTags() {
        return this._tags;
    }

    public void removePlugin(PluginPackage pluginPackage) {
        this._artifactURLIndex.remove(pluginPackage.getArtifactURL());
        this._moduleIdIndex.remove(pluginPackage.getModuleId());
        this._removeFromGroupAndArtifactIndex(pluginPackage.getGroupId(), pluginPackage.getArtifactId(), pluginPackage.getModuleId());
        this._pluginPackages.remove(pluginPackage);
    }

    public void setSettings(Properties settings) {
        this._settings = settings;
    }

    private void _addToGroupAndArtifactIndex(String groupId, String artifactId, PluginPackage pluginPackage) {
        List<PluginPackage> pluginPackages = this.findPluginsByGroupIdAndArtifactId(groupId, artifactId);
        if (pluginPackages == null) {
            pluginPackages = new ArrayList<PluginPackage>();
            this._groupAndArtifactIndex.put(groupId + "/" + artifactId, pluginPackages);
        }
        pluginPackages.add(pluginPackage);
    }

    private void _removeFromGroupAndArtifactIndex(String groupId, String artifactId, String moduleId) {
        List<PluginPackage> pluginPackages = this.findPluginsByGroupIdAndArtifactId(groupId, artifactId);
        if (pluginPackages != null) {
            Iterator<PluginPackage> itr = pluginPackages.iterator();
            while (itr.hasNext()) {
                PluginPackage pluginPackage = itr.next();
                if (!pluginPackage.getModuleId().equals(moduleId)) continue;
                itr.remove();
                break;
            }
        }
    }
}

