/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.poller;

import com.liferay.portal.kernel.poller.PollerException;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.poller.PollerRequest;
import com.liferay.portal.kernel.poller.PollerResponse;
import com.liferay.portal.kernel.util.GetterUtil;

public abstract class BasePollerProcessor
implements PollerProcessor {
    public void receive(PollerRequest pollerRequest, PollerResponse pollerResponse) throws PollerException {
        try {
            this.doReceive(pollerRequest, pollerResponse);
        }
        catch (Exception e) {
            throw new PollerException(e);
        }
    }

    public void send(PollerRequest pollerRequest) throws PollerException {
        try {
            this.doSend(pollerRequest);
        }
        catch (Exception e) {
            throw new PollerException(e);
        }
    }

    protected abstract void doReceive(PollerRequest var1, PollerResponse var2) throws Exception;

    protected abstract void doSend(PollerRequest var1) throws Exception;

    protected boolean getBoolean(PollerRequest pollerRequest, String name) {
        return this.getBoolean(pollerRequest, name, false);
    }

    protected boolean getBoolean(PollerRequest pollerRequest, String name, boolean defaultValue) {
        return GetterUtil.getBoolean(pollerRequest.getParameterMap().get(name), defaultValue);
    }

    protected double getDouble(PollerRequest pollerRequest, String name) {
        return this.getDouble(pollerRequest, name, -1.0);
    }

    protected double getDouble(PollerRequest pollerRequest, String name, double defaultValue) {
        return GetterUtil.getDouble(pollerRequest.getParameterMap().get(name), defaultValue);
    }

    protected int getInteger(PollerRequest pollerRequest, String name) {
        return this.getInteger(pollerRequest, name, -1);
    }

    protected int getInteger(PollerRequest pollerRequest, String name, int defaultValue) {
        return GetterUtil.getInteger(pollerRequest.getParameterMap().get(name), defaultValue);
    }

    protected long getLong(PollerRequest pollerRequest, String name) {
        return this.getLong(pollerRequest, name, -1L);
    }

    protected long getLong(PollerRequest pollerRequest, String name, long defaultValue) {
        return GetterUtil.getLong(pollerRequest.getParameterMap().get(name), defaultValue);
    }

    protected String getString(PollerRequest pollerRequest, String name) {
        return this.getString(pollerRequest, name, null);
    }

    protected String getString(PollerRequest pollerRequest, String name, String defaultValue) {
        return GetterUtil.getString(pollerRequest.getParameterMap().get(name), defaultValue);
    }
}

