/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler;

import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerRequest;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerEngineUtil {
    private SchedulerEngine _schedulerEngine;
    private static SchedulerEngineUtil _instance = new SchedulerEngineUtil();

    public static List<SchedulerRequest> getScheduledJobs(String groupName) throws SchedulerException {
        return _instance._getScheduledJobs(groupName);
    }

    public static void init(SchedulerEngine defaultScheduler) {
        _instance._init(defaultScheduler);
    }

    public static void schedule(String groupName, long interval, Date startDate, Date endDate, String description, String destinationName, String messageBody) throws SchedulerException {
        _instance._schedule(groupName, interval, startDate, endDate, description, destinationName, messageBody);
    }

    public static void schedule(String groupName, String cronText, Date startDate, Date endDate, String description, String destinationName, String messageBody) throws SchedulerException {
        _instance._schedule(groupName, cronText, startDate, endDate, description, destinationName, messageBody);
    }

    public static void schedule(String jobName, String groupName, long interval, Date startDate, Date endDate, String description, String destinationName, String messageBody) throws SchedulerException {
        _instance._schedule(jobName, groupName, interval, startDate, endDate, description, destinationName, messageBody);
    }

    public static void schedule(String jobName, String groupName, String cronText, Date startDate, Date endDate, String description, String destinationName, String messageBody) throws SchedulerException {
        _instance._schedule(jobName, groupName, cronText, startDate, endDate, description, destinationName, messageBody);
    }

    public static void shutdown() throws SchedulerException {
        _instance._shutdown();
    }

    public static void start() throws SchedulerException {
        _instance._start();
    }

    public static void unschedule(String jobName, String groupName) throws SchedulerException {
        _instance._unschedule(jobName, groupName);
    }

    private List<SchedulerRequest> _getScheduledJobs(String groupName) throws SchedulerException {
        return this._schedulerEngine.getScheduledJobs(groupName);
    }

    private void _init(SchedulerEngine schedulerEngine) {
        this._schedulerEngine = schedulerEngine;
    }

    private void _schedule(String groupName, long interval, Date startDate, Date endDate, String description, String destinationName, String messageBody) throws SchedulerException {
        this._schedulerEngine.schedule(groupName, interval, startDate, endDate, description, destinationName, messageBody);
    }

    private void _schedule(String groupName, String cronText, Date startDate, Date endDate, String description, String destinationName, String messageBody) throws SchedulerException {
        this._schedulerEngine.schedule(groupName, cronText, startDate, endDate, description, destinationName, messageBody);
    }

    private void _schedule(String jobName, String groupName, long interval, Date startDate, Date endDate, String description, String destinationName, String messageBody) throws SchedulerException {
        this._schedulerEngine.schedule(jobName, groupName, interval, startDate, endDate, description, destinationName, messageBody);
    }

    private void _schedule(String jobName, String groupName, String cronText, Date startDate, Date endDate, String description, String destinationName, String messageBody) throws SchedulerException {
        this._schedulerEngine.schedule(jobName, groupName, cronText, startDate, endDate, description, destinationName, messageBody);
    }

    private void _shutdown() throws SchedulerException {
        this._schedulerEngine.shutdown();
    }

    private void _start() throws SchedulerException {
        this._schedulerEngine.start();
    }

    private void _unschedule(String jobName, String groupName) throws SchedulerException {
        this._schedulerEngine.unschedule(jobName, groupName);
    }
}

