/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler.messaging;

import com.liferay.portal.kernel.scheduler.TriggerType;
import java.io.Serializable;
import java.util.Date;

public class SchedulerRequest
implements Serializable {
    public static final String COMMAND_REGISTER = "REGISTER";
    public static final String COMMAND_RETRIEVE = "RETRIEVE";
    public static final String COMMAND_SHUTDOWN = "SHUTDOWN";
    public static final String COMMAND_STARTUP = "STARTUP";
    public static final String COMMAND_UNREGISTER = "UNREGISTER";
    private String _command;
    private String _cronText;
    private String _description;
    private String _destination;
    private Date _endDate;
    private String _groupName;
    private long _interval;
    private String _jobName;
    private String _messageBody;
    private Date _startDate;
    private TriggerType _triggerType;

    public static SchedulerRequest createRegisterRequest(String groupName, long interval, Date startDate, Date endDate, String description, String destination, String messageBody) {
        return new SchedulerRequest(COMMAND_REGISTER, null, groupName, interval, startDate, endDate, description, destination, messageBody);
    }

    public static SchedulerRequest createRegisterRequest(String groupName, String cronText, Date startDate, Date endDate, String description, String destination, String messageBody) {
        return new SchedulerRequest(COMMAND_REGISTER, null, groupName, cronText, startDate, endDate, description, destination, messageBody);
    }

    public static SchedulerRequest createRegisterRequest(String jobName, String groupName, long interval, Date startDate, Date endDate, String description, String destination, String messageBody) {
        return new SchedulerRequest(COMMAND_REGISTER, jobName, groupName, interval, startDate, endDate, description, destination, messageBody);
    }

    public static SchedulerRequest createRegisterRequest(String jobName, String groupName, String cronText, Date startDate, Date endDate, String description, String destination, String messageBody) {
        return new SchedulerRequest(COMMAND_REGISTER, jobName, groupName, cronText, startDate, endDate, description, destination, messageBody);
    }

    public static SchedulerRequest createRetrieveRequest(String groupName) {
        return new SchedulerRequest(COMMAND_RETRIEVE, null, groupName);
    }

    public static SchedulerRequest createRetrieveResponseRequest(String jobName, String groupName, long interval, Date startDate, Date endDate, String description, String messageBody) {
        return new SchedulerRequest(null, jobName, groupName, interval, startDate, endDate, description, null, messageBody);
    }

    public static SchedulerRequest createRetrieveResponseRequest(String jobName, String groupName, String cronText, Date startDate, Date endDate, String description, String messageBody) {
        return new SchedulerRequest(null, jobName, groupName, cronText, startDate, endDate, description, null, messageBody);
    }

    public static SchedulerRequest createShutdownRequest() {
        return new SchedulerRequest(COMMAND_SHUTDOWN);
    }

    public static SchedulerRequest createStartupRequest() {
        return new SchedulerRequest(COMMAND_STARTUP);
    }

    public static SchedulerRequest createUnregisterRequest(String jobName, String groupName) {
        return new SchedulerRequest(COMMAND_UNREGISTER, jobName, groupName);
    }

    public SchedulerRequest() {
    }

    public SchedulerRequest(String command) {
        this._command = command;
    }

    public SchedulerRequest(String command, String jobName, String groupName) {
        this._command = command;
        this._jobName = jobName;
        this._groupName = groupName;
    }

    public SchedulerRequest(String command, String jobName, String groupName, long interval, Date startDate, Date endDate, String description, String destination, String messageBody) {
        this._command = command;
        this._jobName = jobName;
        this._groupName = groupName;
        this._triggerType = TriggerType.SIMPLE;
        this._interval = interval;
        this._startDate = startDate;
        this._endDate = endDate;
        this._description = description;
        this._destination = destination;
        this._messageBody = messageBody;
    }

    public SchedulerRequest(String command, String jobName, String groupName, String cronText, Date startDate, Date endDate, String description, String destination, String messageBody) {
        this._command = command;
        this._jobName = jobName;
        this._groupName = groupName;
        this._triggerType = TriggerType.CRON;
        this._cronText = cronText;
        this._startDate = startDate;
        this._endDate = endDate;
        this._description = description;
        this._destination = destination;
        this._messageBody = messageBody;
    }

    public String getCommand() {
        return this._command;
    }

    public String getCronText() {
        return this._cronText;
    }

    public String getDescription() {
        return this._description;
    }

    public String getDestination() {
        return this._destination;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public long getInterval() {
        return this._interval;
    }

    public String getJobName() {
        return this._jobName;
    }

    public String getMessageBody() {
        return this._messageBody;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public TriggerType getTriggerType() {
        return this._triggerType;
    }

    public void setCommand(String command) {
        this._command = command;
    }

    public void setCronText(String cronText) {
        this._cronText = cronText;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setDestination(String destination) {
        this._destination = destination;
    }

    public void setEndDate(Date endDate) {
        this._endDate = endDate;
    }

    public void setGroupName(String groupName) {
        this._groupName = groupName;
    }

    public void setInterval(long interval) {
        this._interval = interval;
    }

    public void setJobName(String jobName) {
        this._jobName = jobName;
    }

    public void setMessageBody(String messageBody) {
        this._messageBody = messageBody;
    }

    public void setStartDate(Date startDate) {
        this._startDate = startDate;
    }

    public void setTriggerType(TriggerType triggerType) {
        this._triggerType = triggerType;
    }
}

