/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentComparatorOrderBy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentComparator
implements Comparator<Document> {
    private boolean _asc;
    private boolean _caseSensitive;
    private List<DocumentComparatorOrderBy> _columns = new ArrayList<DocumentComparatorOrderBy>();

    public DocumentComparator() {
        this(true, false);
    }

    public DocumentComparator(boolean asc, boolean caseSensitive) {
        this._asc = asc;
        this._caseSensitive = caseSensitive;
    }

    public void addOrderBy(String name) {
        this.addOrderBy(name, this._asc, this._caseSensitive);
    }

    public void addOrderBy(String name, boolean asc, boolean caseSensitive) {
        DocumentComparatorOrderBy orderBy = new DocumentComparatorOrderBy(name, asc, caseSensitive);
        this._columns.add(orderBy);
    }

    @Override
    public int compare(Document doc1, Document doc2) {
        for (DocumentComparatorOrderBy orderBy : this._columns) {
            String value1 = doc1.get(orderBy.getName());
            String value2 = doc2.get(orderBy.getName());
            if (!orderBy.isAsc()) {
                String temp = value1;
                value1 = value2;
                value2 = temp;
            }
            int result = 0;
            if (value1 != null && value2 != null) {
                result = orderBy.isCaseSensitive() ? value1.compareTo(value2) : value1.compareToIgnoreCase(value2);
            }
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

