/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.messaging;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.messaging.SearchEngineCommand;
import java.io.Serializable;

public class SearchRequest
implements Serializable {
    private long _companyId;
    private Document _document;
    private int _end;
    private String _id;
    private Query _query;
    private SearchEngineCommand _searchEngineCommand;
    private Sort[] _sorts;
    private int _start;

    public static SearchRequest add(long companyId, Document document) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.ADD);
        searchRequest.setCompanyId(companyId);
        searchRequest.setDocument(document);
        return searchRequest;
    }

    public static SearchRequest delete(long companyId, String uid) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.DELETE);
        searchRequest.setCompanyId(companyId);
        searchRequest.setId(uid);
        return searchRequest;
    }

    public static SearchRequest deletePortletDocuments(long companyId, String portletId) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.DELETE_PORTLET_DOCUMENTS);
        searchRequest.setCompanyId(companyId);
        searchRequest.setId(portletId);
        return searchRequest;
    }

    public static SearchRequest search(long companyId, Query query, Sort[] sorts, int start, int end) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.SEARCH);
        searchRequest.setCompanyId(companyId);
        searchRequest.setQuery(query);
        searchRequest.setSorts(sorts);
        searchRequest.setStart(start);
        searchRequest.setEnd(end);
        return searchRequest;
    }

    public static SearchRequest update(long companyId, String uid, Document document) {
        SearchRequest searchRequest = new SearchRequest(SearchEngineCommand.UPDATE);
        searchRequest.setCompanyId(companyId);
        searchRequest.setId(uid);
        searchRequest.setDocument(document);
        return searchRequest;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public Document getDocument() {
        return this._document;
    }

    public int getEnd() {
        return this._end;
    }

    public String getId() {
        return this._id;
    }

    public Query getQuery() {
        return this._query;
    }

    public SearchEngineCommand getSearchEngineCommand() {
        return this._searchEngineCommand;
    }

    public Sort[] getSorts() {
        return this._sorts;
    }

    public int getStart() {
        return this._start;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setDocument(Document document) {
        this._document = document;
    }

    public void setEnd(int end) {
        this._end = end;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setQuery(Query query) {
        this._query = query;
    }

    public void setSorts(Sort[] sorts) {
        this._sorts = sorts;
    }

    public void setStart(int start) {
        this._start = start;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{searchEngineCommand=");
        sb.append((Object)this._searchEngineCommand);
        sb.append(", companyId=");
        sb.append(this._companyId);
        sb.append(", id=");
        sb.append(this._id);
        sb.append(", document=");
        sb.append(this._document);
        sb.append(", query=");
        sb.append(this._query);
        sb.append(", sorts=");
        sb.append(this._sorts);
        sb.append(", start=");
        sb.append(this._start);
        sb.append(", end=");
        sb.append(this._end);
        sb.append("}");
        return sb.toString();
    }

    private SearchRequest(SearchEngineCommand searchEngineCommand) {
        this._searchEngineCommand = searchEngineCommand;
    }
}

