/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.messaging.BaseSearchEngineMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchEngineCommand;
import com.liferay.portal.kernel.search.messaging.SearchRequest;

public class SearchWriterMessageListener
extends BaseSearchEngineMessageListener {
    private static Log _log = LogFactoryUtil.getLog(SearchWriterMessageListener.class);

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error("Unable to process message " + message, e);
        }
    }

    protected void doReceive(Message message) throws Exception {
        Object payload = message.getPayload();
        if (!(payload instanceof SearchRequest)) {
            return;
        }
        SearchRequest searchRequest = (SearchRequest)payload;
        SearchEngineCommand searchEngineCommand = searchRequest.getSearchEngineCommand();
        long companyId = searchRequest.getCompanyId();
        String id = searchRequest.getId();
        Document doc = searchRequest.getDocument();
        IndexWriter indexWriter = this.searchEngine.getWriter();
        if (searchEngineCommand.equals((Object)SearchEngineCommand.ADD)) {
            indexWriter.addDocument(companyId, doc);
        } else if (searchEngineCommand.equals((Object)SearchEngineCommand.DELETE)) {
            indexWriter.deleteDocument(companyId, id);
        } else if (searchEngineCommand.equals((Object)SearchEngineCommand.DELETE_PORTLET_DOCUMENTS)) {
            indexWriter.deletePortletDocuments(companyId, id);
        } else if (searchEngineCommand.equals((Object)SearchEngineCommand.UPDATE)) {
            indexWriter.updateDocument(companyId, id, doc);
        }
    }
}

