/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionMessages {
    public static final String KEY = SessionMessages.class.getName();

    public static void add(HttpServletRequest request, String key) {
        SessionMessages.add(request.getSession(), key);
    }

    public static void add(HttpSession session, String key) {
        Map<String, Object> messages = SessionMessages._getMessages(session);
        messages.put(key, key);
    }

    public static void add(HttpServletRequest request, String key, Object value) {
        SessionMessages.add(request.getSession(), key, value);
    }

    public static void add(HttpSession session, String key, Object value) {
        Map<String, Object> messages = SessionMessages._getMessages(session);
        messages.put(key, value);
    }

    public static void clear(HttpServletRequest request) {
        SessionMessages.clear(request.getSession());
    }

    public static void clear(HttpSession session) {
        Map<String, Object> messages = SessionMessages._getMessages(session);
        messages.clear();
    }

    public static boolean contains(HttpServletRequest request, String key) {
        return SessionMessages.contains(request.getSession(), key);
    }

    public static boolean contains(HttpSession session, String key) {
        Map<String, Object> messages = SessionMessages._getMessages(session);
        return messages.containsKey(key);
    }

    public static Object get(HttpServletRequest request, String key) {
        return SessionMessages.get(request.getSession(), key);
    }

    public static Object get(HttpSession session, String key) {
        Map<String, Object> messages = SessionMessages._getMessages(session);
        return messages.get(key);
    }

    public static boolean isEmpty(HttpServletRequest request) {
        return SessionMessages.isEmpty(request.getSession());
    }

    public static boolean isEmpty(HttpSession session) {
        Map<String, Object> messages = SessionMessages._getMessages(session);
        return messages.isEmpty();
    }

    public static Iterator<String> iterator(HttpServletRequest request) {
        return SessionMessages.iterator(request.getSession());
    }

    public static Iterator<String> iterator(HttpSession session) {
        Map<String, Object> messages = SessionMessages._getMessages(session);
        return Collections.unmodifiableSet(messages.keySet()).iterator();
    }

    public static void print(HttpServletRequest request) {
        SessionMessages.print(request.getSession());
    }

    public static void print(HttpSession session) {
        Iterator<String> itr = SessionMessages.iterator(session);
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    public static int size(HttpServletRequest request) {
        return SessionMessages.size(request.getSession());
    }

    public static int size(HttpSession session) {
        Map<String, Object> messages = SessionMessages._getMessages(session);
        return messages.size();
    }

    private static Map<String, Object> _getMessages(HttpSession session) {
        LinkedHashMap<String, Object> messages = null;
        try {
            messages = (LinkedHashMap<String, Object>)session.getAttribute(KEY);
            if (messages == null) {
                messages = new LinkedHashMap();
                session.setAttribute(KEY, messages);
            }
        }
        catch (IllegalStateException ise) {
            messages = new LinkedHashMap<String, Object>();
        }
        return messages;
    }

    public static void add(PortletRequest portletRequest, String key) {
        SessionMessages.add(portletRequest.getPortletSession(), key);
    }

    public static void add(PortletSession portletSession, String key) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession);
        messages.put(key, key);
    }

    public static void add(PortletRequest portletRequest, String key, Object value) {
        SessionMessages.add(portletRequest.getPortletSession(), key, value);
    }

    public static void add(PortletSession portletSession, String key, Object value) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession);
        messages.put(key, value);
    }

    public static void clear(PortletRequest portletRequest) {
        SessionMessages.clear(portletRequest.getPortletSession());
    }

    public static void clear(PortletSession portletSession) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession);
        messages.clear();
    }

    public static boolean contains(PortletRequest portletRequest, String key) {
        return SessionMessages.contains(portletRequest.getPortletSession(), key);
    }

    public static boolean contains(PortletSession portletSession, String key) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession);
        return messages.containsKey(key);
    }

    public static Object get(PortletRequest portletRequest, String key) {
        return SessionMessages.get(portletRequest.getPortletSession(), key);
    }

    public static Object get(PortletSession portletSession, String key) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession);
        return messages.get(key);
    }

    public static boolean isEmpty(PortletRequest portletRequest) {
        return SessionMessages.isEmpty(portletRequest.getPortletSession());
    }

    public static boolean isEmpty(PortletSession portletSession) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession);
        return messages.isEmpty();
    }

    public static Iterator<String> iterator(PortletRequest portletRequest) {
        return SessionMessages.iterator(portletRequest.getPortletSession());
    }

    public static Iterator<String> iterator(PortletSession portletSession) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession);
        return Collections.unmodifiableSet(messages.keySet()).iterator();
    }

    public static void print(PortletRequest portletRequest) {
        SessionMessages.print(portletRequest.getPortletSession());
    }

    public static void print(PortletSession portletSession) {
        Iterator<String> itr = SessionMessages.iterator(portletSession);
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    public static int size(PortletRequest portletRequest) {
        return SessionMessages.size(portletRequest.getPortletSession());
    }

    public static int size(PortletSession portletSession) {
        Map<String, Object> messages = SessionMessages._getMessages(portletSession);
        return messages.size();
    }

    private static Map<String, Object> _getMessages(PortletSession portletSession) {
        LinkedHashMap<String, Object> messages = null;
        try {
            messages = (LinkedHashMap<String, Object>)portletSession.getAttribute(KEY);
            if (messages == null) {
                messages = new LinkedHashMap();
                portletSession.setAttribute(KEY, messages);
            }
        }
        catch (IllegalStateException ise) {
            messages = new LinkedHashMap<String, Object>();
        }
        return messages;
    }
}

