/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.StringServletOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class StringServletResponse
extends HttpServletResponseWrapper {
    private static Log _log = LogFactoryUtil.getLog(StringServletResponse.class);
    private int _bufferSize;
    private boolean _callGetOutputStream;
    private boolean _callGetWriter;
    private String _contentType;
    private PrintWriter _printWriter;
    private ServletOutputStream _servletOutputStream;
    private int _status = 200;
    private String _string;
    private UnsyncByteArrayOutputStream _unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
    private UnsyncStringWriter _unsyncStringWriter;

    public StringServletResponse(HttpServletResponse response) {
        super(response);
        this._servletOutputStream = new StringServletOutputStream(this._unsyncByteArrayOutputStream);
        this._unsyncStringWriter = new UnsyncStringWriter(true);
        this._printWriter = new PrintWriter(this._unsyncStringWriter);
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public String getContentType() {
        return this._contentType;
    }

    public ServletOutputStream getOutputStream() {
        this._callGetOutputStream = true;
        return this._servletOutputStream;
    }

    public int getStatus() {
        return this._status;
    }

    public String getString() {
        if (this._string != null) {
            return this._string;
        }
        if (this._callGetOutputStream) {
            try {
                return this._unsyncByteArrayOutputStream.toString("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                _log.error(uee, uee);
                return "";
            }
        }
        if (this._callGetWriter) {
            return this._unsyncStringWriter.toString();
        }
        return "";
    }

    public UnsyncByteArrayOutputStream getUnsyncByteArrayOutputStream() {
        return this._unsyncByteArrayOutputStream;
    }

    public PrintWriter getWriter() {
        this._callGetWriter = true;
        return this._printWriter;
    }

    public boolean isCalledGetOutputStream() {
        return this._callGetOutputStream;
    }

    public void recycle() {
        this._callGetOutputStream = false;
        this._callGetWriter = false;
        this._status = 200;
        this._string = null;
        this._unsyncByteArrayOutputStream.reset();
        this._unsyncStringWriter = new UnsyncStringWriter(true);
        this._printWriter = new PrintWriter(this._unsyncStringWriter);
    }

    public void resetBuffer() {
        if (this._callGetOutputStream) {
            this._unsyncByteArrayOutputStream.reset();
        } else if (this._callGetWriter) {
            this._unsyncStringWriter.reset();
        }
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
        super.setContentType(contentType);
    }

    public void setLocale(Locale locale) {
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public void setString(String string) {
        this._string = string;
    }
}

