/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.StagnantRowException;
import com.liferay.portal.kernel.upgrade.util.ValueMapper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;

public class IdReplacer {
    private static Log _log = LogFactoryUtil.getLog(IdReplacer.class);

    public static String replaceLongIds(String s, String begin, ValueMapper valueMapper) throws Exception {
        if (s == null || begin == null || valueMapper == null || valueMapper.size() == 0) {
            return s;
        }
        char[] charArray = s.toCharArray();
        StringBuilder sb = new StringBuilder(s.length());
        int pos = 0;
        while (true) {
            int x = s.indexOf(begin, pos);
            int y = IdReplacer._getEndPos(charArray, x + begin.length());
            if (x == -1 || y == -1) break;
            sb.append(s.substring(pos, x + begin.length()));
            String oldString = s.substring(x + begin.length(), y);
            if (Validator.isNotNull(oldString)) {
                Long newValue;
                Long oldValue;
                block6: {
                    oldValue = new Long(GetterUtil.getLong(oldString));
                    newValue = null;
                    try {
                        newValue = (Long)valueMapper.getNewValue(oldValue);
                    }
                    catch (StagnantRowException sre) {
                        if (!_log.isWarnEnabled()) break block6;
                        _log.warn(sre);
                    }
                }
                if (newValue == null) {
                    newValue = oldValue;
                }
                sb.append(newValue);
            }
            pos = y;
        }
        sb.append(s.substring(pos, s.length()));
        return sb.toString();
    }

    public String replaceLongIds(String s, String begin, String end, ValueMapper valueMapper) throws Exception {
        if (s == null || begin == null || end == null || valueMapper == null || valueMapper.size() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int pos = 0;
        while (true) {
            Long newValue;
            Long oldValue;
            int y;
            block5: {
                int x = s.indexOf(begin, pos);
                y = s.indexOf(end, x + begin.length());
                if (x == -1 || y == -1) break;
                sb.append(s.substring(pos, x + begin.length()));
                oldValue = new Long(GetterUtil.getLong(s.substring(x + begin.length(), y)));
                newValue = null;
                try {
                    newValue = (Long)valueMapper.getNewValue(oldValue);
                }
                catch (StagnantRowException sre) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn(sre);
                }
            }
            if (newValue == null) {
                newValue = oldValue;
            }
            sb.append(newValue);
            pos = y;
        }
        sb.append(s.substring(pos, s.length()));
        return sb.toString();
    }

    private static int _getEndPos(char[] charArray, int pos) {
        while (pos < charArray.length && Character.isDigit(charArray[pos])) {
            ++pos;
        }
        return pos;
    }
}

