/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassLoaderObjectInputStream;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Base64 {
    private static Log _log = LogFactoryUtil.getLog(Base64.class);

    protected static char getChar(int sixbit) {
        if (sixbit >= 0 && sixbit <= 25) {
            return (char)(65 + sixbit);
        }
        if (sixbit >= 26 && sixbit <= 51) {
            return (char)(97 + (sixbit - 26));
        }
        if (sixbit >= 52 && sixbit <= 61) {
            return (char)(48 + (sixbit - 52));
        }
        if (sixbit == 62) {
            return '+';
        }
        return sixbit != 63 ? (char)'?' : '/';
    }

    protected static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        return c != '=' ? -1 : 0;
    }

    public static String encode(byte[] raw) {
        StringBuilder encoded = new StringBuilder();
        for (int i = 0; i < raw.length; i += 3) {
            encoded.append(Base64.encodeBlock(raw, i));
        }
        return encoded.toString();
    }

    protected static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack < 2 ? slack : 2;
        for (int i = 0; i <= end; ++i) {
            int b = raw[offset + i];
            int neuter = b >= 0 ? b : b + 256;
            block += neuter << 8 * (2 - i);
        }
        char[] base64 = new char[4];
        for (int i = 0; i < 4; ++i) {
            int sixbit = block >>> 6 * (3 - i) & 0x3F;
            base64[i] = Base64.getChar(sixbit);
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    public static byte[] decode(String base64) {
        if (Validator.isNull(base64)) {
            return new byte[0];
        }
        int pad = 0;
        int i = base64.length() - 1;
        while (base64.charAt(i) == '=') {
            ++pad;
            --i;
        }
        int length = base64.length() * 6 / 8 - pad;
        byte[] raw = new byte[length];
        int rawindex = 0;
        for (int i2 = 0; i2 < base64.length(); i2 += 4) {
            int block = (Base64.getValue(base64.charAt(i2)) << 18) + (Base64.getValue(base64.charAt(i2 + 1)) << 12) + (Base64.getValue(base64.charAt(i2 + 2)) << 6) + Base64.getValue(base64.charAt(i2 + 3));
            for (int j = 0; j < 3 && rawindex + j < raw.length; ++j) {
                raw[rawindex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
            }
            rawindex += 3;
        }
        return raw;
    }

    public static String objectToString(Object o) {
        if (o == null) {
            return null;
        }
        UnsyncByteArrayOutputStream ubaos = new UnsyncByteArrayOutputStream(32000);
        try {
            ObjectOutputStream os = new ObjectOutputStream(ubaos);
            os.flush();
            os.writeObject(o);
            os.flush();
        }
        catch (IOException e) {
            _log.error(e, e);
        }
        return Base64.encode(ubaos.toByteArray());
    }

    public static Object stringToObject(String s) {
        return Base64.stringToObject(s, null);
    }

    public static Object stringToObject(String s, ClassLoader classLoader) {
        if (s == null) {
            return null;
        }
        byte[] bytes = Base64.decode(s);
        UnsyncByteArrayInputStream ubais = new UnsyncByteArrayInputStream(bytes);
        try {
            ObjectInputStream is = null;
            is = classLoader == null ? new ObjectInputStream(ubais) : new ClassLoaderObjectInputStream(ubais, classLoader);
            return is.readObject();
        }
        catch (Exception e) {
            _log.error(e, e);
            return null;
        }
    }
}

