/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import java.text.DateFormat;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    public static final String ISO_8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";

    public static int compareTo(Date date1, Date date2) {
        return DateUtil.compareTo(date1, date2, false);
    }

    public static int compareTo(Date date1, Date date2, boolean ignoreMilliseconds) {
        if (date1 != null && date2 == null) {
            return -1;
        }
        if (date1 == null && date2 != null) {
            return 1;
        }
        if (date1 == null && date2 == null) {
            return 0;
        }
        long time1 = date1.getTime();
        long time2 = date2.getTime();
        if (ignoreMilliseconds) {
            time1 /= 1000L;
            time2 /= 1000L;
        }
        if (time1 == time2) {
            return 0;
        }
        if (time1 < time2) {
            return -1;
        }
        return 1;
    }

    public static boolean equals(Date date1, Date date2) {
        return DateUtil.compareTo(date1, date2) == 0;
    }

    public static boolean equals(Date date1, Date date2, boolean ignoreMilliseconds) {
        if (!ignoreMilliseconds) {
            return DateUtil.equals(date1, date2);
        }
        long time1 = 0L;
        if (date1 != null) {
            time1 = date1.getTime() / 1000L;
        }
        long time2 = 0L;
        if (date2 != null) {
            time2 = date2.getTime() / 1000L;
        }
        return time1 == time2;
    }

    public static String getCurrentDate(String pattern, Locale locale) {
        return DateUtil.getDate(new Date(), pattern, locale);
    }

    public static String getCurrentDate(String pattern, Locale locale, TimeZone timeZone) {
        return DateUtil.getDate(new Date(), pattern, locale, timeZone);
    }

    public static String getDate(Date date, String pattern, Locale locale) {
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat(pattern, locale);
        return dateFormat.format(date);
    }

    public static String getDate(Date date, String pattern, Locale locale, TimeZone timeZone) {
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat(pattern, locale, timeZone);
        return dateFormat.format(date);
    }

    public static int getDaysBetween(Date startDate, Date endDate, TimeZone timeZone) {
        int offset = timeZone.getRawOffset();
        GregorianCalendar startCal = new GregorianCalendar(timeZone);
        startCal.setTime(startDate);
        ((Calendar)startCal).add(14, offset);
        GregorianCalendar endCal = new GregorianCalendar(timeZone);
        endCal.setTime(endDate);
        ((Calendar)endCal).add(14, offset);
        int daysBetween = 0;
        while (CalendarUtil.beforeByDay(startCal.getTime(), endCal.getTime())) {
            ((Calendar)startCal).add(5, 1);
            ++daysBetween;
        }
        return daysBetween;
    }

    public static DateFormat getISOFormat() {
        return DateUtil.getISOFormat("");
    }

    public static DateFormat getISOFormat(String text) {
        String pattern = "";
        pattern = text.length() == 8 ? "yyyyMMdd" : (text.length() == 12 ? "yyyyMMddHHmm" : (text.length() == 13 ? "yyyyMMdd'T'HHmm" : (text.length() == 14 ? "yyyyMMddHHmmss" : (text.length() == 15 ? "yyyyMMdd'T'HHmmss" : (text.length() > 8 && text.charAt(8) == 'T' ? "yyyyMMdd'T'HHmmssz" : "yyyyMMddHHmmssz")))));
        return DateFormatFactoryUtil.getSimpleDateFormat(pattern);
    }

    public static DateFormat getISO8601Format() {
        return DateFormatFactoryUtil.getSimpleDateFormat(ISO_8601_PATTERN);
    }

    public static DateFormat getUTCFormat() {
        return DateUtil.getUTCFormat("");
    }

    public static DateFormat getUTCFormat(String text) {
        String pattern = "";
        pattern = text.length() == 8 ? "yyyyMMdd" : (text.length() == 12 ? "yyyyMMddHHmm" : (text.length() == 13 ? "yyyyMMdd'T'HHmm" : (text.length() == 14 ? "yyyyMMddHHmmss" : (text.length() == 15 ? "yyyyMMdd'T'HHmmss" : "yyyyMMdd'T'HHmmssz"))));
        return DateFormatFactoryUtil.getSimpleDateFormat(pattern, TimeZone.getTimeZone("UTC"));
    }

    public static Date newDate() {
        return new Date();
    }

    public static Date newDate(long date) {
        return new Date(date);
    }
}

