/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPDetector {
    private static Log _log = LogFactoryUtil.getLog(IPDetector.class);
    private static Boolean _prefersV4;
    private static Boolean _prefersV6;
    private static Boolean _suppportsV6;

    public static boolean isPrefersV4() {
        if (_prefersV4 == null) {
            _prefersV4 = Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack"));
        }
        return _prefersV4;
    }

    public static boolean isPrefersV6() {
        if (_prefersV6 == null) {
            _prefersV6 = Boolean.valueOf(System.getProperty("java.net.preferIPv6Stack"));
        }
        return _prefersV6;
    }

    public static boolean isSupportsV6() {
        if (_suppportsV6 == null) {
            _suppportsV6 = Boolean.FALSE;
            try {
                InetAddress[] inetAddresses;
                for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName("localhost")) {
                    if (!inetAddress.getHostAddress().contains(":")) continue;
                    _suppportsV6 = Boolean.TRUE;
                    break;
                }
            }
            catch (UnknownHostException uhe) {
                _log.error(uhe, uhe);
            }
        }
        return _suppportsV6;
    }
}

