/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListUtil {
    public static <E> List<E> copy(List<E> master) {
        if (master == null) {
            return null;
        }
        return new ArrayList<E>(master);
    }

    public static <E> void copy(List<E> master, List<? super E> copy) {
        if (master == null || copy == null) {
            return;
        }
        copy.clear();
        copy.addAll(master);
    }

    public static void distinct(List<?> list) {
        ListUtil.distinct(list, null);
    }

    public static <E> void distinct(List<E> list, Comparator<E> comparator) {
        if (list == null || list.size() == 0) {
            return;
        }
        TreeSet<E> set = null;
        set = comparator == null ? new TreeSet<E>() : new TreeSet<E>(comparator);
        Iterator<E> itr = list.iterator();
        while (itr.hasNext()) {
            E obj = itr.next();
            if (set.contains(obj)) {
                itr.remove();
                continue;
            }
            set.add(obj);
        }
    }

    public static <E> List<E> fromArray(E[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList();
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    public static <E> List<E> fromCollection(Collection<E> c) {
        if (c != null && List.class.isAssignableFrom(c.getClass())) {
            return (List)c;
        }
        if (c == null || c.size() == 0) {
            return new ArrayList();
        }
        ArrayList<E> list = new ArrayList<E>(c.size());
        list.addAll(c);
        return list;
    }

    public static <E> List<E> fromEnumeration(Enumeration<E> enu) {
        ArrayList<E> list = new ArrayList<E>();
        while (enu.hasMoreElements()) {
            E obj = enu.nextElement();
            list.add(obj);
        }
        return list;
    }

    public static List<String> fromFile(File file) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new FileReader(file));
        String s = "";
        while ((s = unsyncBufferedReader.readLine()) != null) {
            list.add(s);
        }
        unsyncBufferedReader.close();
        return list;
    }

    public static List<String> fromFile(String fileName) throws IOException {
        return ListUtil.fromFile(new File(fileName));
    }

    public static List<String> fromString(String s) {
        return ListUtil.fromArray(StringUtil.split(s, "\n"));
    }

    public static <E> List<E> sort(List<E> list) {
        return ListUtil.sort(list, null);
    }

    public static <E> List<E> sort(List<E> list, Comparator<? super E> comparator) {
        if (UnmodifiableList.class.isAssignableFrom(list.getClass())) {
            list = ListUtil.copy(list);
        }
        Collections.sort(list, comparator);
        return list;
    }

    public static <E> List<E> subList(List<E> list, int start, int end) {
        ArrayList<E> newList = new ArrayList<E>();
        int normalizedSize = list.size() - 1;
        if (start < 0 || start > normalizedSize || end < 0 || start > end) {
            return newList;
        }
        for (int i = start; i < end && i <= normalizedSize; ++i) {
            newList.add(list.get(i));
        }
        return newList;
    }

    public static List<Boolean> toList(boolean[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>(array.length);
        for (boolean value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Double> toList(double[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Double> list = new ArrayList<Double>(array.length);
        for (double value : array) {
            list.add(value);
        }
        return list;
    }

    public static <E> List<E> toList(E[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptyList();
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    public static List<Float> toList(float[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Float> list = new ArrayList<Float>(array.length);
        for (float value : array) {
            list.add(Float.valueOf(value));
        }
        return list;
    }

    public static List<Integer> toList(int[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Long> toList(long[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Long> list = new ArrayList<Long>(array.length);
        for (long value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Short> toList(short[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Short> list = new ArrayList<Short>(array.length);
        for (short value : array) {
            list.add(value);
        }
        return list;
    }

    public static String toString(List<?> list, String param) {
        return ListUtil.toString(list, param, ",");
    }

    public static String toString(List<?> list, String param, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Object bean = list.get(i);
            Object value = BeanPropertiesUtil.getObject(bean, param);
            if (value == null) {
                value = "";
            }
            sb.append(value.toString());
            if (i + 1 == list.size()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }
}

