/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.NullWrapper;
import com.liferay.portal.kernel.util.PrimitiveWrapper;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MethodInvoker {
    private static Log _log = LogFactoryUtil.getLog(MethodInvoker.class);
    private static Map<String, Class<?>> _primitiveTypeMap = new HashMap();

    public static Object invoke(MethodWrapper methodWrapper) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchFieldException, NoSuchMethodException {
        return MethodInvoker.invoke(methodWrapper, true);
    }

    public static Object invoke(MethodWrapper methodWrapper, boolean newInstance) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchFieldException, NoSuchMethodException {
        Object targetObject = null;
        if (newInstance) {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            targetObject = contextClassLoader.loadClass(methodWrapper.getClassName()).newInstance();
        }
        Object[] methodAndArguments = MethodInvoker._lookupMethodAndArguments(methodWrapper, targetObject);
        Object returnObject = null;
        if (methodAndArguments[0] != null) {
            Method method = (Method)methodAndArguments[0];
            Object[] arguments = (Object[])methodAndArguments[1];
            returnObject = method.invoke(targetObject, arguments);
        }
        return returnObject;
    }

    public static Object invoke(MethodWrapper methodWrapper, Object targetObject) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, NoSuchMethodException {
        Object[] methodAndArguments = MethodInvoker._lookupMethodAndArguments(methodWrapper, targetObject);
        Object returnObject = null;
        if (methodAndArguments[0] != null) {
            Method method = (Method)methodAndArguments[0];
            Object[] arguments = (Object[])methodAndArguments[1];
            returnObject = method.invoke(targetObject, arguments);
        }
        return returnObject;
    }

    private static Object[] _lookupMethodAndArguments(MethodWrapper methodWrapper, Object targetObject) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, NoSuchMethodException {
        Method method;
        Object[] arguments;
        Object[] methodAndArguments;
        block13: {
            methodAndArguments = new Object[2];
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            String className = methodWrapper.getClassName();
            String methodName = methodWrapper.getMethodName();
            arguments = methodWrapper.getArguments();
            String[] argumentClassNames = methodWrapper.getArgumentClassNames();
            ArrayList parameterTypes = new ArrayList();
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] == null) {
                    _log.error("Cannot invoke " + className + " " + methodName + " on position " + i + " because it is null");
                }
                Class<?> argClass = null;
                if (argumentClassNames != null) {
                    argClass = _primitiveTypeMap.get(argumentClassNames[i]);
                    if (argClass == null) {
                        argClass = Class.forName(argumentClassNames[i], true, contextClassLoader);
                    }
                } else {
                    argClass = arguments[i].getClass();
                }
                if (ClassUtil.isSubclass(argClass, PrimitiveWrapper.class)) {
                    parameterTypes.add((Class)argClass.getField("TYPE").get(arguments[i]));
                    MethodKey methodKey = new MethodKey(argClass.getName(), "getValue", null);
                    Method method2 = MethodCache.get(methodKey);
                    arguments[i] = method2.invoke(arguments[i], (Object[])null);
                    continue;
                }
                if (arguments[i] instanceof NullWrapper) {
                    Class<?> wrappedClass;
                    NullWrapper nullWrapper = (NullWrapper)arguments[i];
                    String wrappedClassName = nullWrapper.getClassName();
                    if (wrappedClassName.startsWith("[") && wrappedClassName.endsWith(";")) {
                        wrappedClassName = wrappedClassName.substring(2, wrappedClassName.length() - 1);
                        wrappedClass = contextClassLoader.loadClass(wrappedClassName);
                        parameterTypes.add(Array.newInstance(wrappedClass, 0).getClass());
                    } else {
                        wrappedClass = contextClassLoader.loadClass(wrappedClassName);
                        parameterTypes.add(wrappedClass);
                    }
                    arguments[i] = null;
                    continue;
                }
                parameterTypes.add(argClass);
            }
            method = null;
            try {
                MethodKey methodKey = new MethodKey(methodWrapper.getClassName(), methodWrapper.getMethodName(), parameterTypes.toArray(new Class[parameterTypes.size()]));
                method = MethodCache.get(methodKey);
            }
            catch (NoSuchMethodException nsme) {
                Class<?> classObject = null;
                classObject = targetObject == null ? contextClassLoader.loadClass(className) : targetObject.getClass();
                Method[] methods = classObject.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] methodParameterTypes = methods[i].getParameterTypes();
                    if (!methods[i].getName().equals(methodName) || methodParameterTypes.length != parameterTypes.size()) continue;
                    boolean correctParams = true;
                    for (int j = 0; j < parameterTypes.size(); ++j) {
                        Class<?> b;
                        Class a = (Class)parameterTypes.get(j);
                        if (ClassUtil.isSubclass(a, b = methodParameterTypes[j])) continue;
                        correctParams = false;
                        break;
                    }
                    if (!correctParams) continue;
                    method = methods[i];
                    break;
                }
                if (method != null) break block13;
                throw nsme;
            }
        }
        methodAndArguments[0] = method;
        methodAndArguments[1] = arguments;
        return methodAndArguments;
    }

    static {
        _primitiveTypeMap.put("char", Character.TYPE);
        _primitiveTypeMap.put("boolean", Boolean.TYPE);
        _primitiveTypeMap.put("byte", Byte.TYPE);
        _primitiveTypeMap.put("double", Double.TYPE);
        _primitiveTypeMap.put("float", Float.TYPE);
        _primitiveTypeMap.put("int", Integer.TYPE);
        _primitiveTypeMap.put("long", Long.TYPE);
        _primitiveTypeMap.put("short", Short.TYPE);
    }
}

