/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.io.Serializable;
import java.lang.reflect.Method;

public class MethodWrapper
implements Serializable {
    private String _className;
    private String _methodName;
    private String[] _argumentClassNames;
    private Object[] _arguments;

    public MethodWrapper(String className, String methodName) {
        this(className, methodName, new Object[0]);
    }

    public MethodWrapper(String className, String methodName, Object argument) {
        this(className, methodName, new Object[]{argument});
    }

    public MethodWrapper(String className, String methodName, Object[] arguments) {
        this._className = className;
        this._methodName = methodName;
        this._arguments = arguments;
    }

    public MethodWrapper(Method method, Object[] arguments) {
        this(method.getDeclaringClass().getName(), method.getName(), arguments);
        this._argumentClassNames = new String[arguments.length];
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            this._argumentClassNames[i] = parameterTypes[i].getName();
        }
    }

    public String getClassName() {
        return this._className;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public Object[] getArgs() {
        return this.getArguments();
    }

    public String[] getArgumentClassNames() {
        return this._argumentClassNames;
    }

    public Object[] getArguments() {
        Object[] arguments = new Object[this._arguments.length];
        System.arraycopy(this._arguments, 0, arguments, 0, this._arguments.length);
        return arguments;
    }
}

