/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.SafeProperties;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesUtil {
    public static void copyProperties(Properties from, Properties to) {
        for (Map.Entry<Object, Object> entry : from.entrySet()) {
            to.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static Properties fromMap(Map<String, String> map) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            properties.setProperty(key, value);
        }
        return properties;
    }

    public static Properties fromMap(Properties properties) {
        return properties;
    }

    public static void fromProperties(Properties properties, Map<String, String> map) {
        map.clear();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static Properties getProperties(Properties properties, String prefix, boolean removePrefix) {
        Properties subProperties = new Properties();
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            if (!key.startsWith(prefix)) continue;
            String value = properties.getProperty(key);
            if (removePrefix) {
                key = key.substring(prefix.length());
            }
            subProperties.setProperty(key, value);
        }
        return subProperties;
    }

    public static String list(Map<String, String> map) {
        Properties properties = PropertiesUtil.fromMap(map);
        return PropertiesUtil.list(properties);
    }

    public static void list(Map<String, String> map, PrintStream out) {
        Properties properties = PropertiesUtil.fromMap(map);
        properties.list(out);
    }

    public static void list(Map<String, String> map, PrintWriter out) {
        Properties properties = PropertiesUtil.fromMap(map);
        properties.list(out);
    }

    public static String list(Properties properties) {
        UnsyncByteArrayOutputStream ubaos = new UnsyncByteArrayOutputStream();
        PrintStream ps = new PrintStream(ubaos);
        properties.list(ps);
        return ubaos.toString();
    }

    public static void load(Properties p, String s) throws IOException {
        if (Validator.isNotNull(s)) {
            s = UnicodeFormatter.toString(s);
            s = StringUtil.replace(s, "\\u003d", "=");
            s = StringUtil.replace(s, "\\u000a", "\n");
            s = StringUtil.replace(s, "\\u0021", "!");
            s = StringUtil.replace(s, "\\u0023", "#");
            s = StringUtil.replace(s, "\\u0020", " ");
            s = StringUtil.replace(s, "\\u005c", "\\");
            p.load(new UnsyncByteArrayInputStream(s.getBytes()));
            ArrayList<?> propertyNames = Collections.list(p.propertyNames());
            for (int i = 0; i < propertyNames.size(); ++i) {
                String key = (String)propertyNames.get(i);
                String value = p.getProperty(key);
                if (value == null) continue;
                value = value.trim();
                p.setProperty(key, value);
            }
        }
    }

    public static Properties load(String s) throws IOException {
        Properties p = new Properties();
        PropertiesUtil.load(p, s);
        return p;
    }

    public static void merge(Properties p1, Properties p2) {
        Enumeration<?> enu = p2.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = p2.getProperty(key);
            p1.setProperty(key, value);
        }
    }

    public static String toString(Properties p) {
        SafeProperties safeProperties = null;
        if (p instanceof SafeProperties) {
            safeProperties = (SafeProperties)p;
        }
        StringBuilder sb = new StringBuilder();
        Enumeration<?> enu = p.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            sb.append(key);
            sb.append("=");
            if (safeProperties != null) {
                sb.append(safeProperties.getEncodedProperty(key));
            } else {
                sb.append(p.getProperty(key));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void trimKeys(Properties p) {
        Enumeration<?> enu = p.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = p.getProperty(key);
            String trimmedKey = key.trim();
            if (key.equals(trimmedKey)) continue;
            p.remove(key);
            p.setProperty(trimmedKey, value);
        }
    }
}

