/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

public class StringBundler {
    private static final int _DEFAULT_ARRAY_CAPACITY = 16;
    private static final String _FALSE = "false";
    private static final String _TRUE = "true";
    private String[] _array;
    private int _arrayIndex;

    public StringBundler() {
        this._array = new String[16];
    }

    public StringBundler(int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        this._array = new String[initialCapacity];
    }

    public StringBundler(String s) {
        this._array = new String[16];
        this._array[0] = s;
        this._arrayIndex = 1;
    }

    public StringBundler append(boolean b) {
        if (b) {
            return this.append(_TRUE);
        }
        return this.append(_FALSE);
    }

    public StringBundler append(double d) {
        return this.append(Double.toString(d));
    }

    public StringBundler append(float f) {
        return this.append(Float.toString(f));
    }

    public StringBundler append(int i) {
        return this.append(Integer.toString(i));
    }

    public StringBundler append(long l) {
        return this.append(Long.toString(l));
    }

    public StringBundler append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public StringBundler append(String s) {
        if (s == null) {
            s = "null";
        }
        if (this._arrayIndex >= this._array.length) {
            this.expandCapacity();
        }
        this._array[this._arrayIndex++] = s;
        return this;
    }

    public int capacity() {
        return this._array.length;
    }

    public int index() {
        return this._arrayIndex;
    }

    public void setIndex(int newIndex) {
        if (newIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(newIndex);
        }
        if (newIndex > this._array.length) {
            String[] newArray = new String[newIndex];
            System.arraycopy(this._array, 0, newArray, 0, this._arrayIndex);
            this._array = newArray;
        }
        if (this._arrayIndex < newIndex) {
            for (int i = this._arrayIndex; i < newIndex; ++i) {
                this._array[i] = "";
            }
        }
        if (this._arrayIndex > newIndex) {
            for (int i = newIndex; i < this._arrayIndex; ++i) {
                this._array[i] = null;
            }
        }
        this._arrayIndex = newIndex;
    }

    public String stringAt(int index) {
        if (index >= this._arrayIndex) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._array[index];
    }

    public String toString() {
        if (this._arrayIndex == 0) {
            return "";
        }
        String s = null;
        if (this._arrayIndex <= 3) {
            s = this._array[0];
            for (int i = 1; i < this._arrayIndex; ++i) {
                s = s.concat(this._array[i]);
            }
        } else {
            int length = 0;
            for (int i = 0; i < this._arrayIndex; ++i) {
                length += this._array[i].length();
            }
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < this._arrayIndex; ++i) {
                sb.append(this._array[i]);
            }
            s = sb.toString();
        }
        return s;
    }

    protected void expandCapacity() {
        String[] newArray = new String[this._array.length << 1];
        System.arraycopy(this._array, 0, newArray, 0, this._arrayIndex);
        this._array = newArray;
    }
}

