/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.PageLock;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.parser.MarkupParser;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.WikiAttachmentProvider;
import com.ecyrd.jspwiki.providers.WikiPageProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class PageRenamer {
    private static final Logger log = Logger.getLogger((Class)PageRenamer.class);
    private final WikiEngine m_wikiEngine;
    private static final PatternMatcher MATCHER = new Perl5Matcher();
    private boolean m_camelCaseLink;
    private boolean m_matchEnglishPlurals;
    private static final String LONG_LINK_PATTERN = "\\[([\\w\\s]+\\|)?([\\w\\s\\+-/\\?&;@:=%\\#<>$\\.,\\(\\)'\\*]+)?\\]";
    private static final String CAMELCASE_LINK_PATTERN = "([[:upper:]]+[[:lower:]]+[[:upper:]]+[[:alnum:]]*)";
    private Pattern m_longLinkPattern = null;
    private Pattern m_camelCaseLinkPattern = null;

    public PageRenamer(WikiEngine engine, Properties props) {
        this.m_wikiEngine = engine;
        this.m_matchEnglishPlurals = TextUtil.getBooleanProperty(props, "jspwiki.translatorReader.matchEnglishPlurals", false);
        this.m_camelCaseLink = TextUtil.getBooleanProperty(props, "jspwiki.translatorReader.camelCaseLinks", false);
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.m_longLinkPattern = compiler.compile(LONG_LINK_PATTERN);
            this.m_camelCaseLinkPattern = compiler.compile(CAMELCASE_LINK_PATTERN);
        }
        catch (MalformedPatternException mpe) {
            log.error((Object)"Error compiling regexp patterns.", (Throwable)mpe);
        }
    }

    public String renamePage(WikiContext context, String oldName, String newName, boolean changeReferrers) throws WikiException {
        newName = MarkupParser.cleanLink(newName.trim());
        Collection referrers = this.getReferrersCollection(oldName);
        log.debug((Object)("Rename request for page '" + oldName + "' to '" + newName + "'"));
        if (this.m_wikiEngine.pageExists(newName)) {
            log.debug((Object)("Rename request failed because target page '" + newName + "' exists"));
            throw new WikiException("Page exists");
        }
        this.movePageData(oldName, newName);
        this.moveAttachmentData(oldName, newName);
        this.m_wikiEngine.getReferenceManager().clearPageEntries(oldName);
        if (referrers != null) {
            this.updateReferrersOnRename(context, oldName, newName, changeReferrers, referrers);
        } else {
            WikiPage p = this.m_wikiEngine.getPage(newName);
            String pagedata = this.m_wikiEngine.getPureText(p);
            Collection refs = this.m_wikiEngine.scanWikiLinks(p, pagedata);
            this.m_wikiEngine.getReferenceManager().updateReferences(newName, refs);
        }
        return newName;
    }

    private Collection getReferrersCollection(String oldName) {
        TreeSet list = new TreeSet();
        WikiPage p = this.m_wikiEngine.getPage(oldName);
        if (p != null) {
            Collection c = this.m_wikiEngine.getReferenceManager().findReferrers(oldName);
            if (c != null) {
                list.addAll(c);
            }
            try {
                Collection attachments = this.m_wikiEngine.getAttachmentManager().listAttachments(p);
                Iterator i = attachments.iterator();
                while (i.hasNext()) {
                    Attachment att = (Attachment)i.next();
                    c = this.m_wikiEngine.getReferenceManager().findReferrers(att.getName());
                    if (c == null) continue;
                    list.addAll(c);
                }
            }
            catch (ProviderException e) {
                log.error((Object)"Cannot list attachments", (Throwable)e);
            }
        }
        return list;
    }

    private void updateReferrersOnRename(WikiContext context, String oldName, String newName, boolean changeReferrers, Collection referrers) {
        ArrayList referrersList = new ArrayList(referrers);
        Iterator referrersIterator = referrersList.iterator();
        while (referrersIterator.hasNext()) {
            String referrerName = (String)referrersIterator.next();
            this.updateReferrerOnRename(context, oldName, newName, changeReferrers, referrerName);
        }
        this.updateReferrerOnRename(context, oldName, newName, changeReferrers, newName);
        this.m_wikiEngine.getReferenceManager().clearPageEntries(oldName);
        String text = this.m_wikiEngine.getText(newName);
        Collection updatedReferrers = this.m_wikiEngine.scanWikiLinks(this.m_wikiEngine.getPage(newName), text);
        this.m_wikiEngine.getReferenceManager().updateReferences(newName, updatedReferrers);
    }

    private void updateReferrerOnRename(WikiContext context, String oldName, String newName, boolean changeReferrer, String referrerName) {
        log.debug((Object)("oldName = " + oldName));
        log.debug((Object)("newName = " + newName));
        log.debug((Object)("referrerName = " + referrerName));
        String text = this.m_wikiEngine.getPureText(referrerName, -1);
        if (changeReferrer) {
            text = this.changeReferrerText(oldName, newName, referrerName, text);
        }
        try {
            WikiContext tempCtx = new WikiContext(this.m_wikiEngine, this.m_wikiEngine.getPage(referrerName));
            if (context.getPage() != null) {
                PageLock lock = this.m_wikiEngine.getPageManager().getCurrentLock(context.getPage());
                this.m_wikiEngine.getPageManager().unlockPage(lock);
                tempCtx.getPage().setAuthor(context.getCurrentUser().getName());
                this.m_wikiEngine.saveText(tempCtx, text);
                Collection updatedReferrers = this.m_wikiEngine.scanWikiLinks(this.m_wikiEngine.getPage(referrerName), text);
                this.m_wikiEngine.getReferenceManager().updateReferences(referrerName, updatedReferrers);
            }
        }
        catch (WikiException e) {
            log.error((Object)"Unable to update referer on rename!", (Throwable)e);
        }
    }

    private String changeReferrerText(String oldName, String newName, String referrerName, String referrerText) {
        referrerText = this.replaceLongLinks(referrerText, oldName, newName);
        if (this.m_camelCaseLink) {
            referrerText = this.replaceCamelCaseLinks(referrerText, oldName, newName);
        }
        return referrerText;
    }

    private String replaceLongLinks(String text, String oldName, String replacementLink) {
        int lastMatchEnd = 0;
        PatternMatcherInput input = new PatternMatcherInput(text);
        StringBuffer ret = new StringBuffer();
        while (MATCHER.contains(input, this.m_longLinkPattern)) {
            String linkDestinationPage;
            int slash;
            MatchResult matchResult = MATCHER.getMatch();
            ret.append(input.substring(lastMatchEnd, matchResult.beginOffset(0)));
            String linkText = matchResult.group(1);
            String link = matchResult.group(2);
            String anchor = "";
            String subpage = "";
            if (link == null) {
                throw new InternalWikiException("Null link while trying to rename!  Culprit text is " + text);
            }
            int hash = link.indexOf(35);
            if (hash != -1) {
                anchor = link.substring(hash);
                link = link.substring(0, hash);
            }
            if ((slash = link.indexOf(47)) != -1) {
                subpage = link.substring(slash);
                link = link.substring(0, slash);
            }
            if ((linkDestinationPage = this.checkPluralPageName(MarkupParser.cleanLink(link))).equals(oldName)) {
                String properReplacement = linkText != null ? '[' + linkText + replacementLink + subpage + anchor + ']' : '[' + replacementLink + subpage + anchor + ']';
                ret.append(properReplacement);
            } else {
                ret.append(input.substring(matchResult.beginOffset(0), matchResult.endOffset(0)));
            }
            lastMatchEnd = matchResult.endOffset(0);
        }
        ret.append(input.substring(lastMatchEnd));
        return ret.toString();
    }

    private String replaceCamelCaseLinks(String text, String oldName, String replacementLink) {
        int lastMatchEnd = 0;
        PatternMatcherInput input = new PatternMatcherInput(text);
        StringBuffer ret = new StringBuffer();
        while (MATCHER.contains(input, this.m_camelCaseLinkPattern)) {
            MatchResult matchResult = MATCHER.getMatch();
            ret.append(input.substring(lastMatchEnd, matchResult.beginOffset(0)));
            int matchOffset = matchResult.beginOffset(0);
            int charBefore = 0;
            if (matchOffset != 0) {
                charBefore = input.charAt(matchOffset - 1);
            }
            if (charBefore != 126) {
                String page = this.checkPluralPageName(matchResult.group(0));
                if (page.equals(oldName)) {
                    ret.append(replacementLink);
                } else {
                    ret.append(input.substring(matchResult.beginOffset(0), matchResult.endOffset(0)));
                }
            } else {
                ret.append(input.substring(matchResult.beginOffset(0), matchResult.endOffset(0)));
            }
            lastMatchEnd = matchResult.endOffset(0);
        }
        ret.append(input.substring(lastMatchEnd));
        return ret.toString();
    }

    public String checkPluralPageName(String pageName) {
        if (pageName == null) {
            return null;
        }
        if (this.m_matchEnglishPlurals) {
            try {
                if (pageName.endsWith("s") && !this.m_wikiEngine.getPageManager().pageExists(pageName)) {
                    pageName = pageName.substring(0, pageName.length() - 1);
                }
            }
            catch (ProviderException e) {
                log.error((Object)"Unable to check Plural Pagename!", (Throwable)e);
            }
        }
        return pageName;
    }

    private void movePageData(String oldName, String newName) throws WikiException {
        WikiPageProvider pageProvider = this.m_wikiEngine.getPageManager().getProvider();
        try {
            pageProvider.movePage(oldName, newName);
        }
        catch (ProviderException pe) {
            log.debug((Object)"Failed in .movePageData()", (Throwable)pe);
            throw new WikiException(pe.getMessage());
        }
    }

    private void moveAttachmentData(String oldName, String newName) throws WikiException {
        WikiAttachmentProvider attachmentProvider = this.m_wikiEngine.getAttachmentManager().getCurrentProvider();
        log.debug((Object)("Trying to move all attachments from old page name " + oldName + " to new page name " + newName));
        try {
            attachmentProvider.moveAttachmentsForPage(oldName, newName);
        }
        catch (ProviderException pe) {
            log.debug((Object)"Failed in .moveAttachmentData()", (Throwable)pe);
            throw new WikiException(pe.getMessage());
        }
    }
}

