/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.event.WikiEvent;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.event.WikiEventUtils;
import com.ecyrd.jspwiki.event.WikiPageEvent;
import com.ecyrd.jspwiki.filters.BasicPageFilter;
import com.ecyrd.jspwiki.modules.InternalModule;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

public class ReferenceManager
extends BasicPageFilter
implements InternalModule,
WikiEventListener {
    private Map m_refersTo = new HashMap();
    private Map m_unmutableRefersTo;
    private Map m_referredBy = new HashMap();
    private Map m_unmutableReferredBy;
    private WikiEngine m_engine;
    private boolean m_matchEnglishPlurals = false;
    private static Logger log = Logger.getLogger((Class)ReferenceManager.class);
    private static final String SERIALIZATION_FILE = "refmgr.ser";
    private static final String SERIALIZATION_DIR = "refmgr-attr";
    private static final long serialVersionUID = 2L;

    public ReferenceManager(WikiEngine engine) {
        this.m_engine = engine;
        this.m_matchEnglishPlurals = TextUtil.getBooleanProperty(engine.getWikiProperties(), "jspwiki.translatorReader.matchEnglishPlurals", this.m_matchEnglishPlurals);
        this.m_unmutableReferredBy = Collections.unmodifiableMap(this.m_referredBy);
        this.m_unmutableRefersTo = Collections.unmodifiableMap(this.m_refersTo);
    }

    private void updatePageReferences(WikiPage page) throws ProviderException {
        String content = this.m_engine.getPageManager().getPageText(page.getName(), -1);
        TreeSet<String> res = new TreeSet<String>();
        Collection links = this.m_engine.scanWikiLinks(page, content);
        res.addAll(links);
        Collection attachments = this.m_engine.getAttachmentManager().listAttachments(page);
        Iterator atti = attachments.iterator();
        while (atti.hasNext()) {
            res.add(((Attachment)atti.next()).getName());
        }
        this.internalUpdateReferences(page.getName(), res);
    }

    public void initialize(Collection pages) throws ProviderException {
        log.debug((Object)("Initializing new ReferenceManager with " + pages.size() + " initial pages."));
        StopWatch sw = new StopWatch();
        sw.start();
        log.info((Object)"Starting cross reference scan of WikiPages");
        try {
            WikiPage page;
            long saved = this.unserializeFromDisk();
            Iterator it = pages.iterator();
            while (it.hasNext()) {
                page = (WikiPage)it.next();
                this.unserializeAttrsFromDisk(page);
            }
            it = pages.iterator();
            while (it.hasNext()) {
                page = (WikiPage)it.next();
                if (page instanceof Attachment) continue;
                if ((page = this.m_engine.getPage(page.getName())).getLastModified() == null) {
                    log.fatal((Object)"Provider returns null lastModified.  Please submit a bug report.");
                    continue;
                }
                if (page.getLastModified().getTime() <= saved) continue;
                this.updatePageReferences(page);
            }
        }
        catch (Exception e) {
            log.info((Object)("Unable to unserialize old refmgr information, rebuilding database: " + e.getMessage()));
            this.buildKeyLists(pages);
            Iterator it = pages.iterator();
            while (it.hasNext()) {
                WikiPage page = (WikiPage)it.next();
                if (page instanceof Attachment) continue;
                this.updatePageReferences(page);
                this.serializeAttrsToDisk(page);
            }
            this.serializeToDisk();
        }
        sw.stop();
        log.info((Object)("Cross reference scan done in " + sw));
        WikiEventUtils.addWikiEventListener(this.m_engine.getPageManager(), 27, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long unserializeFromDisk() throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        long saved = 0L;
        try {
            StopWatch sw = new StopWatch();
            sw.start();
            File f = new File(this.m_engine.getWorkDir(), SERIALIZATION_FILE);
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));
            long ver = in.readLong();
            if (ver != 2L) {
                throw new IOException("File format has changed; I need to recalculate references.");
            }
            saved = in.readLong();
            this.m_refersTo = (Map)in.readObject();
            this.m_referredBy = (Map)in.readObject();
            in.close();
            this.m_unmutableReferredBy = Collections.unmodifiableMap(this.m_referredBy);
            this.m_unmutableRefersTo = Collections.unmodifiableMap(this.m_refersTo);
            sw.stop();
            log.debug((Object)("Read serialized data successfully in " + sw));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
        return saved;
    }

    private synchronized void serializeToDisk() {
        ObjectOutputStream out = null;
        try {
            StopWatch sw = new StopWatch();
            sw.start();
            File f = new File(this.m_engine.getWorkDir(), SERIALIZATION_FILE);
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            out.writeLong(2L);
            out.writeLong(System.currentTimeMillis());
            out.writeObject(this.m_refersTo);
            out.writeObject(this.m_referredBy);
            out.close();
            sw.stop();
            log.debug((Object)("serialization done - took " + sw));
        }
        catch (IOException e) {
            log.error((Object)"Unable to serialize!");
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getHashFileName(String pageName) throws NoSuchAlgorithmException {
        byte[] dig;
        MessageDigest digest = MessageDigest.getInstance("MD5");
        try {
            dig = digest.digest(pageName.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalWikiException("AAAAGH!  UTF-8 is gone!  My eyes!  It burns...!");
        }
        return TextUtil.toHexString(dig) + ".cache";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized long unserializeAttrsFromDisk(WikiPage p) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        long saved = 0L;
        try {
            StopWatch sw = new StopWatch();
            sw.start();
            File f = new File(this.m_engine.getWorkDir(), SERIALIZATION_DIR);
            f = new File(f, this.getHashFileName(p.getName()));
            if (!f.exists()) {
                long l = 0L;
                return l;
            }
            log.debug((Object)("Deserializing attributes for " + p.getName()));
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));
            long ver = in.readLong();
            if (ver != 2L) {
                log.debug((Object)"File format has changed; cannot deserialize.");
                long ex = 0L;
                return ex;
            }
            saved = in.readLong();
            String name = in.readUTF();
            if (!name.equals(p.getName())) {
                log.debug((Object)("File name does not match (" + name + "), skipping..."));
                long l = 0L;
                return l;
            }
            long entries = in.readLong();
            int i = 0;
            while ((long)i < entries) {
                String key = in.readUTF();
                Object value = in.readObject();
                p.setAttribute(key, value);
                log.debug((Object)("   attr: " + key + "=" + value));
                ++i;
            }
            in.close();
            sw.stop();
            log.debug((Object)("Read serialized data for " + name + " successfully in " + sw));
            return saved;
        }
        catch (NoSuchAlgorithmException e) {
            log.fatal((Object)"No MD5!?!");
            return saved;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private synchronized void serializeAttrsToDisk(WikiPage p) {
        ObjectOutputStream out = null;
        try {
            Set entries = p.getAttributes().entrySet();
            if (entries.size() == 0) {
                return;
            }
            StopWatch sw = new StopWatch();
            sw.start();
            File f = new File(this.m_engine.getWorkDir(), SERIALIZATION_DIR);
            if (!f.exists()) {
                f.mkdirs();
            }
            f = new File(f, this.getHashFileName(p.getName()));
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            out.writeLong(2L);
            out.writeLong(System.currentTimeMillis());
            out.writeUTF(p.getName());
            out.writeLong(entries.size());
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if (!(e.getValue() instanceof Serializable)) continue;
                out.writeUTF((String)e.getKey());
                out.writeObject(e.getValue());
            }
            out.close();
            sw.stop();
            log.debug((Object)("serialization for " + p.getName() + " done - took " + sw));
        }
        catch (IOException e) {
            log.error((Object)"Unable to serialize!");
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
        catch (NoSuchAlgorithmException e) {
            log.fatal((Object)"No MD5 algorithm!?!");
        }
    }

    public void postSave(WikiContext context, String content) {
        WikiPage page = context.getPage();
        this.updateReferences(page.getName(), context.getEngine().scanWikiLinks(page, content));
        this.serializeAttrsToDisk(page);
    }

    public synchronized void pageRemoved(WikiPage page) {
        String pageName = page.getName();
        this.pageRemoved(pageName);
    }

    private void pageRemoved(String pageName) {
        Set refBy;
        Collection refTo = (Collection)this.m_refersTo.get(pageName);
        if (refTo != null) {
            Iterator it_refTo = refTo.iterator();
            while (it_refTo.hasNext()) {
                String referredPageName = (String)it_refTo.next();
                Set refBy2 = (Set)this.m_referredBy.get(referredPageName);
                if (refBy2 == null) {
                    throw new InternalWikiException("Refmgr out of sync: page " + pageName + " refers to " + referredPageName + ", which has null referrers.");
                }
                refBy2.remove(pageName);
                this.m_referredBy.remove(referredPageName);
                if (refBy2.isEmpty() && !this.m_engine.pageExists(referredPageName)) continue;
                this.m_referredBy.put(referredPageName, refBy2);
            }
            log.debug((Object)("Removing from m_refersTo HashMap key:value " + pageName + ":" + this.m_refersTo.get(pageName)));
            this.m_refersTo.remove(pageName);
        }
        if ((refBy = (Set)this.m_referredBy.get(pageName)) == null || refBy.isEmpty()) {
            this.m_referredBy.remove(pageName);
        }
        this.serializeToDisk();
        try {
            File f = new File(this.m_engine.getWorkDir(), SERIALIZATION_DIR);
            f = new File(f, this.getHashFileName(pageName));
            if (f.exists()) {
                f.delete();
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"What do you mean - no such algorithm?", (Throwable)e);
        }
    }

    public synchronized void updateReferences(String page, Collection references) {
        this.internalUpdateReferences(page, references);
        this.serializeToDisk();
    }

    private void internalUpdateReferences(String page, Collection references) {
        page = this.getFinalPageName(page);
        Collection oldRefTo = (Collection)this.m_refersTo.get(page);
        this.m_refersTo.remove(page);
        TreeSet<String> cleanedRefs = new TreeSet<String>();
        Iterator i = references.iterator();
        while (i.hasNext()) {
            String ref = (String)i.next();
            ref = this.getFinalPageName(ref);
            cleanedRefs.add(ref);
        }
        this.m_refersTo.put(page, cleanedRefs);
        if (!this.m_referredBy.containsKey(page)) {
            this.m_referredBy.put(page, new TreeSet());
        }
        this.cleanReferredBy(page, oldRefTo, cleanedRefs);
        Iterator it = cleanedRefs.iterator();
        while (it.hasNext()) {
            String referredPageName = (String)it.next();
            this.updateReferredBy(this.getFinalPageName(referredPageName), page);
        }
    }

    protected Map getRefersTo() {
        return this.m_refersTo;
    }

    protected Map getReferredBy() {
        return this.m_referredBy;
    }

    private void cleanReferredBy(String referrer, Collection oldReferred, Collection newReferred) {
        if (oldReferred == null) {
            return;
        }
        Iterator it = oldReferred.iterator();
        while (it.hasNext()) {
            String referredPage = (String)it.next();
            Set oldRefBy = (Set)this.m_referredBy.get(referredPage);
            if (oldRefBy != null) {
                oldRefBy.remove(referrer);
            }
            if (oldRefBy != null && !oldRefBy.isEmpty() || this.m_engine.pageExists(referredPage)) continue;
            this.m_referredBy.remove(referredPage);
        }
    }

    private synchronized void buildKeyLists(Collection pages) {
        this.m_refersTo.clear();
        this.m_referredBy.clear();
        if (pages == null) {
            return;
        }
        Iterator it = pages.iterator();
        try {
            while (it.hasNext()) {
                WikiPage page = (WikiPage)it.next();
                this.m_referredBy.put(page.getName(), new TreeSet());
                this.m_refersTo.put(page.getName(), null);
            }
        }
        catch (ClassCastException e) {
            log.fatal((Object)"Invalid collection entry in ReferenceManager.buildKeyLists().", (Throwable)e);
        }
    }

    private void updateReferredBy(String page, String referrer) {
        TreeSet<String> referrers;
        if (page.equals(referrer)) {
            return;
        }
        if (this.m_matchEnglishPlurals) {
            String p2;
            String string = p2 = page.endsWith("s") ? page.substring(0, page.length() - 1) : page + "s";
            if (referrer.equals(p2)) {
                return;
            }
        }
        if ((referrers = (TreeSet<String>)this.m_referredBy.get(page)) == null) {
            referrers = new TreeSet<String>();
            this.m_referredBy.put(page, referrers);
        }
        referrers.add(referrer);
    }

    public synchronized void clearPageEntries(String pagename) {
        Collection c = (Collection)this.m_refersTo.get(pagename = this.getFinalPageName(pagename));
        if (c != null) {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                Collection dref = (Collection)this.m_referredBy.get(i.next());
                dref.remove(pagename);
            }
        }
        this.m_referredBy.remove(pagename);
        this.m_refersTo.remove(pagename);
    }

    public synchronized Collection findUnreferenced() {
        ArrayList<String> unref = new ArrayList<String>();
        Set keys = this.m_referredBy.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Set refs = this.getReferenceList(this.m_referredBy, key);
            if (refs != null && !refs.isEmpty()) continue;
            unref.add(key);
        }
        return unref;
    }

    public synchronized Collection findUncreated() {
        TreeSet<String> uncreated = new TreeSet<String>();
        Collection allReferences = this.m_refersTo.values();
        Iterator it = allReferences.iterator();
        while (it.hasNext()) {
            Collection refs = (Collection)it.next();
            if (refs == null) continue;
            Iterator rit = refs.iterator();
            while (rit.hasNext()) {
                String aReference = (String)rit.next();
                if (this.m_engine.pageExists(aReference)) continue;
                uncreated.add(aReference);
            }
        }
        return uncreated;
    }

    private Set getReferenceList(Map coll, String pagename) {
        Set refs2;
        Set refs = (Set)coll.get(pagename);
        if (this.m_matchEnglishPlurals && (refs2 = pagename.endsWith("s") ? (Set)coll.get(pagename.substring(0, pagename.length() - 1)) : (Set)coll.get(pagename + "s")) != null) {
            if (refs != null) {
                refs.addAll(refs2);
            } else {
                refs = refs2;
            }
        }
        return refs;
    }

    public synchronized Collection findReferrers(String pagename) {
        Set refs = this.getReferenceList(this.m_referredBy, pagename);
        if (refs == null || refs.isEmpty()) {
            return null;
        }
        return refs;
    }

    public Set findReferredBy(String pageName) {
        return (Set)this.m_unmutableReferredBy.get(this.getFinalPageName(pageName));
    }

    public Collection findRefersTo(String pageName) {
        return (Collection)this.m_unmutableRefersTo.get(this.getFinalPageName(pageName));
    }

    public int deepHashCode() {
        boolean failed = true;
        int signature = 0;
        while (failed) {
            signature = 0;
            try {
                signature ^= ((Object)this.m_referredBy).hashCode();
                signature ^= ((Object)this.m_refersTo).hashCode();
                failed = false;
            }
            catch (ConcurrentModificationException e) {
                Thread.yield();
            }
        }
        return signature;
    }

    public Set findCreated() {
        return new HashSet(this.m_refersTo.keySet());
    }

    private String getFinalPageName(String orig) {
        try {
            String s = this.m_engine.getFinalPageName(orig);
            if (s == null) {
                s = orig;
            }
            return s;
        }
        catch (ProviderException e) {
            log.error((Object)"Error while trying to fetch a page name; trying to cope with the situation.", (Throwable)e);
            return orig;
        }
    }

    public void actionPerformed(WikiEvent event) {
        String pageName;
        if (event instanceof WikiPageEvent && event.getType() == 27 && (pageName = ((WikiPageEvent)event).getPageName()) != null) {
            this.pageRemoved(pageName);
        }
    }
}

