/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.NoSuchVariableException;
import com.ecyrd.jspwiki.StringTransmutator;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.VariableManager;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.attachment.AttachmentManager;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.acl.Acl;
import com.ecyrd.jspwiki.parser.Heading;
import com.ecyrd.jspwiki.parser.HeadingListener;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.PluginManager;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class TranslatorReader
extends Reader {
    public static final int READ = 0;
    public static final int EDIT = 1;
    private static final int EMPTY = 2;
    private static final int LOCAL = 3;
    private static final int LOCALREF = 4;
    private static final int IMAGE = 5;
    private static final int EXTERNAL = 6;
    private static final int INTERWIKI = 7;
    private static final int IMAGELINK = 8;
    private static final int IMAGEWIKILINK = 9;
    public static final int ATTACHMENT = 10;
    private static final String PUNCTUATION_CHARS_ALLOWED = "._";
    private static final int PUSHBACK_BUFFER_SIZE = 10240;
    private PushbackReader m_in;
    private StringReader m_data = new StringReader("");
    private static Logger log = Logger.getLogger((Class)TranslatorReader.class);
    private boolean m_isbold = false;
    private boolean m_isitalic = false;
    private boolean m_isTypedText = false;
    private boolean m_istable = false;
    private boolean m_isPre = false;
    private boolean m_isEscaping = false;
    private boolean m_isdefinition = false;
    private Stack m_styleStack = new Stack();
    private int m_genlistlevel = 0;
    private StringBuffer m_genlistBulletBuffer = new StringBuffer();
    private boolean m_allowPHPWikiStyleLists = true;
    private boolean m_isOpenParagraph = false;
    private String m_closeTag = null;
    private WikiEngine m_engine;
    private WikiContext m_context;
    private ArrayList m_localLinkMutatorChain = new ArrayList();
    private ArrayList m_externalLinkMutatorChain = new ArrayList();
    private ArrayList m_attachmentLinkMutatorChain = new ArrayList();
    private ArrayList m_headingListenerChain = new ArrayList();
    private ArrayList m_inlineImagePatterns;
    private PatternMatcher m_inlineMatcher = new Perl5Matcher();
    private ArrayList m_linkMutators = new ArrayList();
    public static final String PROP_INLINEIMAGEPTRN = "jspwiki.translatorReader.inlinePattern";
    public static final String PROP_CAMELCASELINKS = "jspwiki.translatorReader.camelCaseLinks";
    public static final String PROP_PLAINURIS = "jspwiki.translatorReader.plainUris";
    public static final String PROP_USEOUTLINKIMAGE = "jspwiki.translatorReader.useOutlinkImage";
    public static final String PROP_ALLOWHTML = "jspwiki.translatorReader.allowHTML";
    public static final String PROP_USERELNOFOLLOW = "jspwiki.translatorReader.useRelNofollow";
    public static final String PROP_RUNPLUGINS = "jspwiki.translatorReader.runPlugins";
    private boolean m_camelCaseLinks = false;
    private boolean m_plainUris = false;
    private boolean m_useOutlinkImage = true;
    private boolean m_allowHTML = false;
    private boolean m_enablePlugins = true;
    private boolean m_useRelNofollow = false;
    private boolean m_inlineImages = true;
    private PatternMatcher m_matcher = new Perl5Matcher();
    private PatternCompiler m_compiler = new Perl5Compiler();
    private Pattern m_camelCasePtrn;
    private TextRenderer m_renderer;
    public static final String DEFAULT_INLINEPATTERN = "*.png";
    private static final String WORD_SEPARATORS = ",.|;+=&()";
    protected static final int BOLD = 0;
    protected static final int ITALIC = 1;
    protected static final int TYPED = 2;
    static final String[] c_externalLinks = new String[]{"http:", "ftp:", "https:", "mailto:", "news:", "file:", "rtsp:", "mms:", "ldap:", "gopher:", "nntp:", "telnet:", "wais:", "prospero:", "z39.50s", "z39.50r", "vemmi:", "imap:", "nfs:", "acap:", "tip:", "pop:", "dav:", "opaquelocktoken:", "sip:", "sips:", "tel:", "fax:", "modem:", "soap.beep:", "soap.beeps", "xmlrpc.beep", "xmlrpc.beeps", "urn:", "go:", "h323:", "ipp:", "tftp:", "mupdate:", "pres:", "im:", "mtqp", "smb:"};
    private boolean m_parseAccessRules = true;

    public TranslatorReader(WikiContext context, Reader in) {
        this.initialize(context, in, new HTMLRenderer());
    }

    public TranslatorReader(WikiContext context, Reader in, TextRenderer renderer) {
        this.initialize(context, in, renderer);
    }

    public Reader setInputReader(Reader in) {
        PushbackReader old = this.m_in;
        if (in != null) {
            this.m_in = new PushbackReader(new BufferedReader(in), 10240);
        }
        return old;
    }

    private void initialize(WikiContext context, Reader in, TextRenderer renderer) {
        GlobCompiler compiler = new GlobCompiler();
        ArrayList<Pattern> compiledpatterns = new ArrayList<Pattern>();
        this.m_engine = context.getEngine();
        this.m_context = context;
        this.m_renderer = renderer;
        this.setInputReader(in);
        Collection ptrns = TranslatorReader.getImagePatterns(this.m_engine);
        Iterator i = ptrns.iterator();
        while (i.hasNext()) {
            try {
                compiledpatterns.add(compiler.compile((String)i.next()));
            }
            catch (MalformedPatternException e) {
                log.error((Object)"Malformed pattern in properties: ", (Throwable)e);
            }
        }
        this.m_inlineImagePatterns = compiledpatterns;
        try {
            this.m_camelCasePtrn = this.m_compiler.compile("^([[:^alnum:]]*)([[:upper:]]+[[:lower:]]+[[:upper:]]+[[:alnum:]]*)[[:^alnum:]]*$");
        }
        catch (MalformedPatternException e) {
            log.fatal((Object)"Internal error: Someone put in a faulty pattern.", (Throwable)e);
            throw new InternalWikiException("Faulty camelcasepattern in TranslatorReader");
        }
        Properties props = this.m_engine.getWikiProperties();
        String cclinks = (String)this.m_context.getPage().getAttribute(PROP_CAMELCASELINKS);
        this.m_camelCaseLinks = cclinks != null ? TextUtil.isPositive(cclinks) : TextUtil.getBooleanProperty(props, PROP_CAMELCASELINKS, this.m_camelCaseLinks);
        this.m_plainUris = TextUtil.getBooleanProperty(props, PROP_PLAINURIS, this.m_plainUris);
        this.m_useOutlinkImage = TextUtil.getBooleanProperty(props, PROP_USEOUTLINKIMAGE, this.m_useOutlinkImage);
        this.m_allowHTML = TextUtil.getBooleanProperty(props, PROP_ALLOWHTML, this.m_allowHTML);
        this.m_useRelNofollow = TextUtil.getBooleanProperty(props, PROP_USERELNOFOLLOW, this.m_useRelNofollow);
        String runplugins = this.m_engine.getVariable(this.m_context, PROP_RUNPLUGINS);
        if (runplugins != null) {
            this.enablePlugins(TextUtil.isPositive(runplugins));
        }
        if (this.m_engine.getUserManager().getUserDatabase() == null || this.m_engine.getAuthorizationManager() == null) {
            this.disableAccessRules();
        }
        this.m_context.getPage().setHasMetadata();
    }

    protected void setRenderer(TextRenderer renderer) {
        this.m_renderer = renderer;
    }

    public void addLinkTransmutator(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_linkMutators.add(mutator);
        }
    }

    public void addLocalLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_localLinkMutatorChain.add(mutator);
        }
    }

    public void addExternalLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_externalLinkMutatorChain.add(mutator);
        }
    }

    public void addAttachmentLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_attachmentLinkMutatorChain.add(mutator);
        }
    }

    public void addHeadingListener(HeadingListener listener) {
        if (listener != null) {
            this.m_headingListenerChain.add(listener);
        }
    }

    public void disableAccessRules() {
        this.m_parseAccessRules = false;
    }

    public void enablePlugins(boolean toggle) {
        this.m_enablePlugins = toggle;
    }

    public void enableImageInlining(boolean toggle) {
        this.m_inlineImages = toggle;
    }

    protected static Collection getImagePatterns(WikiEngine engine) {
        Properties props = engine.getWikiProperties();
        ArrayList<String> ptrnlist = new ArrayList<String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(PROP_INLINEIMAGEPTRN)) continue;
            String ptrn = props.getProperty(name);
            ptrnlist.add(ptrn);
        }
        if (ptrnlist.size() == 0) {
            ptrnlist.add(DEFAULT_INLINEPATTERN);
        }
        return ptrnlist;
    }

    private String linkExists(String page) {
        try {
            if (page == null || page.length() == 0) {
                return null;
            }
            return this.m_engine.getFinalPageName(page);
        }
        catch (ProviderException e) {
            log.warn((Object)"TranslatorReader got a faulty page name!", (Throwable)e);
            return page;
        }
    }

    private String callMutatorChain(Collection list, String text) {
        if (list == null || list.size() == 0) {
            return text;
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            StringTransmutator m = (StringTransmutator)i.next();
            text = m.mutate(this.m_context, text);
        }
        return text;
    }

    private void callHeadingListenerChain(Heading param) {
        ArrayList list = this.m_headingListenerChain;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            HeadingListener h = (HeadingListener)i.next();
            h.headingAdded(this.m_context, param);
        }
    }

    public String makeLink(int type, String link, String text) {
        if (text == null) {
            text = link;
        }
        text = this.callMutatorChain(this.m_linkMutators, text);
        return this.m_renderer.makeLink(type, link, text);
    }

    private String makeLink(int type, String link, String text, String sectref) {
        if (text == null) {
            text = link;
        }
        text = this.callMutatorChain(this.m_linkMutators, text);
        return this.m_renderer.makeLink(type, link, text, sectref);
    }

    public static String cleanLink(String link) {
        StringBuffer clean = new StringBuffer();
        if (link == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(link, " -");
        while (st.hasMoreTokens()) {
            StringBuffer component = new StringBuffer(st.nextToken());
            component.setCharAt(0, Character.toUpperCase(component.charAt(0)));
            clean.append(component.toString());
        }
        for (int i = 0; i < clean.length(); ++i) {
            char ch = clean.charAt(i);
            if (Character.isLetterOrDigit(ch) || PUNCTUATION_CHARS_ALLOWED.indexOf(ch) != -1) continue;
            clean.deleteCharAt(i);
            --i;
        }
        return clean.toString();
    }

    private boolean isExternalLink(String link) {
        for (int i = 0; i < c_externalLinks.length; ++i) {
            if (!link.startsWith(c_externalLinks[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isAccessRule(String link) {
        return link.startsWith("{ALLOW") || link.startsWith("{DENY");
    }

    private boolean isImageLink(String link) {
        if (this.m_inlineImages) {
            Iterator i = this.m_inlineImagePatterns.iterator();
            while (i.hasNext()) {
                if (!this.m_inlineMatcher.matches(link, (Pattern)i.next())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMetadata(String link) {
        return link.startsWith("{SET");
    }

    private boolean isNumber(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() > 1 && s.charAt(0) == '-') {
            s = s.substring(1);
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String checkForCamelCaseLink(String word) {
        PatternMatcherInput input = new PatternMatcherInput(word);
        if (this.m_matcher.contains(input, this.m_camelCasePtrn)) {
            MatchResult res = this.m_matcher.getMatch();
            String link = res.group(2);
            if (res.group(1) != null && (res.group(1).endsWith("~") || res.group(1).indexOf(91) != -1)) {
                return null;
            }
            return link;
        }
        return null;
    }

    private String makeCamelCaseLink(String wikiname) {
        this.callMutatorChain(this.m_localLinkMutatorChain, wikiname);
        String matchedLink = this.linkExists(wikiname);
        String link = matchedLink != null ? this.makeLink(0, matchedLink, wikiname) : this.makeLink(1, wikiname, wikiname);
        return link;
    }

    private String makeDirectURILink(String url) {
        String last = "";
        if (url.endsWith(",") || url.endsWith(".")) {
            last = url.substring(url.length() - 1);
            url = url.substring(0, url.length() - 1);
        }
        this.callMutatorChain(this.m_externalLinkMutatorChain, url);
        String result = this.isImageLink(url) ? this.handleImageLink(url, url, false) : this.makeLink(6, url, url) + this.m_renderer.outlinkImage();
        result = result + last;
        return result;
    }

    private String handleImageLink(String reallink, String link, boolean hasLinkText) {
        String possiblePage = TranslatorReader.cleanLink(link);
        String res = "";
        if (this.isExternalLink(link) && hasLinkText) {
            res = this.makeLink(8, reallink, link);
        } else if (this.linkExists(possiblePage) != null && hasLinkText) {
            this.callMutatorChain(this.m_localLinkMutatorChain, possiblePage);
            res = this.makeLink(9, reallink, link);
        } else {
            res = this.makeLink(5, reallink, link);
        }
        return res;
    }

    private String handleAccessRule(String ruleLine) {
        if (!this.m_parseAccessRules) {
            return "";
        }
        WikiPage page = this.m_context.getPage();
        if (ruleLine.startsWith("{")) {
            ruleLine = ruleLine.substring(1);
        }
        if (ruleLine.endsWith("}")) {
            ruleLine = ruleLine.substring(0, ruleLine.length() - 1);
        }
        log.debug((Object)("page=" + page.getName() + ", ACL = " + ruleLine));
        try {
            Acl acl = this.m_engine.getAclManager().parseAcl(page, ruleLine);
            page.setAcl(acl);
            log.debug((Object)((Object)acl).toString());
        }
        catch (WikiSecurityException wse) {
            return this.m_renderer.makeError(wse.getMessage());
        }
        return "";
    }

    private String handleMetadata(String link) {
        try {
            String args = link.substring(link.indexOf(32), link.length() - 1);
            String name = args.substring(0, args.indexOf(61));
            String val = args.substring(args.indexOf(61) + 1, args.length());
            name = name.trim();
            val = val.trim();
            if (val.startsWith("'")) {
                val = val.substring(1);
            }
            if (val.endsWith("'")) {
                val = val.substring(0, val.length() - 1);
            }
            if (name.length() > 0 && val.length() > 0) {
                val = this.m_engine.getVariableManager().expandVariables(this.m_context, val);
                this.m_context.getPage().setAttribute(name, val);
            }
        }
        catch (Exception e) {
            ResourceBundle rb = this.m_context.getBundle("CoreResources");
            Object[] args = new Object[]{link};
            this.m_renderer.makeError(MessageFormat.format(rb.getString("markupparser.error.invalidset"), args));
        }
        return "";
    }

    private String handleHyperlinks(String link) {
        String reallink;
        StringBuffer sb = new StringBuffer();
        if (TranslatorReader.isAccessRule(link)) {
            return this.handleAccessRule(link);
        }
        if (TranslatorReader.isMetadata(link)) {
            return this.handleMetadata(link);
        }
        if (PluginManager.isPluginLink(link)) {
            String included = "";
            try {
                if (this.m_enablePlugins) {
                    included = this.m_engine.getPluginManager().execute(this.m_context, link);
                }
            }
            catch (PluginException e) {
                log.info((Object)"Failed to insert plugin", (Throwable)e);
                log.info((Object)"Root cause:", e.getRootThrowable());
                ResourceBundle rb = this.m_context.getBundle("com.ecyrd.jspwiki.plugin.PluginResources");
                Object[] args = new Object[]{e.getMessage()};
                included = this.m_renderer.makeError(MessageFormat.format(rb.getString("plugin.error.insertionfailed"), args));
            }
            sb.append(included);
            return sb.toString();
        }
        int cutpoint = (link = TextUtil.replaceEntities(link)).indexOf(124);
        if (cutpoint != -1) {
            reallink = link.substring(cutpoint + 1).trim();
            link = link.substring(0, cutpoint);
        } else {
            reallink = link.trim();
        }
        int interwikipoint = -1;
        if (VariableManager.isVariableLink(link)) {
            String value;
            try {
                value = this.m_engine.getVariableManager().parseAndGetValue(this.m_context, link);
            }
            catch (NoSuchVariableException e) {
                value = this.m_renderer.makeError(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                value = this.m_renderer.makeError(e.getMessage());
            }
            sb.append(value);
        } else if (this.isExternalLink(reallink)) {
            this.callMutatorChain(this.m_externalLinkMutatorChain, reallink);
            if (this.isImageLink(reallink)) {
                sb.append(this.handleImageLink(reallink, link, cutpoint != -1));
            } else {
                sb.append(this.makeLink(6, reallink, link));
                sb.append(this.m_renderer.outlinkImage());
            }
        } else {
            interwikipoint = reallink.indexOf(":");
            if (interwikipoint != -1) {
                String extWiki = reallink.substring(0, interwikipoint);
                String wikiPage = reallink.substring(interwikipoint + 1);
                String urlReference = this.m_engine.getInterWikiURL(extWiki);
                if (urlReference != null) {
                    urlReference = TextUtil.replaceString(urlReference, "%s", wikiPage);
                    this.callMutatorChain(this.m_externalLinkMutatorChain, urlReference);
                    sb.append(this.makeLink(7, urlReference, link));
                    if (this.isExternalLink(urlReference)) {
                        sb.append(this.m_renderer.outlinkImage());
                    }
                } else {
                    ResourceBundle rb = this.m_context.getBundle("com.ecyrd.jspwiki.plugin.PluginResources");
                    Object[] args = new Object[]{extWiki};
                    sb.append(link + " " + this.m_renderer.makeError(MessageFormat.format(rb.getString("plugin.error.nointerwikiref"), args)));
                }
            } else if (reallink.startsWith("#")) {
                sb.append(this.makeLink(3, reallink, link));
            } else if (this.isNumber(reallink)) {
                sb.append(this.makeLink(4, reallink, link));
            } else {
                int hashMark = -1;
                String attachment = this.findAttachment(reallink);
                if (attachment != null) {
                    this.callMutatorChain(this.m_attachmentLinkMutatorChain, attachment);
                    if (this.isImageLink(reallink)) {
                        attachment = this.m_context.getURL(WikiContext.ATTACH, attachment);
                        sb.append(this.handleImageLink(attachment, link, cutpoint != -1));
                    } else {
                        sb.append(this.makeLink(10, attachment, link));
                    }
                } else {
                    hashMark = reallink.indexOf(35);
                    if (hashMark != -1) {
                        String namedSection = reallink.substring(hashMark + 1);
                        reallink = reallink.substring(0, hashMark);
                        reallink = TranslatorReader.cleanLink(reallink);
                        this.callMutatorChain(this.m_localLinkMutatorChain, reallink);
                        String matchedLink = this.linkExists(reallink);
                        if (matchedLink != null) {
                            String sectref = "section-" + this.m_engine.encodeName(matchedLink) + "-" + namedSection;
                            sectref = sectref.replace('%', '_');
                            sb.append(this.makeLink(0, matchedLink, link, sectref));
                        } else {
                            sb.append(this.makeLink(1, reallink, link));
                        }
                    } else {
                        reallink = TranslatorReader.cleanLink(reallink);
                        this.callMutatorChain(this.m_localLinkMutatorChain, reallink);
                        String matchedLink = this.linkExists(reallink);
                        if (matchedLink != null) {
                            sb.append(this.makeLink(0, matchedLink, link));
                        } else {
                            sb.append(this.makeLink(1, reallink, link));
                        }
                    }
                }
            }
        }
        return sb.toString();
    }

    private String findAttachment(String link) {
        AttachmentManager mgr = this.m_engine.getAttachmentManager();
        Attachment att = null;
        try {
            att = mgr.getAttachmentInfo(this.m_context, link);
        }
        catch (ProviderException e) {
            log.warn((Object)"Finding attachments failed: ", (Throwable)e);
            return null;
        }
        if (att != null) {
            return att.getName();
        }
        if (link.indexOf(47) != -1) {
            return link;
        }
        return null;
    }

    private String closeAll() {
        StringBuffer buf = new StringBuffer();
        if (this.m_isbold) {
            buf.append(this.m_renderer.closeTextEffect(0));
            this.m_isbold = false;
        }
        if (this.m_isitalic) {
            buf.append(this.m_renderer.closeTextEffect(1));
            this.m_isitalic = false;
        }
        if (this.m_isTypedText) {
            buf.append(this.m_renderer.closeTextEffect(2));
            this.m_isTypedText = false;
        }
        buf.append(this.unwindGeneralList());
        if (this.m_isPre) {
            buf.append(this.m_renderer.closePreformatted());
            this.m_isEscaping = false;
            this.m_isPre = false;
        }
        if (this.m_istable) {
            buf.append(this.m_renderer.closeTable());
            this.m_istable = false;
        }
        if (this.m_isOpenParagraph) {
            buf.append(this.m_renderer.closeParagraph());
            this.m_isOpenParagraph = false;
        }
        return buf.toString();
    }

    private int nextToken() throws IOException {
        if (this.m_in == null) {
            return -1;
        }
        return this.m_in.read();
    }

    private void pushBack(int c) throws IOException {
        if (c != -1 && this.m_in != null) {
            this.m_in.unread(c);
        }
    }

    private void pushBack(String s) throws IOException {
        for (int i = s.length() - 1; i >= 0; --i) {
            this.pushBack(s.charAt(i));
        }
    }

    private String handleBackslash() throws IOException {
        int ch = this.nextToken();
        if (ch == 92) {
            int ch2 = this.nextToken();
            if (ch2 == 92) {
                return this.m_renderer.lineBreak(true);
            }
            this.pushBack(ch2);
            return this.m_renderer.lineBreak(false);
        }
        this.pushBack(ch);
        return "\\";
    }

    private String handleUnderscore() throws IOException {
        int ch = this.nextToken();
        String res = "_";
        if (ch == 95) {
            res = this.m_isbold ? this.m_renderer.closeTextEffect(0) : this.m_renderer.openTextEffect(0);
            this.m_isbold = !this.m_isbold;
        } else {
            this.pushBack(ch);
        }
        return res;
    }

    private String handleApostrophe() throws IOException {
        int ch = this.nextToken();
        String res = "'";
        if (ch == 39) {
            res = this.m_isitalic ? this.m_renderer.closeTextEffect(1) : this.m_renderer.openTextEffect(1);
            this.m_isitalic = !this.m_isitalic;
        } else {
            this.pushBack(ch);
        }
        return res;
    }

    private String handleOpenbrace(boolean isBlock) throws IOException {
        int ch = this.nextToken();
        String res = "{";
        if (ch == 123) {
            int ch2 = this.nextToken();
            if (ch2 == 123) {
                res = this.startBlockLevel() + this.m_renderer.openPreformatted(isBlock);
                this.m_isPre = true;
                this.m_isEscaping = true;
            } else {
                this.pushBack(ch2);
                res = this.m_renderer.openTextEffect(2);
                this.m_isTypedText = true;
            }
        } else {
            this.pushBack(ch);
        }
        return res;
    }

    private String handleClosebrace() throws IOException {
        String res = "}";
        int ch2 = this.nextToken();
        if (ch2 == 125) {
            int ch3 = this.nextToken();
            if (ch3 == 125) {
                if (this.m_isPre) {
                    this.m_isPre = false;
                    this.m_isEscaping = false;
                    res = this.m_renderer.closePreformatted();
                } else {
                    res = "}}}";
                }
            } else {
                this.pushBack(ch3);
                if (!this.m_isEscaping) {
                    res = this.m_renderer.closeTextEffect(2);
                    this.m_isTypedText = false;
                } else {
                    this.pushBack(ch2);
                }
            }
        } else {
            this.pushBack(ch2);
        }
        return res;
    }

    private String handleDash() throws IOException {
        int ch = this.nextToken();
        if (ch == 45) {
            int ch2 = this.nextToken();
            if (ch2 == 45) {
                int ch3 = this.nextToken();
                if (ch3 == 45) {
                    while ((ch = this.nextToken()) == 45) {
                    }
                    this.pushBack(ch);
                    return this.startBlockLevel() + this.m_renderer.makeRuler();
                }
                this.pushBack(ch3);
            }
            this.pushBack(ch2);
        }
        this.pushBack(ch);
        return "-";
    }

    private String peekAheadLine() throws IOException {
        String s = this.readUntilEOL().toString();
        this.pushBack(s);
        return s;
    }

    private String handleHeading() throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = this.nextToken();
        Heading hd = new Heading();
        if (ch == 33) {
            int ch2 = this.nextToken();
            if (ch2 == 33) {
                String title = this.peekAheadLine();
                buf.append(this.m_renderer.makeHeading(3, title, hd));
            } else {
                this.pushBack(ch2);
                String title = this.peekAheadLine();
                buf.append(this.m_renderer.makeHeading(2, title, hd));
            }
        } else {
            this.pushBack(ch);
            String title = this.peekAheadLine();
            buf.append(this.m_renderer.makeHeading(1, title, hd));
        }
        this.callHeadingListenerChain(hd);
        return buf.toString();
    }

    private StringBuffer readUntilEOL() throws IOException {
        int ch;
        StringBuffer buf = new StringBuffer();
        while ((ch = this.nextToken()) != -1) {
            buf.append((char)ch);
            if (ch != 10) continue;
            break;
        }
        return buf;
    }

    private String startBlockLevel() {
        if (this.m_isOpenParagraph) {
            this.m_isOpenParagraph = false;
            return this.m_renderer.closeParagraph();
        }
        return "";
    }

    private String handleGeneralList() throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.startBlockLevel());
        String strBullets = this.readWhile("*#");
        int numBullets = strBullets.length();
        if (this.m_allowPHPWikiStyleLists && !strBullets.substring(0, Math.min(numBullets, this.m_genlistlevel)).equals(this.m_genlistBulletBuffer.substring(0, Math.min(numBullets, this.m_genlistlevel)))) {
            strBullets = numBullets <= this.m_genlistlevel ? (numBullets > 1 ? this.m_genlistBulletBuffer.substring(0, numBullets - 1) : "") + strBullets.substring(numBullets - 1, numBullets) : this.m_genlistBulletBuffer + strBullets.substring(this.m_genlistlevel, numBullets);
        }
        if (strBullets.substring(0, Math.min(numBullets, this.m_genlistlevel)).equals(this.m_genlistBulletBuffer.substring(0, Math.min(numBullets, this.m_genlistlevel)))) {
            if (numBullets > this.m_genlistlevel) {
                buf.append(this.m_renderer.openList(strBullets.charAt(this.m_genlistlevel++)));
                while (this.m_genlistlevel < numBullets) {
                    buf.append(this.m_renderer.openListItem());
                    buf.append(this.m_renderer.openList(strBullets.charAt(this.m_genlistlevel)));
                    ++this.m_genlistlevel;
                }
            } else if (numBullets < this.m_genlistlevel) {
                buf.append(this.m_renderer.closeListItem());
                while (this.m_genlistlevel > numBullets) {
                    buf.append(this.m_renderer.closeList(this.m_genlistBulletBuffer.charAt(this.m_genlistlevel - 1)));
                    if (this.m_genlistlevel > 0) {
                        buf.append(this.m_renderer.closeListItem());
                    }
                    --this.m_genlistlevel;
                }
            } else if (this.m_genlistlevel > 0) {
                buf.append(this.m_renderer.closeListItem());
            }
        } else {
            int numEqualBullets;
            int numCheckBullets = Math.min(numBullets, this.m_genlistlevel);
            for (numEqualBullets = 0; numEqualBullets < numCheckBullets && strBullets.charAt(numEqualBullets) == this.m_genlistBulletBuffer.charAt(numEqualBullets); ++numEqualBullets) {
            }
            while (this.m_genlistlevel > numEqualBullets) {
                buf.append(this.m_renderer.closeList(this.m_genlistBulletBuffer.charAt(this.m_genlistlevel - 1)));
                if (this.m_genlistlevel > 0) {
                    buf.append(this.m_renderer.closeListItem());
                }
                --this.m_genlistlevel;
            }
            buf.append(this.m_renderer.openList(strBullets.charAt(numEqualBullets++)));
            for (int i = numEqualBullets; i < numBullets; ++i) {
                buf.append(this.m_renderer.openListItem());
                buf.append(this.m_renderer.openList(strBullets.charAt(i)));
            }
            this.m_genlistlevel = numBullets;
        }
        buf.append(this.m_renderer.openListItem());
        this.m_genlistBulletBuffer.setLength(0);
        this.m_genlistBulletBuffer.append(strBullets);
        return buf.toString();
    }

    private String unwindGeneralList() {
        StringBuffer buf = new StringBuffer();
        while (this.m_genlistlevel > 0) {
            buf.append(this.m_renderer.closeListItem());
            buf.append(this.m_renderer.closeList(this.m_genlistBulletBuffer.charAt(this.m_genlistlevel - 1)));
            --this.m_genlistlevel;
        }
        this.m_genlistBulletBuffer.setLength(0);
        return buf.toString();
    }

    private String handleDefinitionList() throws IOException {
        if (!this.m_isdefinition) {
            this.m_isdefinition = true;
            this.m_closeTag = this.m_renderer.closeDefinitionItem() + this.m_renderer.closeDefinitionList();
            return this.startBlockLevel() + this.m_renderer.openDefinitionList() + this.m_renderer.openDefinitionTitle();
        }
        return ";";
    }

    private String handleOpenbracket() throws IOException {
        int ch;
        StringBuffer sb = new StringBuffer();
        boolean isPlugin = false;
        while ((ch = this.nextToken()) == 91) {
            sb.append((char)ch);
        }
        if (ch == 123) {
            isPlugin = true;
        }
        this.pushBack(ch);
        if (sb.length() > 0) {
            return sb.toString();
        }
        ch = this.nextToken();
        while (ch != -1 && (ch != 93 || isPlugin && sb.charAt(sb.length() - 1) != '}')) {
            sb.append((char)ch);
            ch = this.nextToken();
        }
        if (ch == -1) {
            log.debug((Object)"Warning: unterminated link detected!");
            return sb.toString();
        }
        return this.handleHyperlinks(sb.toString());
    }

    private String readBraceContent(char opening, char closing) throws IOException {
        int ch;
        StringBuffer sb = new StringBuffer();
        int braceLevel = 1;
        while ((ch = this.nextToken()) != -1) {
            if (ch == 92) continue;
            if (ch == opening) {
                ++braceLevel;
            } else if (ch == closing && --braceLevel == 0) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private String readUntil(String endChars) throws IOException {
        StringBuffer sb = new StringBuffer();
        int ch = this.nextToken();
        while (ch != -1) {
            if (ch == 92) {
                ch = this.nextToken();
                if (ch == -1) {
                    break;
                }
            } else if (endChars.indexOf((char)ch) != -1) {
                this.pushBack(ch);
                break;
            }
            sb.append((char)ch);
            ch = this.nextToken();
        }
        return sb.toString();
    }

    private String readWhile(String endChars) throws IOException {
        StringBuffer sb = new StringBuffer();
        int ch = this.nextToken();
        while (ch != -1) {
            if (endChars.indexOf((char)ch) == -1) {
                this.pushBack(ch);
                break;
            }
            sb.append((char)ch);
            ch = this.nextToken();
        }
        return sb.toString();
    }

    private String handleDiv(boolean newLine) throws IOException {
        int ch = this.nextToken();
        if (ch == 37) {
            StringBuffer sb = new StringBuffer();
            String style = null;
            String clazz = null;
            ch = this.nextToken();
            if (ch == 40) {
                style = this.readBraceContent('(', ')');
            } else if (Character.isLetter((char)ch)) {
                this.pushBack(ch);
                clazz = this.readUntil(" \t\n\r");
                ch = this.nextToken();
                if (ch == 10 || ch == 13) {
                    this.pushBack(ch);
                }
            } else {
                this.pushBack(ch);
                try {
                    Boolean isSpan = (Boolean)this.m_styleStack.pop();
                    if (isSpan != null) {
                        if (isSpan.booleanValue()) {
                            sb.append(this.m_renderer.closeSpan());
                        } else {
                            sb.append(this.m_renderer.closeDiv());
                        }
                    }
                }
                catch (EmptyStackException e) {
                    log.debug((Object)("Page '" + this.m_context.getPage().getName() + "' closes a %%-block that has not been opened."));
                }
                return sb.toString();
            }
            String eol = this.peekAheadLine();
            if (eol.trim().length() > 0) {
                sb.append(this.m_renderer.openSpan(style, clazz));
                this.m_styleStack.push(Boolean.TRUE);
            } else {
                sb.append(this.startBlockLevel());
                sb.append(this.m_renderer.openDiv(style, clazz));
                this.m_styleStack.push(Boolean.FALSE);
            }
            return sb.toString();
        }
        this.pushBack(ch);
        return "%";
    }

    private String handleBar(boolean newLine) throws IOException {
        int ch;
        StringBuffer sb = new StringBuffer();
        if (!this.m_istable && !newLine) {
            return "|";
        }
        if (newLine) {
            if (!this.m_istable) {
                sb.append(this.startBlockLevel());
                sb.append(this.m_renderer.openTable());
                this.m_istable = true;
            }
            sb.append(this.m_renderer.openTableRow());
            this.m_closeTag = this.m_renderer.closeTableItem() + this.m_renderer.closeTableRow();
        }
        if ((ch = this.nextToken()) == 124) {
            if (!newLine) {
                sb.append(this.m_renderer.closeTableHeading());
            }
            sb.append(this.m_renderer.openTableHeading());
            this.m_closeTag = this.m_renderer.closeTableHeading() + this.m_renderer.closeTableRow();
        } else {
            if (!newLine) {
                sb.append(this.m_renderer.closeTableItem());
            }
            sb.append(this.m_renderer.openTableItem());
            this.pushBack(ch);
        }
        return sb.toString();
    }

    private String handleTilde() throws IOException {
        int ch = this.nextToken();
        if (ch == 124 || ch == 126 || ch == 92 || ch == 42 || ch == 35 || ch == 45 || ch == 33 || ch == 39 || ch == 95 || ch == 91 || ch == 123 || ch == 93 || ch == 125) {
            StringBuffer sb = new StringBuffer();
            sb.append((char)ch);
            sb.append(this.readWhile("" + (char)ch));
            return sb.toString();
        }
        if (Character.isUpperCase((char)ch)) {
            this.pushBack(ch);
            return "";
        }
        this.pushBack(ch);
        return "~";
    }

    private void fillBuffer() throws IOException {
        StringBuffer buf = new StringBuffer();
        StringBuffer word = null;
        int previousCh = -2;
        int start = 0;
        boolean quitReading = false;
        boolean newLine = true;
        while (!quitReading) {
            int ch = this.nextToken();
            String s = null;
            if (this.m_isEscaping) {
                if (ch == 125) {
                    buf.append(this.handleClosebrace());
                    continue;
                }
                if (ch == -1) {
                    quitReading = true;
                    continue;
                }
                this.m_renderer.doChar(buf, (char)ch);
                continue;
            }
            if (this.m_camelCaseLinks) {
                if (word == null && (Character.isWhitespace((char)previousCh) || WORD_SEPARATORS.indexOf((char)previousCh) != -1 || newLine) && !Character.isWhitespace((char)ch)) {
                    word = new StringBuffer();
                }
                if (word != null) {
                    if (Character.isWhitespace((char)ch) || ch == -1 || WORD_SEPARATORS.indexOf((char)ch) != -1) {
                        String potentialLink = word.toString();
                        String camelCase = this.checkForCamelCaseLink(potentialLink);
                        if (camelCase != null) {
                            start = buf.toString().lastIndexOf(camelCase);
                            buf.replace(start, start + camelCase.length(), this.makeCamelCaseLink(camelCase));
                        } else if (this.isExternalLink(potentialLink) && (start = buf.toString().lastIndexOf(potentialLink)) >= 0) {
                            String link = this.readUntil(" \t()[]{}!\"'\n|");
                            link = potentialLink + (char)ch + link;
                            buf.replace(start, start + potentialLink.length(), this.makeDirectURILink(link));
                            ch = this.nextToken();
                        }
                        word = null;
                    } else {
                        word.append((char)ch);
                    }
                }
                previousCh = ch;
            }
            if (newLine && ch != 42 && ch != 35 && ch != 32 && this.m_genlistlevel > 0) {
                buf.append(this.unwindGeneralList());
            }
            if (newLine && ch != 124 && this.m_istable) {
                buf.append(this.m_renderer.closeTable());
                this.m_istable = false;
                this.m_closeTag = null;
            }
            switch (ch) {
                case 13: {
                    s = null;
                    break;
                }
                case 10: {
                    if (this.m_closeTag != null) {
                        buf.append(this.m_closeTag);
                        this.m_closeTag = null;
                    }
                    this.m_isdefinition = false;
                    if (newLine) {
                        buf.append(this.startBlockLevel());
                        String nextLine = this.peekAheadLine();
                        if (nextLine.length() != 0 && (nextLine.length() <= 0 || nextLine.startsWith("{{{") || nextLine.startsWith("----") || nextLine.startsWith("%%") || "*#!;".indexOf(nextLine.charAt(0)) != -1)) break;
                        buf.append(this.m_renderer.openParagraph());
                        this.m_isOpenParagraph = true;
                        break;
                    }
                    buf.append("\n");
                    newLine = true;
                    break;
                }
                case 92: {
                    s = this.handleBackslash();
                    break;
                }
                case 95: {
                    s = this.handleUnderscore();
                    break;
                }
                case 39: {
                    s = this.handleApostrophe();
                    break;
                }
                case 123: {
                    s = this.handleOpenbrace(newLine);
                    break;
                }
                case 125: {
                    s = this.handleClosebrace();
                    break;
                }
                case 45: {
                    s = this.handleDash();
                    break;
                }
                case 33: {
                    if (newLine) {
                        s = this.handleHeading();
                        break;
                    }
                    s = "!";
                    break;
                }
                case 59: {
                    if (newLine) {
                        s = this.handleDefinitionList();
                        break;
                    }
                    s = ";";
                    break;
                }
                case 58: {
                    if (this.m_isdefinition) {
                        s = this.m_renderer.closeDefinitionTitle() + this.m_renderer.openDefinitionItem();
                        this.m_isdefinition = false;
                        break;
                    }
                    s = ":";
                    break;
                }
                case 91: {
                    s = this.handleOpenbracket();
                    break;
                }
                case 42: {
                    if (newLine) {
                        this.pushBack(42);
                        s = this.handleGeneralList();
                        break;
                    }
                    s = "*";
                    break;
                }
                case 35: {
                    if (newLine) {
                        this.pushBack(35);
                        s = this.handleGeneralList();
                        break;
                    }
                    s = "#";
                    break;
                }
                case 124: {
                    s = this.handleBar(newLine);
                    break;
                }
                case 60: {
                    s = this.m_allowHTML ? "<" : "&lt;";
                    break;
                }
                case 62: {
                    s = this.m_allowHTML ? ">" : "&gt;";
                    break;
                }
                case 34: {
                    s = this.m_allowHTML ? "\"" : "&quot;";
                    break;
                }
                case 126: {
                    s = this.handleTilde();
                    break;
                }
                case 37: {
                    s = this.handleDiv(newLine);
                    break;
                }
                case -1: {
                    if (this.m_closeTag != null) {
                        buf.append(this.m_closeTag);
                        this.m_closeTag = null;
                    }
                    quitReading = true;
                    break;
                }
                default: {
                    buf.append((char)ch);
                    newLine = false;
                }
            }
            if (s == null) continue;
            buf.append(s);
            newLine = false;
        }
        this.m_data = new StringReader(buf.toString());
    }

    public int read() throws IOException {
        int val = this.m_data.read();
        if (val == -1) {
            this.fillBuffer();
            val = this.m_data.read();
            if (val == -1) {
                this.m_data = new StringReader(this.closeAll());
                val = this.m_data.read();
            }
        }
        return val;
    }

    public int read(char[] buf, int off, int len) throws IOException {
        return this.m_data.read(buf, off, len);
    }

    public boolean ready() throws IOException {
        log.debug((Object)("ready ? " + this.m_data.ready()));
        if (!this.m_data.ready()) {
            this.fillBuffer();
        }
        return this.m_data.ready();
    }

    public void close() {
    }

    public class TextRenderer {
        public void doChar(StringBuffer buf, char ch) {
            buf.append(ch);
        }

        public String openDiv(String style, String clazz) {
            return "";
        }

        public String closeDiv() {
            return "";
        }

        public String openSpan(String style, String clazz) {
            return "";
        }

        public String closeSpan() {
            return "";
        }

        public String openParagraph() {
            return "";
        }

        public String closeParagraph() {
            return "\n\n";
        }

        public String openTextEffect(int effect) {
            return "";
        }

        public String closeTextEffect(int effect) {
            return "";
        }

        public String openDefinitionItem() {
            return " : ";
        }

        public String closeDefinitionItem() {
            return "\n";
        }

        public String openDefinitionTitle() {
            return "";
        }

        public String closeDefinitionTitle() {
            return "";
        }

        public String openDefinitionList() {
            return "";
        }

        public String closeDefinitionList() {
            return "\n";
        }

        public String makeLink(int type, String link, String text) {
            return text;
        }

        public String makeLink(int type, String link, String text, String section) {
            return text;
        }

        public String makeError(String error) {
            return "ERROR: " + error;
        }

        public String makeRuler() {
            return "----------------------------------";
        }

        public String makeHeading(int level, String title, Heading hd) {
            String res = "";
            title = title.trim();
            hd.m_level = level;
            hd.m_titleText = title;
            hd.m_titleSection = "";
            hd.m_titleAnchor = "";
            switch (level) {
                case 1: {
                    res = title;
                    TranslatorReader.this.m_closeTag = "\n\n";
                    break;
                }
                case 2: {
                    res = title;
                    TranslatorReader.this.m_closeTag = "\n" + TextUtil.repeatString("-", title.length()) + "\n\n";
                    break;
                }
                case 3: {
                    res = title.toUpperCase();
                    TranslatorReader.this.m_closeTag = "\n" + TextUtil.repeatString("=", title.length()) + "\n\n";
                }
            }
            return res;
        }

        public String openList(char bullet) {
            return "\n";
        }

        public String openListItem() {
            return "- ";
        }

        public String closeListItem() {
            return "\n";
        }

        public String closeList(char bullet) {
            return "\n\n";
        }

        public String openTable() {
            return "\n";
        }

        public String closeTable() {
            return "\n";
        }

        public String openTableRow() {
            return "";
        }

        public String closeTableRow() {
            return "\n";
        }

        public String openTableItem() {
            return "\t";
        }

        public String closeTableItem() {
            return "";
        }

        public String openTableHeading() {
            return "\t";
        }

        public String closeTableHeading() {
            return "";
        }

        public String openPreformatted(boolean isBlock) {
            return "";
        }

        public String closePreformatted() {
            return "\n";
        }

        public String outlinkImage() {
            return "";
        }

        public String lineBreak(boolean clear) {
            return "\n";
        }
    }

    private class HTMLRenderer
    extends TextRenderer {
        private boolean m_isPreBlock = false;
        private TranslatorReader m_cleanTranslator;

        private TranslatorReader getCleanTranslator() {
            if (this.m_cleanTranslator == null) {
                WikiContext dummyContext = new WikiContext(TranslatorReader.this.m_engine, TranslatorReader.this.m_context.getPage());
                this.m_cleanTranslator = new TranslatorReader(dummyContext, null, new TextRenderer());
                this.m_cleanTranslator.m_allowHTML = true;
            }
            return this.m_cleanTranslator;
        }

        public void doChar(StringBuffer buf, char ch) {
            if (ch == '<') {
                buf.append("&lt;");
            } else if (ch == '>') {
                buf.append("&gt;");
            } else if (ch == '&') {
                buf.append("&amp;");
            } else {
                buf.append(ch);
            }
        }

        public String openDiv(String style, String clazz) {
            StringBuffer sb = new StringBuffer();
            sb.append("<div");
            sb.append(style != null ? " style=\"" + style + "\"" : "");
            sb.append(clazz != null ? " class=\"" + clazz + "\"" : "");
            sb.append(">");
            return sb.toString();
        }

        public String openSpan(String style, String clazz) {
            StringBuffer sb = new StringBuffer();
            sb.append("<span");
            sb.append(style != null ? " style=\"" + style + "\"" : "");
            sb.append(clazz != null ? " class=\"" + clazz + "\"" : "");
            sb.append(">");
            return sb.toString();
        }

        public String closeDiv() {
            return "</div>";
        }

        public String closeSpan() {
            return "</span>";
        }

        public String openParagraph() {
            return "<p>";
        }

        public String closeParagraph() {
            return "</p>\n";
        }

        public String openTextEffect(int effect) {
            switch (effect) {
                case 0: {
                    return "<b>";
                }
                case 1: {
                    return "<i>";
                }
                case 2: {
                    return "<tt>";
                }
            }
            return "";
        }

        public String closeTextEffect(int effect) {
            switch (effect) {
                case 0: {
                    return "</b>";
                }
                case 1: {
                    return "</i>";
                }
                case 2: {
                    return "</tt>";
                }
            }
            return "";
        }

        public String openDefinitionItem() {
            return "<dd>";
        }

        public String closeDefinitionItem() {
            return "</dd>\n";
        }

        public String openDefinitionTitle() {
            return "<dt>";
        }

        public String closeDefinitionTitle() {
            return "</dt>";
        }

        public String openDefinitionList() {
            return "<dl>\n";
        }

        public String closeDefinitionList() {
            return "</dl>";
        }

        public String makeLink(int type, String link, String text) {
            return this.makeLink(type, link, text, null);
        }

        private final String getURL(String context, String link) {
            return TranslatorReader.this.m_context.getURL(context, link, null);
        }

        public String makeLink(int type, String link, String text, String section) {
            String result;
            if (text == null) {
                text = link;
            }
            section = section != null ? "#" + section : "";
            String encodedlink = TranslatorReader.this.m_engine.encodeName(link);
            if (encodedlink.length() == 0) {
                type = 2;
            }
            switch (type) {
                case 0: {
                    result = "<a class=\"wikipage\" href=\"" + this.getURL(WikiContext.VIEW, link) + section + "\">" + text + "</a>";
                    break;
                }
                case 1: {
                    result = "<a class=\"createpage\" title=\"Create '" + link + "'\" href=\"" + this.getURL(WikiContext.EDIT, link) + "\">" + text + "</a>";
                    break;
                }
                case 2: {
                    result = "<u>" + text + "</u>";
                    break;
                }
                case 4: {
                    result = "<a class=\"footnoteref\" href=\"#ref-" + TranslatorReader.this.m_context.getPage().getName() + "-" + link + "\">[" + text + "]</a>";
                    break;
                }
                case 3: {
                    result = "<a class=\"footnote\" name=\"ref-" + TranslatorReader.this.m_context.getPage().getName() + "-" + link.substring(1) + "\">[" + text + "]</a>";
                    break;
                }
                case 5: {
                    result = "<img class=\"inline\" src=\"" + link + "\" alt=\"" + text + "\" />";
                    break;
                }
                case 8: {
                    result = "<a href=\"" + text + "\"><img class=\"inline\" src=\"" + link + "\" alt=\"" + text + "\"/></a>";
                    break;
                }
                case 9: {
                    String pagelink = this.getURL(WikiContext.VIEW, text);
                    result = "<a class=\"wikipage\" href=\"" + pagelink + "\"><img class=\"inline\" src=\"" + link + "\" alt=\"" + text + "\" /></a>";
                    break;
                }
                case 6: {
                    result = "<a class=\"external\" " + (TranslatorReader.this.m_useRelNofollow ? "rel=\"nofollow\" " : "") + "href=\"" + link + section + "\">" + text + "</a>";
                    break;
                }
                case 7: {
                    result = "<a class=\"interwiki\" href=\"" + link + section + "\">" + text + "</a>";
                    break;
                }
                case 10: {
                    String attlink = this.getURL(WikiContext.ATTACH, link);
                    String infolink = this.getURL(WikiContext.INFO, link);
                    String imglink = this.getURL(WikiContext.NONE, "images/attachment_small.png");
                    result = "<a class=\"attachment\" href=\"" + attlink + "\">" + text + "</a>" + "<a href=\"" + infolink + "\"><img src=\"" + imglink + "\" alt=\"(info)\"/></a>";
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public String makeError(String error) {
            return "<span class=\"error\">" + error + "</span>";
        }

        public String makeRuler() {
            return "<hr />";
        }

        private String makeHeadingAnchor(String baseName, String title, Heading hd) {
            hd.m_titleText = title;
            title = TranslatorReader.cleanLink(title);
            hd.m_titleSection = TranslatorReader.this.m_engine.encodeName(title);
            hd.m_titleAnchor = "section-" + TranslatorReader.this.m_engine.encodeName(baseName) + "-" + hd.m_titleSection;
            hd.m_titleAnchor = hd.m_titleAnchor.replace('%', '_');
            return hd.m_titleAnchor;
        }

        private String makeSectionTitle(String title) {
            title = title.trim();
            StringWriter outTitle = new StringWriter();
            try {
                TranslatorReader read = this.getCleanTranslator();
                read.setInputReader(new StringReader(title));
                FileUtil.copyContents(read, outTitle);
            }
            catch (IOException e) {
                log.fatal((Object)"CleanTranslator not working", (Throwable)e);
                throw new InternalWikiException("CleanTranslator not working as expected, when cleaning title" + e.getMessage());
            }
            return outTitle.toString();
        }

        public String makeHeading(int level, String title, Heading hd) {
            String res = "";
            String pageName = TranslatorReader.this.m_context.getPage().getName();
            String outTitle = this.makeSectionTitle(title);
            hd.m_level = level;
            switch (level) {
                case 1: {
                    res = "<h4 id='" + this.makeHeadingAnchor(pageName, outTitle, hd) + "'>";
                    TranslatorReader.this.m_closeTag = "</h4>";
                    break;
                }
                case 2: {
                    res = "<h3 id='" + this.makeHeadingAnchor(pageName, outTitle, hd) + "'>";
                    TranslatorReader.this.m_closeTag = "</h3>";
                    break;
                }
                case 3: {
                    res = "<h2 id='" + this.makeHeadingAnchor(pageName, outTitle, hd) + "'>";
                    TranslatorReader.this.m_closeTag = "</h2>";
                }
            }
            return res;
        }

        public String openList(char bullet) {
            String res = "";
            if (bullet == '#') {
                res = "<ol>\n";
            } else if (bullet == '*') {
                res = "<ul>\n";
            } else {
                log.info((Object)("Warning: unknown bullet character '" + bullet + "' at (+)"));
            }
            return res;
        }

        public String openListItem() {
            return "<li>";
        }

        public String closeListItem() {
            return "</li>\n";
        }

        public String closeList(char bullet) {
            String res = "";
            if (bullet == '#') {
                res = "</ol>\n";
            } else if (bullet == '*') {
                res = "</ul>\n";
            } else {
                log.info((Object)("Warning: unknown character in unwind '" + bullet + "'"));
            }
            return res;
        }

        public String openTable() {
            return "<table class=\"wikitable\" border=\"1\">\n";
        }

        public String closeTable() {
            return "</table>\n";
        }

        public String openTableRow() {
            return "<tr>";
        }

        public String closeTableRow() {
            return "</tr>";
        }

        public String openTableItem() {
            return "<td>";
        }

        public String closeTableItem() {
            return "</td>";
        }

        public String openTableHeading() {
            return "<th>";
        }

        public String closeTableHeading() {
            return "</th>";
        }

        public String openPreformatted(boolean isBlock) {
            this.m_isPreBlock = isBlock;
            if (isBlock) {
                return "<pre>";
            }
            return "<span style=\"font-family:monospace; whitespace:pre;\">";
        }

        public String closePreformatted() {
            if (this.m_isPreBlock) {
                return "</pre>\n";
            }
            return "</span>";
        }

        public String outlinkImage() {
            if (TranslatorReader.this.m_useOutlinkImage) {
                return "<img class=\"outlink\" src=\"" + this.getURL(WikiContext.NONE, "images/out.png") + "\" alt=\"\" />";
            }
            return "";
        }

        public String lineBreak(boolean clear) {
            if (clear) {
                return "<br clear=\"all\" />";
            }
            return "<br />";
        }
    }
}

