/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.NoSuchVariableException;
import com.ecyrd.jspwiki.Release;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.filters.PageFilter;
import com.ecyrd.jspwiki.modules.InternalModule;
import com.ecyrd.jspwiki.providers.WikiAttachmentProvider;
import java.security.Principal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class VariableManager {
    public static final String VAR_ERROR = "error";
    public static final String VAR_MSG = "msg";
    static final String[] THE_BIG_NO_NO_LIST = new String[]{"jspwiki.auth.masterpassword"};

    public VariableManager(Properties props) {
    }

    public static boolean isVariableLink(String link) {
        return link.startsWith("{$");
    }

    public String parseAndGetValue(WikiContext context, String link) throws IllegalArgumentException, NoSuchVariableException {
        if (!link.startsWith("{$")) {
            throw new IllegalArgumentException("Link does not start with {$");
        }
        if (!link.endsWith("}")) {
            throw new IllegalArgumentException("Link does not end with }");
        }
        String varName = link.substring(2, link.length() - 1);
        return this.getValue(context, varName.trim());
    }

    public String expandVariables(WikiContext context, String source) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) == '{') {
                if (i < source.length() - 2 && source.charAt(i + 1) == '$') {
                    String value;
                    int end = source.indexOf(125, i);
                    if (end == -1) continue;
                    String varname = source.substring(i + 2, end);
                    try {
                        value = this.getValue(context, varname);
                    }
                    catch (NoSuchVariableException e) {
                        value = e.getMessage();
                    }
                    catch (IllegalArgumentException e) {
                        value = e.getMessage();
                    }
                    result.append(value);
                    i = end;
                    continue;
                }
                result.append('{');
                continue;
            }
            result.append(source.charAt(i));
        }
        return result.toString();
    }

    public String getValue(WikiContext context, String varName, String defValue) {
        try {
            return this.getValue(context, varName);
        }
        catch (NoSuchVariableException e) {
            return defValue;
        }
    }

    public String getValue(WikiContext context, String varName) throws IllegalArgumentException, NoSuchVariableException {
        Properties props;
        String s;
        Object metadata;
        Object metadata2;
        WikiPage pg;
        if (varName == null) {
            throw new IllegalArgumentException("Null variable name.");
        }
        if (varName.length() == 0) {
            throw new IllegalArgumentException("Zero length variable name.");
        }
        String name = varName.toLowerCase();
        for (int i = 0; i < THE_BIG_NO_NO_LIST.length; ++i) {
            if (!name.equals(THE_BIG_NO_NO_LIST[i])) continue;
            return "";
        }
        if (name.equals("pagename")) {
            return context.getPage().getName();
        }
        if (name.equals("applicationname")) {
            return context.getEngine().getApplicationName();
        }
        if (name.equals("jspwikiversion")) {
            return Release.getVersionString();
        }
        if (name.equals("encoding")) {
            return context.getEngine().getContentEncoding();
        }
        if (name.equals("totalpages")) {
            return Integer.toString(context.getEngine().getPageCount());
        }
        if (name.equals("pageprovider")) {
            return context.getEngine().getCurrentProvider();
        }
        if (name.equals("pageproviderdescription")) {
            return context.getEngine().getCurrentProviderInfo();
        }
        if (name.equals("attachmentprovider")) {
            WikiAttachmentProvider p = context.getEngine().getAttachmentManager().getCurrentProvider();
            return p != null ? p.getClass().getName() : "-";
        }
        if (name.equals("attachmentproviderdescription")) {
            WikiAttachmentProvider p = context.getEngine().getAttachmentManager().getCurrentProvider();
            return p != null ? p.getProviderInfo() : "-";
        }
        if (name.equals("interwikilinks")) {
            StringBuffer res = new StringBuffer();
            Iterator i = context.getEngine().getAllInterWikiLinks().iterator();
            while (i.hasNext()) {
                if (res.length() > 0) {
                    res.append(", ");
                }
                String link = (String)i.next();
                res.append(link);
                res.append(" --> ");
                res.append(context.getEngine().getInterWikiURL(link));
            }
            return res.toString();
        }
        if (name.equals("inlinedimages")) {
            StringBuffer res = new StringBuffer();
            Iterator i = context.getEngine().getAllInlinedImagePatterns().iterator();
            while (i.hasNext()) {
                if (res.length() > 0) {
                    res.append(", ");
                }
                String ptrn = (String)i.next();
                res.append(ptrn);
            }
            return res.toString();
        }
        if (name.equals("pluginpath")) {
            String s2 = context.getEngine().getPluginSearchPath();
            return s2 == null ? "-" : s2;
        }
        if (name.equals("baseurl")) {
            return context.getEngine().getBaseURL();
        }
        if (name.equals("uptime")) {
            Date now = new Date();
            long secondsRunning = (now.getTime() - context.getEngine().getStartTime().getTime()) / 1000L;
            long seconds = secondsRunning % 60L;
            long minutes = (secondsRunning /= 60L) % 60L;
            long hours = (secondsRunning /= 60L) % 24L;
            long days = secondsRunning /= 24L;
            return days + "d, " + hours + "h " + minutes + "m " + seconds + "s";
        }
        if (name.equals("loginstatus")) {
            WikiSession session = context.getWikiSession();
            return session.getStatus();
        }
        if (name.equals("username")) {
            Principal wup = context.getCurrentUser();
            return wup != null ? wup.getName() : "not logged in";
        }
        if (name.equals("requestcontext")) {
            return context.getRequestContext();
        }
        if (name.equals("pagefilters")) {
            List filters = context.getEngine().getFilterManager().getFilterList();
            StringBuffer sb = new StringBuffer();
            Iterator i = filters.iterator();
            while (i.hasNext()) {
                PageFilter pf = (PageFilter)i.next();
                String f = pf.getClass().getName();
                if (pf instanceof InternalModule) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(f);
            }
            return sb.toString();
        }
        if (context.getVariable(varName) != null) {
            return context.getVariable(varName).toString();
        }
        HttpServletRequest req = context.getHttpRequest();
        if (req != null && req.getSession() != null) {
            HttpSession session = req.getSession();
            try {
                String s3 = (String)session.getAttribute(varName);
                if (s3 != null) {
                    return s3;
                }
                s3 = context.getHttpParameter(varName);
                if (s3 != null) {
                    return s3;
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        if ((pg = context.getPage()) != null && (metadata2 = pg.getAttribute(varName)) != null) {
            return metadata2.toString();
        }
        WikiPage rpg = context.getRealPage();
        if (rpg != null && (metadata = rpg.getAttribute(varName)) != null) {
            return metadata.toString();
        }
        if (varName.startsWith("jspwiki.") && (s = (props = context.getEngine().getWikiProperties()).getProperty(varName)) != null) {
            return s;
        }
        if (varName.equals(VAR_ERROR) || varName.equals(VAR_MSG)) {
            return "";
        }
        throw new NoSuchVariableException("No variable " + varName + " defined.");
    }
}

