/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.auth.AuthenticationManager;
import com.ecyrd.jspwiki.auth.Authorizer;
import com.ecyrd.jspwiki.auth.GroupPrincipal;
import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.SessionMonitor;
import com.ecyrd.jspwiki.auth.UserManager;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.authorize.Group;
import com.ecyrd.jspwiki.auth.authorize.GroupManager;
import com.ecyrd.jspwiki.auth.authorize.Role;
import com.ecyrd.jspwiki.auth.login.CookieAssertionLoginModule;
import com.ecyrd.jspwiki.auth.login.PrincipalWrapper;
import com.ecyrd.jspwiki.auth.user.UserDatabase;
import com.ecyrd.jspwiki.auth.user.UserProfile;
import com.ecyrd.jspwiki.event.WikiEvent;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.event.WikiSecurityEvent;
import java.security.AccessControlException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public final class WikiSession
implements WikiEventListener {
    public static final String ANONYMOUS = "anonymous";
    public static final String ASSERTED = "asserted";
    public static final String AUTHENTICATED = "authenticated";
    private static final int ONE = 48;
    private static final int NINE = 57;
    private static final int DOT = 46;
    private static final Logger log = Logger.getLogger((Class)WikiSession.class);
    private static final String ALL = "*";
    private static ThreadLocal c_guestSession = new ThreadLocal();
    private final Subject m_subject = new Subject();
    private final Map m_messages = new HashMap();
    private String m_cachedCookieIdentity = null;
    private String m_cachedRemoteUser = null;
    private Principal m_cachedUserPrincipal = null;
    private WikiEngine m_engine = null;
    private boolean m_isNew = true;
    private String m_status = "anonymous";
    private Principal m_userPrincipal = WikiPrincipal.GUEST;
    private Principal m_loginPrincipal = WikiPrincipal.GUEST;
    private Locale m_cachedLocale = Locale.getDefault();

    protected final boolean isInGroup(Group group) {
        Principal[] principals = this.getPrincipals();
        for (int i = 0; i < principals.length; ++i) {
            if (!this.isAuthenticated() || !group.isMember(principals[i])) continue;
            return true;
        }
        return false;
    }

    protected final boolean isNew() {
        return this.m_isNew;
    }

    protected final void setNew(boolean isNew) {
        this.m_isNew = isNew;
    }

    private WikiSession() {
    }

    public final boolean isAsserted() {
        return this.m_subject.getPrincipals().contains(Role.ASSERTED);
    }

    public final boolean isAuthenticated() {
        if (this.m_subject.getPrincipals().contains(Role.AUTHENTICATED)) {
            return true;
        }
        if (!this.isAnonymous() && !this.isAsserted()) {
            this.m_subject.getPrincipals().add(Role.AUTHENTICATED);
            return true;
        }
        return false;
    }

    public final boolean isAnonymous() {
        Set<Principal> principals = this.m_subject.getPrincipals();
        return principals.contains(Role.ANONYMOUS) || principals.contains(WikiPrincipal.GUEST) || WikiSession.isIPV4Address(this.getUserPrincipal().getName());
    }

    public final LoginContext getLoginContext(String application, CallbackHandler handler) throws LoginException {
        return new LoginContext(application, this.m_subject, handler);
    }

    public final Principal getLoginPrincipal() {
        if (this.m_loginPrincipal instanceof PrincipalWrapper) {
            return ((PrincipalWrapper)this.m_loginPrincipal).getPrincipal();
        }
        return this.m_loginPrincipal;
    }

    public final Principal getUserPrincipal() {
        if (this.m_loginPrincipal instanceof PrincipalWrapper) {
            return ((PrincipalWrapper)this.m_userPrincipal).getPrincipal();
        }
        return this.m_userPrincipal;
    }

    public final Locale getLocale() {
        return this.m_cachedLocale;
    }

    public final void addMessage(String message) {
        this.addMessage(ALL, message);
    }

    public final void addMessage(String topic, String message) {
        LinkedHashSet<String> messages;
        if (topic == null) {
            throw new IllegalArgumentException("addMessage: topic cannot be null.");
        }
        if (message == null) {
            message = "";
        }
        if ((messages = (LinkedHashSet<String>)this.m_messages.get(topic)) == null) {
            messages = new LinkedHashSet<String>();
            this.m_messages.put(topic, messages);
        }
        messages.add(message);
    }

    public final void clearMessages() {
        this.m_messages.clear();
    }

    public final void clearMessages(String topic) {
        Set messages = (Set)this.m_messages.get(topic);
        if (messages != null) {
            this.m_messages.clear();
        }
    }

    public final String[] getMessages() {
        return this.getMessages(ALL);
    }

    public final String[] getMessages(String topic) {
        Set messages = (Set)this.m_messages.get(topic);
        if (messages == null || messages.size() == 0) {
            return new String[0];
        }
        return messages.toArray(new String[messages.size()]);
    }

    public final Principal[] getPrincipals() {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        Iterator<Principal> it = this.m_subject.getPrincipals().iterator();
        while (it.hasNext()) {
            Principal principal = it.next();
            if (!AuthenticationManager.isUserPrincipal(principal)) continue;
            principals.add(principal);
        }
        return principals.toArray(new Principal[principals.size()]);
    }

    public final Principal[] getRoles() {
        HashSet roles = new HashSet();
        roles.addAll(this.m_subject.getPrincipals(Role.class));
        roles.addAll(this.m_subject.getPrincipals(GroupPrincipal.class));
        Principal[] roleArray = roles.toArray(new Principal[roles.size()]);
        Arrays.sort(roleArray, WikiPrincipal.COMPARATOR);
        return roleArray;
    }

    public static final void removeWikiSession(WikiEngine engine, HttpServletRequest request) {
        if (engine == null || request == null) {
            throw new IllegalArgumentException("Request or engine cannot be null.");
        }
        SessionMonitor monitor = SessionMonitor.getInstance(engine);
        monitor.remove(request.getSession());
    }

    public final boolean hasPrincipal(Principal principal) {
        return this.m_subject.getPrincipals().contains(principal);
    }

    public final void actionPerformed(WikiEvent event) {
        WikiSecurityEvent e;
        if (event instanceof WikiSecurityEvent && (e = (WikiSecurityEvent)event).getTarget() != null) {
            switch (e.getType()) {
                case 46: {
                    Group group = (Group)e.getTarget();
                    if (!this.isInGroup(group)) break;
                    this.m_subject.getPrincipals().add(group.getPrincipal());
                    break;
                }
                case 47: {
                    Group group = (Group)e.getTarget();
                    if (!this.m_subject.getPrincipals().contains(group.getPrincipal())) break;
                    this.m_subject.getPrincipals().remove(group.getPrincipal());
                    break;
                }
                case 48: {
                    this.m_subject.getPrincipals().removeAll(this.m_subject.getPrincipals(GroupPrincipal.class));
                    break;
                }
                case 30: {
                    WikiSession target = (WikiSession)e.getTarget();
                    if (!this.equals(target)) break;
                    this.updatePrincipals();
                    break;
                }
                case 32: {
                    WikiSession target = (WikiSession)e.getTarget();
                    if (!this.equals(target)) break;
                    this.m_status = ASSERTED;
                    break;
                }
                case 40: {
                    WikiSession target = (WikiSession)e.getTarget();
                    if (!this.equals(target)) break;
                    this.m_status = AUTHENTICATED;
                    this.injectUserProfilePrincipals();
                    this.injectRolePrincipals();
                    this.updatePrincipals();
                    break;
                }
                case 53: {
                    WikiSession source = (WikiSession)e.getSource();
                    if (!this.equals(source)) break;
                    this.injectUserProfilePrincipals();
                    this.updatePrincipals();
                    break;
                }
                case 54: {
                    WikiSession source = (WikiSession)e.getSource();
                    if (!this.equals(source)) break;
                    UserProfile[] profiles = (UserProfile[])e.getTarget();
                    UserProfile newProfile = profiles[1];
                    if (newProfile.getFullname() == null) {
                        throw new IllegalStateException("User profile FullName cannot be null.");
                    }
                    this.m_userPrincipal = new WikiPrincipal(newProfile.getFullname());
                    this.injectUserProfilePrincipals();
                    this.updatePrincipals();
                    break;
                }
            }
        }
    }

    public final void invalidate() {
        this.m_subject.getPrincipals().clear();
        this.m_subject.getPrincipals().add(WikiPrincipal.GUEST);
        this.m_subject.getPrincipals().add(Role.ANONYMOUS);
        this.m_subject.getPrincipals().add(Role.ALL);
        this.m_cachedCookieIdentity = null;
        this.m_cachedRemoteUser = null;
        this.m_cachedUserPrincipal = null;
    }

    protected final boolean isContainerStatusChanged(HttpServletRequest request) {
        if (request == null || this.m_status.equals(AUTHENTICATED)) {
            return false;
        }
        String remoteUser = request.getRemoteUser();
        Principal userPrincipal = request.getUserPrincipal();
        String cookieIdentity = CookieAssertionLoginModule.getUserCookie(request);
        boolean changed = false;
        if (remoteUser != null && !remoteUser.equals(this.m_cachedRemoteUser)) {
            this.m_cachedRemoteUser = remoteUser;
            log.info((Object)("Remote user changed to " + remoteUser));
            changed = true;
        }
        if (userPrincipal != null && !((Object)userPrincipal).equals(this.m_cachedUserPrincipal)) {
            this.m_cachedUserPrincipal = userPrincipal;
            log.info((Object)("User principal changed to " + userPrincipal.getName()));
            changed = true;
        }
        if (cookieIdentity != null && !cookieIdentity.equals(this.m_cachedCookieIdentity) || cookieIdentity == null && this.m_cachedCookieIdentity != null) {
            this.m_cachedCookieIdentity = cookieIdentity;
            log.info((Object)("Cookie changed to " + cookieIdentity));
            changed = true;
        }
        return changed;
    }

    protected final void injectRolePrincipals() {
        GroupManager manager = this.m_engine.getGroupManager();
        Principal[] groups = manager.getRoles();
        for (int i = 0; i < groups.length; ++i) {
            if (!manager.isUserInRole(this, groups[i])) continue;
            this.m_subject.getPrincipals().add(groups[i]);
        }
        try {
            Authorizer authorizer = this.m_engine.getAuthorizationManager().getAuthorizer();
            Principal[] roles = authorizer.getRoles();
            for (int i = 0; i < roles.length; ++i) {
                String roleName;
                Principal role = roles[i];
                if (!authorizer.isUserInRole(this, role) || Role.isReservedName(roleName = role.getName())) continue;
                this.m_subject.getPrincipals().add(new Role(roleName));
            }
        }
        catch (WikiException e) {
            log.error((Object)("Could not refresh role principals: " + e.getMessage()));
        }
    }

    protected final void injectUserProfilePrincipals() {
        Set<Principal> oldPrincipals = this.m_subject.getPrincipals();
        HashSet<Principal> newPrincipals = new HashSet<Principal>();
        Iterator<Principal> it = oldPrincipals.iterator();
        while (it.hasNext()) {
            Principal principal = it.next();
            if (!AuthenticationManager.isRolePrincipal(principal)) continue;
            newPrincipals.add(principal);
        }
        String searchId = this.getUserPrincipal().getName();
        if (searchId == null) {
            log.info((Object)"Refresh principals failed because WikiSession had no user Principal; maybe not logged in?");
            return;
        }
        UserDatabase database = this.m_engine.getUserManager().getUserDatabase();
        if (database == null) {
            throw new IllegalStateException("User database cannot be null.");
        }
        try {
            UserProfile profile = database.find(searchId);
            Principal[] principals = database.getPrincipals(profile.getLoginName());
            for (int i = 0; i < principals.length; ++i) {
                Principal principal = principals[i];
                newPrincipals.add(principal);
            }
            oldPrincipals.clear();
            oldPrincipals.addAll(newPrincipals);
        }
        catch (NoSuchPrincipalException e) {
            log.warn((Object)("User profile '" + searchId + "' not found. This is normal for container-auth users who haven't set up a profile yet."));
        }
    }

    protected final void updatePrincipals() {
        Set<Principal> principals = this.m_subject.getPrincipals();
        this.m_loginPrincipal = null;
        this.m_userPrincipal = null;
        Principal wikinamePrincipal = null;
        Principal fullnamePrincipal = null;
        Principal otherPrincipal = null;
        Iterator<Principal> it = principals.iterator();
        while (it.hasNext()) {
            Principal currentPrincipal = it.next();
            if (currentPrincipal instanceof Role || currentPrincipal instanceof GroupPrincipal) continue;
            if (currentPrincipal instanceof PrincipalWrapper) {
                this.m_loginPrincipal = currentPrincipal;
                continue;
            }
            if (currentPrincipal instanceof WikiPrincipal) {
                WikiPrincipal wp = (WikiPrincipal)currentPrincipal;
                if (wp.getType().equals("loginName")) {
                    this.m_loginPrincipal = wp;
                    continue;
                }
                if (wp.getType().equals("wikiName")) {
                    wikinamePrincipal = currentPrincipal;
                    this.m_userPrincipal = wp;
                    continue;
                }
                if (wp.getType().equals("fullName")) {
                    fullnamePrincipal = currentPrincipal;
                    continue;
                }
                otherPrincipal = currentPrincipal;
                continue;
            }
            if (otherPrincipal != null) continue;
            otherPrincipal = currentPrincipal;
        }
        if (otherPrincipal == null) {
            otherPrincipal = WikiPrincipal.GUEST;
        }
        if (this.m_loginPrincipal == null) {
            this.m_loginPrincipal = wikinamePrincipal;
            if (this.m_loginPrincipal == null) {
                this.m_loginPrincipal = fullnamePrincipal;
                if (this.m_loginPrincipal == null) {
                    this.m_loginPrincipal = otherPrincipal;
                }
            }
        }
        if (this.m_userPrincipal == null) {
            this.m_userPrincipal = wikinamePrincipal;
            if (this.m_userPrincipal == null) {
                this.m_userPrincipal = fullnamePrincipal;
                if (this.m_userPrincipal == null) {
                    this.m_userPrincipal = this.m_loginPrincipal;
                }
            }
        }
    }

    public final String getStatus() {
        return this.m_status;
    }

    public static final WikiSession getWikiSession(WikiEngine engine, HttpServletRequest request) {
        if (request == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Looking up WikiSession for NULL HttpRequest: returning guestSession()");
            }
            return WikiSession.staticGuestSession(engine);
        }
        HttpSession session = request.getSession();
        SessionMonitor monitor = SessionMonitor.getInstance(engine);
        WikiSession wikiSession = monitor.find(session);
        wikiSession.m_engine = engine;
        wikiSession.m_cachedLocale = request.getLocale();
        return wikiSession;
    }

    public static final WikiSession guestSession(WikiEngine engine) {
        WikiSession session = new WikiSession();
        session.m_engine = engine;
        session.invalidate();
        GroupManager groupMgr = engine.getGroupManager();
        AuthenticationManager authMgr = engine.getAuthenticationManager();
        UserManager userMgr = engine.getUserManager();
        groupMgr.addWikiEventListener(session);
        authMgr.addWikiEventListener(session);
        userMgr.addWikiEventListener(session);
        return session;
    }

    private static WikiSession staticGuestSession(WikiEngine engine) {
        WikiSession session = (WikiSession)c_guestSession.get();
        if (session == null) {
            session = WikiSession.guestSession(engine);
            c_guestSession.set(session);
        }
        return session;
    }

    public static final int sessions(WikiEngine engine) {
        SessionMonitor monitor = SessionMonitor.getInstance(engine);
        return monitor.sessions();
    }

    public static final Principal[] userPrincipals(WikiEngine engine) {
        SessionMonitor monitor = SessionMonitor.getInstance(engine);
        return monitor.userPrincipals();
    }

    public static final Object doPrivileged(WikiSession session, PrivilegedAction action) throws AccessControlException {
        return Subject.doAsPrivileged(session.m_subject, action, null);
    }

    protected static final boolean isIPV4Address(String name) {
        if (name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.') {
            return false;
        }
        int[] addr = new int[]{0, 0, 0, 0};
        int currentOctet = 0;
        for (int i = 0; i < name.length(); ++i) {
            boolean isDot;
            char ch = name.charAt(i);
            boolean isDigit = ch >= '0' && ch <= '9';
            boolean bl = isDot = ch == '.';
            if (!isDigit && !isDot) {
                return false;
            }
            if (isDigit) {
                addr[currentOctet] = 10 * addr[currentOctet] + (ch - 48);
                if (addr[currentOctet] <= 255) continue;
                return false;
            }
            if (name.charAt(i - 1) == '.') {
                return false;
            }
            ++currentOctet;
        }
        return currentOctet == 3;
    }
}

