/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.attachment;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.attachment.DynamicAttachment;
import com.ecyrd.jspwiki.parser.MarkupParser;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.WikiAttachmentProvider;
import com.ecyrd.jspwiki.util.ClassUtil;
import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.NeedsRefreshException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AttachmentManager {
    public static final String PROP_PROVIDER = "jspwiki.attachmentProvider";
    public static final String PROP_MAXSIZE = "jspwiki.attachment.maxsize";
    public static final String PROP_ALLOWEDEXTENSIONS = "jspwiki.attachment.allowed";
    public static final String PROP_FORDBIDDENEXTENSIONS = "jspwiki.attachment.forbidden";
    static Logger log = Logger.getLogger((Class)AttachmentManager.class);
    private WikiAttachmentProvider m_provider;
    private WikiEngine m_engine;
    private Cache m_dynamicAttachments = new Cache(true, false, false);

    public AttachmentManager(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        boolean useCache = "true".equals(props.getProperty("jspwiki.usePageCache"));
        String classname = useCache ? "com.ecyrd.jspwiki.providers.CachingAttachmentProvider" : props.getProperty(PROP_PROVIDER);
        if (classname == null) {
            log.info((Object)"No attachment provider defined - disabling attachment support.");
            return;
        }
        try {
            Class providerclass = ClassUtil.findClass("com.ecyrd.jspwiki.providers", classname);
            this.m_provider = (WikiAttachmentProvider)providerclass.newInstance();
            this.m_provider.initialize(this.m_engine, props);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Attachment provider class not found", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Attachment provider could not be created", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"You may not access the attachment provider class", (Throwable)e);
        }
        catch (NoRequiredPropertyException e) {
            log.error((Object)("Attachment provider did not find a property that it needed: " + e.getMessage()), (Throwable)e);
            this.m_provider = null;
        }
        catch (IOException e) {
            log.error((Object)"Attachment provider reports IO error", (Throwable)e);
            this.m_provider = null;
        }
    }

    public boolean attachmentsEnabled() {
        return this.m_provider != null;
    }

    public Attachment getAttachmentInfo(String name) throws ProviderException {
        return this.getAttachmentInfo(name, -1);
    }

    public Attachment getAttachmentInfo(String name, int version) throws ProviderException {
        if (name == null) {
            return null;
        }
        return this.getAttachmentInfo(null, name, version);
    }

    public Attachment getAttachmentInfo(WikiContext context, String attachmentname) throws ProviderException {
        return this.getAttachmentInfo(context, attachmentname, -1);
    }

    public Attachment getAttachmentInfo(WikiContext context, String attachmentname, int version) throws ProviderException {
        int cutpt;
        if (this.m_provider == null) {
            return null;
        }
        WikiPage currentPage = null;
        if (context != null) {
            currentPage = context.getPage();
        }
        if ((cutpt = attachmentname.lastIndexOf(47)) != -1) {
            String parentPage = attachmentname.substring(0, cutpt);
            parentPage = MarkupParser.cleanLink(parentPage);
            attachmentname = attachmentname.substring(cutpt + 1);
            if (parentPage.length() == 0) {
                return null;
            }
            currentPage = this.m_engine.getPage(parentPage);
            if (currentPage == null) {
                currentPage = this.m_engine.getPage(MarkupParser.wikifyLink(parentPage));
            }
        }
        if (currentPage == null || currentPage.getName().length() == 0) {
            return null;
        }
        Attachment att = this.getDynamicAttachment(currentPage.getName() + "/" + attachmentname);
        if (att == null) {
            att = this.m_provider.getAttachmentInfo(currentPage, attachmentname, version);
        }
        return att;
    }

    public Collection listAttachments(WikiPage wikipage) throws ProviderException {
        if (this.m_provider == null) {
            return new ArrayList();
        }
        Collection atts = this.m_provider.listAttachments(wikipage);
        if (atts instanceof List) {
            Collections.sort((List)atts);
        }
        return atts;
    }

    public boolean hasAttachments(WikiPage wikipage) {
        try {
            return this.listAttachments(wikipage).size() > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public InputStream getAttachmentStream(Attachment att) throws IOException, ProviderException {
        return this.getAttachmentStream(null, att);
    }

    public InputStream getAttachmentStream(WikiContext ctx, Attachment att) throws ProviderException, IOException {
        if (this.m_provider == null) {
            return null;
        }
        if (att instanceof DynamicAttachment) {
            return ((DynamicAttachment)att).getProvider().getAttachmentData(ctx, att);
        }
        return this.m_provider.getAttachmentData(att);
    }

    public void storeDynamicAttachment(WikiContext ctx, DynamicAttachment att) {
        this.m_dynamicAttachments.putInCache(att.getName(), (Object)att);
    }

    public DynamicAttachment getDynamicAttachment(String name) {
        try {
            return (DynamicAttachment)this.m_dynamicAttachments.getFromCache(name);
        }
        catch (NeedsRefreshException e) {
            this.m_dynamicAttachments.putInCache(name, null);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAttachment(Attachment att, File source) throws IOException, ProviderException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            this.storeAttachment(att, in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void storeAttachment(Attachment att, InputStream in) throws IOException, ProviderException {
        if (this.m_provider == null) {
            return;
        }
        this.m_provider.putAttachmentData(att, in);
        this.m_engine.getReferenceManager().updateReferences(att.getName(), new Vector());
        WikiPage parent = new WikiPage(this.m_engine, att.getParentName());
        this.m_engine.updateReferences(parent);
        this.m_engine.getSearchManager().reindexPage(att);
    }

    public List getVersionHistory(String attachmentName) throws ProviderException {
        if (this.m_provider == null) {
            return null;
        }
        Attachment att = this.getAttachmentInfo((WikiContext)null, attachmentName);
        if (att != null) {
            return this.m_provider.getVersionHistory(att);
        }
        return null;
    }

    public Collection getAllAttachments() throws ProviderException {
        if (this.attachmentsEnabled()) {
            return this.m_provider.listAllChanged(new Date(0L));
        }
        return new ArrayList();
    }

    public WikiAttachmentProvider getCurrentProvider() {
        return this.m_provider;
    }

    public void deleteVersion(Attachment att) throws ProviderException {
        if (this.m_provider == null) {
            return;
        }
        this.m_provider.deleteVersion(att);
    }

    public void deleteAttachment(Attachment att) throws ProviderException {
        if (this.m_provider == null) {
            return;
        }
        this.m_provider.deleteAttachment(att);
        this.m_engine.getSearchManager().pageRemoved(att);
        this.m_engine.getReferenceManager().clearPageEntries(att.getName());
    }
}

