/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.attachment;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.attachment.AttachmentManager;
import com.ecyrd.jspwiki.auth.permissions.PagePermission;
import com.ecyrd.jspwiki.auth.permissions.PermissionFactory;
import com.ecyrd.jspwiki.dav.AttachmentDavProvider;
import com.ecyrd.jspwiki.dav.DavPath;
import com.ecyrd.jspwiki.dav.DavProvider;
import com.ecyrd.jspwiki.dav.WebdavServlet;
import com.ecyrd.jspwiki.dav.methods.DavMethod;
import com.ecyrd.jspwiki.dav.methods.PropFindMethod;
import com.ecyrd.jspwiki.filters.RedirectException;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.ui.progress.ProgressItem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.iamvegan.multipartrequest.HttpServletMultipartRequest;
import net.iamvegan.multipartrequest.MultipartFile;
import net.iamvegan.multipartrequest.ProgressListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AttachmentServlet
extends WebdavServlet {
    private static final int BUFFER_SIZE = 8192;
    private static final long serialVersionUID = 3257282552187531320L;
    private WikiEngine m_engine;
    static Logger log = Logger.getLogger((String)AttachmentServlet.class.getName());
    private static final String HDR_VERSION = "version";
    protected static final long DEFAULT_EXPIRY = 86400000L;
    private String m_tmpDir;
    private DavProvider m_attachmentProvider;
    private int m_maxSize = Integer.MAX_VALUE;
    private String[] m_allowedPatterns;
    private String[] m_forbiddenPatterns;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_engine = WikiEngine.getInstance(config);
        Properties props = this.m_engine.getWikiProperties();
        this.m_attachmentProvider = new AttachmentDavProvider(this.m_engine);
        this.m_tmpDir = this.m_engine.getWorkDir() + File.separator + "attach-tmp";
        this.m_maxSize = TextUtil.getIntegerProperty(props, "jspwiki.attachment.maxsize", Integer.MAX_VALUE);
        String allowed = TextUtil.getStringProperty(props, "jspwiki.attachment.allowed", null);
        this.m_allowedPatterns = allowed != null && allowed.length() > 0 ? allowed.toLowerCase().split("\\s") : new String[0];
        String forbidden = TextUtil.getStringProperty(props, "jspwiki.attachment.forbidden", null);
        this.m_forbiddenPatterns = forbidden != null && forbidden.length() > 0 ? forbidden.toLowerCase().split("\\s") : new String[0];
        File f = new File(this.m_tmpDir);
        if (!f.exists()) {
            f.mkdirs();
        } else if (!f.isDirectory()) {
            log.fatal((Object)("A file already exists where the temporary dir is supposed to be: " + this.m_tmpDir + ".  Please remove it."));
        }
        log.debug((Object)("UploadServlet initialized. Using " + this.m_tmpDir + " for temporary storage."));
    }

    private boolean isTypeAllowed(String name) {
        int i;
        if (name == null || name.length() == 0) {
            return false;
        }
        name = name.toLowerCase();
        for (i = 0; i < this.m_forbiddenPatterns.length; ++i) {
            if (!name.endsWith(this.m_forbiddenPatterns[i]) || this.m_forbiddenPatterns[i].length() <= 0) continue;
            return false;
        }
        for (i = 0; i < this.m_allowedPatterns.length; ++i) {
            if (!name.endsWith(this.m_allowedPatterns[i]) || this.m_allowedPatterns[i].length() <= 0) continue;
            return true;
        }
        return this.m_allowedPatterns.length == 0;
    }

    public void doPropFind(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        PropFindMethod dm = new PropFindMethod(this.m_attachmentProvider);
        String p = new String(req.getPathInfo().getBytes("ISO-8859-1"), "UTF-8");
        DavPath path = new DavPath(p);
        ((DavMethod)dm).execute(req, res, path);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) {
        res.setHeader("DAV", "1");
        res.setHeader("Allow", "GET, PUT, POST, OPTIONS, PROPFIND, PROPPATCH, MOVE, COPY, DELETE");
        res.setStatus(200);
    }

    /*
     * Exception decompiling
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 60[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getMimeType(WikiContext ctx, String fileName) {
        ServletContext s;
        String mimetype = null;
        HttpServletRequest req = ctx.getHttpRequest();
        if (req != null && (s = req.getSession().getServletContext()) != null) {
            mimetype = s.getMimeType(fileName.toLowerCase());
        }
        if (mimetype == null) {
            mimetype = "application/binary";
        }
        return mimetype;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            String nextPage = this.upload(req);
            req.getSession().removeAttribute("msg");
            res.sendRedirect(nextPage);
        }
        catch (RedirectException e) {
            WikiSession session = WikiSession.getWikiSession(this.m_engine, req);
            session.addMessage(e.getMessage());
            req.getSession().setAttribute("msg", (Object)e.getMessage());
            res.sendRedirect(e.getRedirect());
        }
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String errorPage = this.m_engine.getURL(WikiContext.ERROR, "", null, false);
        String p = new String(req.getPathInfo().getBytes("ISO-8859-1"), "UTF-8");
        DavPath path = new DavPath(p);
        try {
            ServletInputStream data = req.getInputStream();
            WikiContext context = this.m_engine.createContext(req, WikiContext.UPLOAD);
            String wikipage = path.get(0);
            errorPage = context.getURL(WikiContext.UPLOAD, wikipage);
            String changeNote = null;
            boolean created = this.executeUpload(context, (InputStream)data, path.getName(), errorPage, wikipage, changeNote, req.getContentLength());
            if (created) {
                res.sendError(201);
            } else {
                res.sendError(200);
            }
        }
        catch (ProviderException e) {
            res.sendError(500, e.getMessage());
        }
        catch (RedirectException e) {
            res.sendError(500, e.getMessage());
        }
    }

    private String validateNextPage(String nextPage, String errorPage) {
        if (nextPage.indexOf("://") != -1 && !nextPage.startsWith(this.m_engine.getBaseURL())) {
            log.warn((Object)("Detected phishing attempt by redirecting to an unsecure location: " + nextPage));
            nextPage = errorPage;
        }
        return nextPage;
    }

    protected String upload(HttpServletRequest req) throws RedirectException, IOException {
        String errorPage;
        String msg = "";
        String attName = "(unknown)";
        String nextPage = errorPage = this.m_engine.getURL(WikiContext.ERROR, "", null, false);
        String progressId = req.getParameter("progressid");
        try {
            WikiContext context = this.m_engine.createContext(req, WikiContext.ATTACH);
            UploadListener pl = new UploadListener();
            this.m_engine.getProgressManager().startProgress(pl, progressId);
            HttpServletMultipartRequest multi = new HttpServletMultipartRequest(req, Long.MAX_VALUE, 103, 100, "UTF-8", (ProgressListener)pl);
            nextPage = this.validateNextPage(multi.getParameter("nextpage"), errorPage);
            String wikipage = multi.getParameter("page");
            String changeNote = multi.getParameter("changenote");
            int x = wikipage.indexOf("/");
            if (x != -1) {
                wikipage = wikipage.substring(0, x);
            }
            Enumeration files = multi.getFileParameterNames();
            long fileSize = 0L;
            while (files.hasMoreElements()) {
                String part = (String)files.nextElement();
                MultipartFile multiFile = multi.getFileParameter(part);
                InputStream in = multiFile.getInputStream();
                String filename = multiFile.getName();
                this.executeUpload(context, in, filename, nextPage, wikipage, changeNote, fileSize += multiFile.getSize());
            }
        }
        catch (ProviderException e) {
            msg = "Upload failed because the provider failed: " + e.getMessage();
            log.warn((Object)(msg + " (attachment: " + attName + ")"), (Throwable)e);
            throw new IOException(msg);
        }
        catch (IOException e) {
            msg = "Upload failure: " + e.getMessage();
            log.warn((Object)(msg + " (attachment: " + attName + ")"), (Throwable)e);
            throw e;
        }
        finally {
            this.m_engine.getProgressManager().stopProgress(progressId);
        }
        return nextPage;
    }

    protected boolean executeUpload(WikiContext context, InputStream data, String filename, String errorPage, String parentPage, String changenote, long contentLength) throws RedirectException, IOException, ProviderException {
        boolean created = false;
        if (!context.hasAdminPermissions()) {
            if (contentLength > (long)this.m_maxSize) {
                throw new RedirectException("File exceeds maximum size (" + this.m_maxSize + " bytes)", errorPage);
            }
            if (!this.isTypeAllowed(filename)) {
                throw new RedirectException("Files of this type may not be uploaded to this wiki", errorPage);
            }
        }
        Principal user = context.getCurrentUser();
        AttachmentManager mgr = this.m_engine.getAttachmentManager();
        if (filename == null || filename.trim().length() == 0) {
            log.error((Object)"Empty file name given.");
            throw new RedirectException("Empty file name given.", errorPage);
        }
        filename = filename.trim();
        filename = StringUtils.replaceChars((String)filename, (String)"#?\"'", (String)"____");
        log.debug((Object)("file=" + filename));
        if (data == null) {
            log.error((Object)"File could not be opened.");
            throw new RedirectException("File could not be opened.", errorPage);
        }
        Attachment att = mgr.getAttachmentInfo(context.getPage().getName());
        if (att == null) {
            att = new Attachment(this.m_engine, parentPage, filename);
            created = true;
        }
        att.setSize(contentLength);
        PagePermission permission = PermissionFactory.getPagePermission(att, "upload");
        if (this.m_engine.getAuthorizationManager().checkPermission(context.getWikiSession(), permission)) {
            if (user != null) {
                att.setAuthor(user.getName());
            }
            if (changenote != null && changenote.length() > 0) {
                att.setAttribute("changenote", changenote);
            }
        } else {
            throw new RedirectException("No permission to upload a file", errorPage);
        }
        this.m_engine.getAttachmentManager().storeAttachment(att, data);
        log.info((Object)("User " + user + " uploaded attachment to " + parentPage + " called " + filename + ", size " + att.getSize()));
        return created;
    }

    private class UploadListener
    extends ProgressItem
    implements ProgressListener {
        public long m_currentBytes;
        public long m_totalBytes;
        public String m_uid;

        private UploadListener() {
        }

        public void update(long recvdBytes, long totalBytes, int item) {
            this.m_currentBytes = recvdBytes;
            this.m_totalBytes = totalBytes;
        }

        public int getProgress() {
            return (int)((double)((float)this.m_currentBytes / (float)this.m_totalBytes * 100.0f) + 0.5);
        }
    }
}

