/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.AuthorizationManager;
import com.ecyrd.jspwiki.auth.Authorizer;
import com.ecyrd.jspwiki.auth.GroupPrincipal;
import com.ecyrd.jspwiki.auth.PolicyLoader;
import com.ecyrd.jspwiki.auth.UserManager;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.authorize.Role;
import com.ecyrd.jspwiki.auth.authorize.WebContainerAuthorizer;
import com.ecyrd.jspwiki.auth.login.CookieAssertionLoginModule;
import com.ecyrd.jspwiki.auth.login.CookieAuthenticationLoginModule;
import com.ecyrd.jspwiki.auth.login.WebContainerCallbackHandler;
import com.ecyrd.jspwiki.auth.login.WikiCallbackHandler;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.event.WikiEventManager;
import com.ecyrd.jspwiki.event.WikiSecurityEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public final class AuthenticationManager {
    public static final String COOKIE_MODULE = CookieAssertionLoginModule.class.getName();
    public static final String COOKIE_AUTHENTICATION_MODULE = CookieAuthenticationLoginModule.class.getName();
    public static final String LOGIN_CONTAINER = "JSPWiki-container";
    public static final String LOGIN_CUSTOM = "JSPWiki-custom";
    public static final String PROP_STOREIPADDRESS = "jspwiki.storeIPAddress";
    protected static final Logger log = Logger.getLogger((Class)AuthenticationManager.class);
    protected boolean m_isJaasConfiguredAtStartup = false;
    private static Boolean c_allowsAssertions = null;
    private static Boolean c_allowsAuthentication = null;
    private WikiEngine m_engine = null;
    private boolean m_storeIPAddress = true;
    public static final String SECURITY_OFF = "off";
    protected static final String SECURITY_CONTAINER = "container";
    public static final String SECURITY_JAAS = "jaas";
    public static final String PROP_SECURITY = "jspwiki.security";
    private static final String PROP_JAAS_CONFIG = "java.security.auth.login.config";
    private static final String DEFAULT_JAAS_CONFIG = "jspwiki.jaas";
    private static boolean c_useJAAS = true;

    public final void initialize(WikiEngine engine, Properties props) throws WikiException {
        this.m_engine = engine;
        this.m_storeIPAddress = TextUtil.getBooleanProperty(props, PROP_STOREIPADDRESS, this.m_storeIPAddress);
        this.m_isJaasConfiguredAtStartup = PolicyLoader.isJaasConfigured();
        c_useJAAS = SECURITY_JAAS.equals(props.getProperty(PROP_SECURITY, SECURITY_JAAS));
        if (!c_useJAAS) {
            return;
        }
        log.info((Object)"Checking JAAS configuration...");
        if (!this.m_isJaasConfiguredAtStartup) {
            URL config = AuthenticationManager.findConfigFile(engine, DEFAULT_JAAS_CONFIG);
            log.info((Object)("JAAS not configured. Installing default configuration: " + config + ". You can set the " + PROP_JAAS_CONFIG + " system property to point to your " + "jspwiki.jaas file, or add the entries from jspwiki.jaas to your own " + "JAAS configuration file."));
            try {
                PolicyLoader.setJaasConfiguration(config);
            }
            catch (SecurityException e) {
                log.error((Object)("Could not configure JAAS: " + e.getMessage()));
            }
        } else {
            log.info((Object)"JAAS already configured by some other application (leaving it alone...)");
        }
    }

    public final boolean isContainerAuthenticated() {
        if (!c_useJAAS) {
            return true;
        }
        try {
            Authorizer authorizer = this.m_engine.getAuthorizationManager().getAuthorizer();
            if (authorizer instanceof WebContainerAuthorizer) {
                return ((WebContainerAuthorizer)authorizer).isContainerAuthorized();
            }
        }
        catch (WikiException wikiException) {
            // empty catch block
        }
        return false;
    }

    public final boolean login(HttpServletRequest request) throws WikiSecurityException {
        if (request == null) {
            throw new IllegalStateException("Wiki context's HttpRequest may not be null");
        }
        WikiSession wikiSession = WikiSession.getWikiSession(this.m_engine, request);
        if (wikiSession == null) {
            throw new IllegalStateException("Wiki context's WikiSession may not be null");
        }
        boolean login = true;
        if (c_useJAAS) {
            AuthorizationManager authMgr = this.m_engine.getAuthorizationManager();
            WebContainerCallbackHandler handler = new WebContainerCallbackHandler(this.m_engine, request, authMgr.getAuthorizer());
            login = this.doLogin(wikiSession, handler, LOGIN_CONTAINER);
        }
        return login;
    }

    public final boolean login(WikiSession session, String username, String password) throws WikiSecurityException {
        if (session == null) {
            log.error((Object)"No wiki session provided, cannot log in.");
            return false;
        }
        UserManager userMgr = this.m_engine.getUserManager();
        WikiCallbackHandler handler = new WikiCallbackHandler(userMgr.getUserDatabase(), username, password);
        return this.doLogin(session, handler, LOGIN_CUSTOM);
    }

    public final void logout(HttpServletRequest request) {
        String sid;
        if (request == null) {
            log.error((Object)"No HTTP reqest provided; cannot log out.");
            return;
        }
        HttpSession session = request.getSession();
        String string = sid = session == null ? "(null)" : session.getId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invalidating WikiSession for session ID=" + sid));
        }
        WikiSession wikiSession = WikiSession.getWikiSession(this.m_engine, request);
        Principal originalPrincipal = wikiSession.getLoginPrincipal();
        wikiSession.invalidate();
        WikiSession.removeWikiSession(this.m_engine, request);
        if (session != null) {
            session.invalidate();
        }
        this.fireEvent(44, originalPrincipal, null);
    }

    public static final boolean allowsCookieAssertions() {
        if (!c_useJAAS) {
            return true;
        }
        if (c_allowsAssertions == null) {
            AppConfigurationEntry[] configs;
            c_allowsAssertions = Boolean.FALSE;
            Configuration loginConfig = (Configuration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Configuration.getConfiguration();
                }
            });
            if (loginConfig != null && (configs = loginConfig.getAppConfigurationEntry(LOGIN_CONTAINER)) != null) {
                for (int i = 0; i < configs.length; ++i) {
                    AppConfigurationEntry config = configs[i];
                    if (!COOKIE_MODULE.equals(config.getLoginModuleName())) continue;
                    c_allowsAssertions = Boolean.TRUE;
                }
            }
        }
        return c_allowsAssertions;
    }

    public static final boolean allowsCookieAuthentication() {
        if (!c_useJAAS) {
            return true;
        }
        if (c_allowsAuthentication == null) {
            AppConfigurationEntry[] configs;
            c_allowsAuthentication = Boolean.FALSE;
            Configuration loginConfig = (Configuration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Configuration.getConfiguration();
                }
            });
            if (loginConfig != null && (configs = loginConfig.getAppConfigurationEntry(LOGIN_CONTAINER)) != null) {
                for (int i = 0; i < configs.length; ++i) {
                    AppConfigurationEntry config = configs[i];
                    if (!COOKIE_AUTHENTICATION_MODULE.equals(config.getLoginModuleName())) continue;
                    c_allowsAuthentication = Boolean.TRUE;
                }
            }
        }
        return c_allowsAuthentication;
    }

    public static final boolean isRolePrincipal(Principal principal) {
        return principal instanceof Role || principal instanceof GroupPrincipal;
    }

    public static final boolean isUserPrincipal(Principal principal) {
        return !AuthenticationManager.isRolePrincipal(principal);
    }

    private final boolean doLogin(final WikiSession wikiSession, final CallbackHandler handler, final String application) throws WikiSecurityException {
        try {
            LoginContext loginContext = (LoginContext)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return wikiSession.getLoginContext(application, handler);
                    }
                    catch (LoginException e) {
                        log.error((Object)("Couldn't retrieve login configuration.\nMessage=" + e.getLocalizedMessage()));
                        return null;
                    }
                }
            });
            if (loginContext == null) {
                log.error((Object)"No login context.  Please double-check that JSPWiki found your 'jspwiki.jaas' file or the contents have been appended to your regular JAAS file.");
                return false;
            }
            loginContext.login();
            this.fireEvent(30, null, wikiSession);
            if (wikiSession.isAnonymous()) {
                this.fireEvent(31, wikiSession.getLoginPrincipal(), wikiSession);
            } else if (wikiSession.isAsserted()) {
                this.fireEvent(32, wikiSession.getLoginPrincipal(), wikiSession);
            } else if (wikiSession.isAuthenticated()) {
                this.fireEvent(40, wikiSession.getLoginPrincipal(), wikiSession);
            }
            return true;
        }
        catch (FailedLoginException e) {
            log.info((Object)("Failed login: " + e.getLocalizedMessage()));
            this.fireEvent(43, wikiSession.getLoginPrincipal(), wikiSession);
            return false;
        }
        catch (AccountExpiredException e) {
            log.info((Object)("Expired account: " + e.getLocalizedMessage()));
            this.fireEvent(41, wikiSession.getLoginPrincipal(), wikiSession);
            return false;
        }
        catch (CredentialExpiredException e) {
            log.info((Object)("Credentials expired: " + e.getLocalizedMessage()));
            this.fireEvent(42, wikiSession.getLoginPrincipal(), wikiSession);
            return false;
        }
        catch (LoginException e) {
            log.error((Object)("Couldn't log in.\nMessage=" + e.getLocalizedMessage()));
            return false;
        }
        catch (SecurityException e) {
            log.error((Object)"Could not log in.  Please check that your jaas.config file is found.", (Throwable)e);
            return false;
        }
    }

    protected static final URL findConfigFile(WikiEngine engine, String name) {
        ClassLoader cl;
        URL path;
        File defaultFile = null;
        if (engine.getRootPath() != null) {
            defaultFile = new File(engine.getRootPath() + "/WEB-INF/" + name);
        }
        if (defaultFile != null && defaultFile.exists()) {
            try {
                return defaultFile.toURL();
            }
            catch (MalformedURLException e) {
                log.warn((Object)("Malformed URL: " + e.getMessage()));
            }
        }
        if ((path = (cl = AuthenticationManager.class.getClassLoader()).getResource("/WEB-INF/" + name)) == null) {
            path = cl.getResource("/" + name);
        }
        if (path == null) {
            path = cl.getResource(name);
        }
        if (path == null && engine.getServletContext() != null) {
            try {
                path = engine.getServletContext().getResource("/WEB-INF/" + name);
            }
            catch (MalformedURLException e) {
                log.fatal((Object)"Your code is b0rked.  You are a bad person.");
            }
        }
        return path;
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type, Principal principal, Object target) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent(this, type, principal, target));
        }
    }
}

