/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.Security;
import javax.security.auth.login.Configuration;
import org.apache.log4j.Logger;

public final class PolicyLoader {
    protected static final Logger log = Logger.getLogger((Class)PolicyLoader.class);

    private PolicyLoader() {
    }

    public static final boolean isJaasConfigured() throws SecurityException {
        Boolean configured = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean isConfigured = false;
                try {
                    Configuration config = Configuration.getConfiguration();
                    isConfigured = config != null;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return isConfigured;
            }
        });
        return configured;
    }

    public static final boolean isSecurityPolicyConfigured() throws SecurityException {
        String policy = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.security.policy");
            }
        });
        if (policy != null) {
            File jks;
            File f;
            log.info((Object)("Java security policy already set to: " + policy + ". (Leaving it alone...)"));
            if (policy.startsWith("file:")) {
                policy = policy.substring("file:".length());
            }
            if (!(f = new File(policy)).exists()) {
                log.warn((Object)("You have set your 'java.security.policy' to point at '" + f.getAbsolutePath() + "', " + "but that file does not seem to exist.  I'll continue anyway, since this may be " + "something specific to your servlet container.  Just consider yourself warned."));
            }
            if (!(jks = new File(f.getParentFile(), "jspwiki.jks")).exists() || !jks.canRead()) {
                log.warn((Object)("I could not locate the JSPWiki keystore ('jspwiki.jks') in the same directory as your jspwiki.policy file. On many servlet containers, such as Tomcat, this needs to be done.  If you keep having access right permissions, please try copying your WEB-INF/jspwiki.jks to " + f.getParentFile().getAbsolutePath()));
            } else {
                log.info((Object)("Found 'jspwiki.jks' from '" + f.getParentFile().getAbsolutePath() + "'.  If you are having " + "permission issues after an upgrade, please make sure that this file matches the one that " + "came with your distribution archive."));
            }
        }
        return policy != null;
    }

    public static final void setJaasConfiguration(final URL url) throws SecurityException {
        if (url == null) {
            throw new SecurityException("URL for JAAS configuration cannot be null.");
        }
        String defaultConfigClass = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("login.configuration.provider");
            }
        });
        if (defaultConfigClass == null) {
            defaultConfigClass = "com.sun.security.auth.login.ConfigFile";
        }
        final String config_class = defaultConfigClass;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Configuration.setConfiguration(null);
                    System.setProperty("java.security.auth.login.config", url.toExternalForm());
                    Configuration config = (Configuration)Class.forName(config_class).newInstance();
                    Configuration.setConfiguration(config);
                    return null;
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage());
                }
            }
        });
    }

    public static final void setSecurityPolicy(final URL url) throws SecurityException {
        if (url == null) {
            throw new SecurityException("URL for security policy cannot be null.");
        }
        String defaultPolicyClass = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("policy.provider");
            }
        });
        if (defaultPolicyClass == null) {
            defaultPolicyClass = "sun.security.provider.PolicyFile";
        }
        final String policyClass = defaultPolicyClass;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Policy.setPolicy(null);
                    System.setProperty("java.security.policy", url.toExternalForm());
                    Policy policy = (Policy)Class.forName(policyClass).newInstance();
                    Policy.setPolicy(policy);
                    return null;
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage());
                }
            }
        });
    }
}

