/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.PrincipalComparator;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.event.WikiEventManager;
import com.ecyrd.jspwiki.event.WikiSecurityEvent;
import com.ecyrd.jspwiki.rpc.json.JSONRPCManager;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;

public class SessionMonitor
implements HttpSessionListener {
    private static Logger log = Logger.getLogger((Class)SessionMonitor.class);
    private static Map c_monitors = new HashMap();
    private final Map m_sessions = new WeakHashMap();
    private WikiEngine m_engine;
    private final PrincipalComparator m_comparator = new PrincipalComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SessionMonitor getInstance(WikiEngine engine) {
        SessionMonitor monitor;
        if (engine == null) {
            throw new IllegalArgumentException("Engine cannot be null.");
        }
        Map map = c_monitors;
        synchronized (map) {
            monitor = (SessionMonitor)c_monitors.get(engine);
            if (monitor == null) {
                monitor = new SessionMonitor(engine);
                c_monitors.put(engine, monitor);
            }
        }
        return monitor;
    }

    public SessionMonitor() {
    }

    private SessionMonitor(WikiEngine engine) {
        this.m_engine = engine;
    }

    private WikiSession findSession(HttpSession session) {
        WikiSession wikiSession = null;
        String sid = session == null ? "(null)" : session.getId();
        WikiSession storedSession = (WikiSession)this.m_sessions.get(sid);
        if (storedSession != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking up WikiSession for session ID=" + sid + "... found it"));
            }
            wikiSession = storedSession;
        }
        return wikiSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final WikiSession find(HttpSession session) {
        String sid;
        WikiSession wikiSession = this.findSession(session);
        String string = sid = session == null ? "(null)" : session.getId();
        if (wikiSession == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking up WikiSession for session ID=" + sid + "... not found. Creating guestSession()"));
            }
            wikiSession = WikiSession.guestSession(this.m_engine);
            Map map = this.m_sessions;
            synchronized (map) {
                this.m_sessions.put(sid, wikiSession);
            }
        }
        return wikiSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(HttpSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null.");
        }
        Map map = this.m_sessions;
        synchronized (map) {
            this.m_sessions.remove(session.getId());
        }
    }

    public final int sessions() {
        return this.userPrincipals().length;
    }

    public final Principal[] userPrincipals() {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        Iterator it = this.m_sessions.values().iterator();
        while (it.hasNext()) {
            WikiSession session = (WikiSession)it.next();
            principals.add(session.getUserPrincipal());
        }
        Principal[] p = principals.toArray(new Principal[principals.size()]);
        Arrays.sort(p, this.m_comparator);
        return p;
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type, Principal principal, WikiSession session) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent(this, type, principal, session));
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        JSONRPCManager.sessionCreated(session);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        Iterator it = c_monitors.values().iterator();
        while (it.hasNext()) {
            SessionMonitor monitor = (SessionMonitor)it.next();
            WikiSession storedSession = monitor.findSession(session);
            monitor.remove(session);
            log.debug((Object)("Removed session " + session.getId() + "."));
            if (storedSession == null) continue;
            this.fireEvent(45, storedSession.getLoginPrincipal(), storedSession);
        }
    }
}

