/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.AuthenticationManager;
import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.permissions.AllPermission;
import com.ecyrd.jspwiki.auth.permissions.WikiPermission;
import com.ecyrd.jspwiki.auth.user.AbstractUserDatabase;
import com.ecyrd.jspwiki.auth.user.DuplicateUserException;
import com.ecyrd.jspwiki.auth.user.UserDatabase;
import com.ecyrd.jspwiki.auth.user.UserProfile;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.event.WikiEventManager;
import com.ecyrd.jspwiki.event.WikiSecurityEvent;
import com.ecyrd.jspwiki.filters.PageFilter;
import com.ecyrd.jspwiki.filters.SpamFilter;
import com.ecyrd.jspwiki.rpc.RPCCallable;
import com.ecyrd.jspwiki.rpc.json.JSONRPCManager;
import com.ecyrd.jspwiki.ui.InputValidator;
import com.ecyrd.jspwiki.util.ClassUtil;
import com.ecyrd.jspwiki.util.MailUtil;
import com.ecyrd.jspwiki.workflow.Decision;
import com.ecyrd.jspwiki.workflow.DecisionRequiredException;
import com.ecyrd.jspwiki.workflow.Fact;
import com.ecyrd.jspwiki.workflow.Outcome;
import com.ecyrd.jspwiki.workflow.Task;
import com.ecyrd.jspwiki.workflow.Workflow;
import com.ecyrd.jspwiki.workflow.WorkflowBuilder;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public final class UserManager {
    private static final String USERDATABASE_PACKAGE = "com.ecyrd.jspwiki.auth.user";
    private static final String SESSION_MESSAGES = "profile";
    private static final String PARAM_EMAIL = "email";
    private static final String PARAM_FULLNAME = "fullname";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_LOGINNAME = "loginname";
    private static final String UNKNOWN_CLASS = "<unknown>";
    private WikiEngine m_engine;
    private static Logger log = Logger.getLogger((Class)UserManager.class);
    public static final String SAVE_APPROVER = "workflow.createUserProfile";
    private static final String PROP_DATABASE = "jspwiki.userdatabase";
    protected static final String SAVE_TASK_MESSAGE_KEY = "task.createUserProfile";
    protected static final String SAVED_PROFILE = "userProfile";
    protected static final String SAVE_DECISION_MESSAGE_KEY = "decision.createUserProfile";
    protected static final String FACT_SUBMITTER = "fact.submitter";
    protected static final String PREFS_LOGIN_NAME = "prefs.loginname";
    protected static final String PREFS_FULL_NAME = "prefs.fullname";
    protected static final String PREFS_EMAIL = "prefs.email";
    private final Map m_profiles = new WeakHashMap();
    private UserDatabase m_database;
    private boolean m_useJAAS = true;

    public final void initialize(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        this.m_useJAAS = "jaas".equals(props.getProperty("jspwiki.security", "jaas"));
        this.addWikiEventListener(engine.getPageManager());
        JSONRPCManager.registerGlobalObject("users", new JSONUserModule(), new AllPermission(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UserDatabase getUserDatabase() {
        if (this.m_database != null) {
            return this.m_database;
        }
        if (!this.m_useJAAS) {
            this.m_database = new DummyUserDatabase();
            return this.m_database;
        }
        String dbClassName = UNKNOWN_CLASS;
        try {
            dbClassName = WikiEngine.getRequiredProperty(this.m_engine.getWikiProperties(), PROP_DATABASE);
            log.info((Object)("Attempting to load user database class " + dbClassName));
            Class dbClass = ClassUtil.findClass(USERDATABASE_PACKAGE, dbClassName);
            this.m_database = (UserDatabase)dbClass.newInstance();
            this.m_database.initialize(this.m_engine, this.m_engine.getWikiProperties());
            log.info((Object)"UserDatabase initialized.");
        }
        catch (NoRequiredPropertyException e) {
            log.error((Object)"You have not set the 'jspwiki.userdatabase'. You need to do this if you want to enable user management by JSPWiki.");
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("UserDatabase class " + dbClassName + " cannot be found"), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)("UserDatabase class " + dbClassName + " cannot be created"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"You are not allowed to access this user database class", (Throwable)e);
        }
        finally {
            if (this.m_database == null) {
                log.info((Object)"I could not create a database object you specified (or didn't specify), so I am falling back to a default.");
                this.m_database = new DummyUserDatabase();
            }
        }
        return this.m_database;
    }

    public final UserProfile getUserProfile(WikiSession session) {
        UserProfile profile = (UserProfile)this.m_profiles.get(session);
        boolean newProfile = profile == null;
        Principal user = null;
        if (session.isAuthenticated()) {
            user = session.getUserPrincipal();
            try {
                profile = this.getUserDatabase().find(user.getName());
                newProfile = false;
            }
            catch (NoSuchPrincipalException e) {
                // empty catch block
            }
        }
        if (newProfile) {
            profile = this.getUserDatabase().newProfile();
            if (user != null) {
                profile.setLoginName(user.getName());
            }
            if (!profile.isNew()) {
                throw new IllegalStateException("New profile should be marked 'new'. Check your UserProfile implementation.");
            }
        }
        this.m_profiles.put(session, profile);
        return profile;
    }

    public final void setUserProfile(WikiSession session, UserProfile profile) throws DuplicateUserException, WikiException {
        UserProfile otherProfile;
        WikiPermission p = new WikiPermission(this.m_engine.getApplicationName(), "editProfile");
        if (!this.m_engine.getAuthorizationManager().checkPermission(session, p)) {
            throw new WikiSecurityException("You are not allowed to save wiki profiles.");
        }
        boolean newProfile = profile.isNew();
        UserProfile oldProfile = this.getUserProfile(session);
        boolean nameChanged = oldProfile == null || oldProfile.getFullname() == null ? false : !oldProfile.getFullname().equals(profile.getFullname()) || !oldProfile.getLoginName().equals(profile.getLoginName());
        try {
            otherProfile = this.getUserDatabase().findByLoginName(profile.getLoginName());
            if (otherProfile != null && !otherProfile.equals(oldProfile)) {
                throw new DuplicateUserException("The login name '" + profile.getLoginName() + "' is already taken.");
            }
        }
        catch (NoSuchPrincipalException e) {
            // empty catch block
        }
        try {
            otherProfile = this.getUserDatabase().findByFullName(profile.getFullname());
            if (otherProfile != null && !otherProfile.equals(oldProfile)) {
                throw new DuplicateUserException("The full name '" + profile.getFullname() + "' is already taken.");
            }
        }
        catch (NoSuchPrincipalException e) {
            // empty catch block
        }
        if (newProfile && oldProfile != null && oldProfile.isNew()) {
            WorkflowBuilder builder = WorkflowBuilder.getBuilder(this.m_engine);
            Principal submitter = session.getUserPrincipal();
            SaveUserProfileTask completionTask = new SaveUserProfileTask(this.m_engine);
            boolean hasEmail = profile.getEmail() != null;
            Fact[] facts = new Fact[hasEmail ? 4 : 3];
            facts[0] = new Fact(PREFS_FULL_NAME, profile.getFullname());
            facts[1] = new Fact(PREFS_LOGIN_NAME, profile.getLoginName());
            facts[2] = new Fact(FACT_SUBMITTER, submitter.getName());
            if (hasEmail) {
                facts[3] = new Fact(PREFS_EMAIL, profile.getEmail());
            }
            Workflow workflow = builder.buildApprovalWorkflow(submitter, SAVE_APPROVER, null, SAVE_DECISION_MESSAGE_KEY, facts, completionTask, null);
            workflow.setAttribute(SAVED_PROFILE, profile);
            this.m_engine.getWorkflowManager().start(workflow);
            boolean approvalRequired = workflow.getCurrentStep() instanceof Decision;
            if (approvalRequired) {
                throw new DecisionRequiredException("This profile must be approved before it becomes active");
            }
            try {
                AuthenticationManager mgr = this.m_engine.getAuthenticationManager();
                if (newProfile && !mgr.isContainerAuthenticated()) {
                    mgr.login(session, profile.getLoginName(), profile.getPassword());
                }
            }
            catch (WikiException e) {
                throw new WikiSecurityException(e.getMessage());
            }
            this.fireEvent(53, session, profile);
        } else {
            if (nameChanged && oldProfile != null && !oldProfile.getLoginName().equals(profile.getLoginName())) {
                this.getUserDatabase().rename(oldProfile.getLoginName(), profile.getLoginName());
            }
            this.getUserDatabase().save(profile);
            if (nameChanged) {
                UserProfile[] profiles = new UserProfile[]{oldProfile, profile};
                this.fireEvent(54, session, profiles);
            } else {
                this.fireEvent(53, session, profile);
            }
        }
    }

    public final UserProfile parseProfile(WikiContext context) {
        UserProfile profile = this.getUserProfile(context.getWikiSession());
        HttpServletRequest request = context.getHttpRequest();
        String loginName = request.getParameter(PARAM_LOGINNAME);
        String password = request.getParameter(PARAM_PASSWORD);
        String fullname = request.getParameter(PARAM_FULLNAME);
        String email = request.getParameter(PARAM_EMAIL);
        loginName = InputValidator.isBlank(loginName) ? null : loginName;
        password = InputValidator.isBlank(password) ? null : password;
        fullname = InputValidator.isBlank(fullname) ? null : fullname;
        String string = email = InputValidator.isBlank(email) ? null : email;
        if (this.m_engine.getAuthenticationManager().isContainerAuthenticated() && context.getWikiSession().isAuthenticated()) {
            loginName = context.getWikiSession().getLoginPrincipal().getName();
        }
        profile.setLoginName(loginName);
        profile.setEmail(email);
        profile.setFullname(fullname);
        profile.setPassword(password);
        return profile;
    }

    public final void validateProfile(WikiContext context, UserProfile profile) {
        Object[] args;
        UserProfile otherProfile;
        boolean isNew = profile.isNew();
        WikiSession session = context.getWikiSession();
        InputValidator validator = new InputValidator(SESSION_MESSAGES, session);
        ResourceBundle rb = context.getBundle("CoreResources");
        List ls = this.m_engine.getFilterManager().getFilterList();
        Iterator i = ls.iterator();
        while (i.hasNext()) {
            PageFilter pf = (PageFilter)i.next();
            if (!(pf instanceof SpamFilter)) continue;
            if (((SpamFilter)pf).isValidUserProfile(context, profile)) break;
            session.addMessage(SESSION_MESSAGES, "Invalid userprofile");
            return;
        }
        if (this.m_engine.getAuthenticationManager().isContainerAuthenticated() && !context.getWikiSession().isAuthenticated() && !this.getUserDatabase().isSharedWithContainer()) {
            session.addMessage(SESSION_MESSAGES, rb.getString("security.error.createprofilebeforelogin"));
        }
        validator.validateNotNull(profile.getLoginName(), rb.getString("security.user.loginname"));
        validator.validateNotNull(profile.getFullname(), rb.getString("security.user.fullname"));
        validator.validate(profile.getEmail(), rb.getString("security.user.email"), 1);
        if (!this.m_engine.getAuthenticationManager().isContainerAuthenticated()) {
            String password = profile.getPassword();
            if (password == null) {
                if (isNew) {
                    session.addMessage(SESSION_MESSAGES, rb.getString("security.error.blankpassword"));
                }
            } else {
                String password2;
                HttpServletRequest request = context.getHttpRequest();
                String string = password2 = request == null ? null : request.getParameter("password2");
                if (!password.equals(password2)) {
                    session.addMessage(SESSION_MESSAGES, rb.getString("security.error.passwordnomatch"));
                }
            }
        }
        String fullName = profile.getFullname();
        String loginName = profile.getLoginName();
        try {
            otherProfile = this.getUserDatabase().find(fullName);
            if (otherProfile != null && !profile.equals(otherProfile) && !fullName.equals(otherProfile.getFullname())) {
                args = new Object[]{fullName};
                session.addMessage(SESSION_MESSAGES, MessageFormat.format(rb.getString("security.error.illegalfullname"), args));
            }
        }
        catch (NoSuchPrincipalException e) {
            // empty catch block
        }
        try {
            otherProfile = this.getUserDatabase().find(loginName);
            if (otherProfile != null && !profile.equals(otherProfile) && !loginName.equals(otherProfile.getLoginName())) {
                args = new Object[]{loginName};
                session.addMessage(SESSION_MESSAGES, MessageFormat.format(rb.getString("security.error.illegalloginname"), args));
            }
        }
        catch (NoSuchPrincipalException e) {
            // empty catch block
        }
    }

    public Principal[] listWikiNames() throws WikiSecurityException {
        return this.getUserDatabase().getWikiNames();
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type, WikiSession session, Object profile) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent(session, type, profile));
        }
    }

    public final class JSONUserModule
    implements RPCCallable {
        public UserProfile getUserInfo(String uid) throws NoSuchPrincipalException {
            log.info((Object)("request " + uid));
            UserProfile prof = UserManager.this.getUserDatabase().find(uid);
            log.info((Object)("answer " + prof));
            return prof;
        }
    }

    public static class SaveUserProfileTask
    extends Task {
        private final UserDatabase m_db;
        private final WikiEngine m_engine;

        public SaveUserProfileTask(WikiEngine engine) {
            super(UserManager.SAVE_TASK_MESSAGE_KEY);
            this.m_engine = engine;
            this.m_db = engine.getUserManager().getUserDatabase();
        }

        public Outcome execute() throws WikiException {
            UserProfile profile = (UserProfile)this.getWorkflow().getAttribute(UserManager.SAVED_PROFILE);
            this.m_db.save(profile);
            if (profile.getEmail() != null) {
                try {
                    String app = this.m_engine.getApplicationName();
                    String to = profile.getEmail();
                    String subject = "Welcome to " + app;
                    String content = "Congratulations! Your new profile on " + app + " has been created. Your profile details are as follows: \n\n" + "Login name: " + profile.getLoginName() + "\n" + "Your name : " + profile.getFullname() + "\n" + "E-mail    : " + profile.getEmail() + "\n\n" + "If you forget your password, you can reset it at " + this.m_engine.getURL(WikiContext.LOGIN, null, null, true);
                    MailUtil.sendMessage(this.m_engine, to, subject, content);
                }
                catch (AddressException e) {
                }
                catch (MessagingException e) {
                    log.error((Object)"Could not send registration confirmation e-mail. Is the e-mail server running?");
                }
            }
            return Outcome.STEP_COMPLETE;
        }
    }

    public static class DummyUserDatabase
    extends AbstractUserDatabase {
        public void commit() throws WikiSecurityException {
        }

        public void deleteByLoginName(String loginName) throws WikiSecurityException {
        }

        public UserProfile findByEmail(String index) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        public UserProfile findByFullName(String index) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        public UserProfile findByLoginName(String index) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        public UserProfile findByWikiName(String index) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        public Principal[] getWikiNames() throws WikiSecurityException {
            return new Principal[0];
        }

        public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException {
        }

        public boolean isSharedWithContainer() {
            return false;
        }

        public void rename(String loginName, String newName) throws DuplicateUserException, WikiSecurityException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        public void save(UserProfile profile) throws WikiSecurityException {
        }
    }
}

