/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth;

import com.ecyrd.jspwiki.auth.PrincipalComparator;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;

public final class WikiPrincipal
implements Principal {
    public static final Principal GUEST = new WikiPrincipal("Guest");
    public static final String FULL_NAME = "fullName";
    public static final String LOGIN_NAME = "loginName";
    public static final String WIKI_NAME = "wikiName";
    public static final String UNSPECIFIED = "unspecified";
    public static final Comparator COMPARATOR = new PrincipalComparator();
    private static final String[] VALID_TYPES = new String[]{"fullName", "loginName", "wikiName", "unspecified"};
    private final String m_name;
    private final String m_type;

    public WikiPrincipal(String name) {
        this.m_name = name;
        this.m_type = UNSPECIFIED;
    }

    public WikiPrincipal(String name, String type) {
        this.m_name = name;
        if (Arrays.binarySearch(VALID_TYPES, type) < 0) {
            throw new IllegalArgumentException("Principal type '" + type + "' is invalid.");
        }
        this.m_type = type;
    }

    public final String getName() {
        return this.m_name;
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WikiPrincipal)) {
            return false;
        }
        return this.m_name.equals(((WikiPrincipal)obj).getName());
    }

    public final int hashCode() {
        return this.m_name.hashCode();
    }

    public final String getType() {
        return this.m_type;
    }

    public final String toString() {
        return "[WikiPrincipal (" + this.m_type + "): " + this.getName() + "]";
    }

    static {
        Arrays.sort(VALID_TYPES);
    }
}

