/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.acl;

import com.ecyrd.jspwiki.auth.acl.AclEntry;
import com.ecyrd.jspwiki.auth.permissions.PagePermission;
import java.security.Permission;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class AclEntryImpl
implements AclEntry {
    private Vector m_permissions = new Vector();
    private Principal m_principal;

    public synchronized boolean addPermission(Permission permission) {
        if (permission instanceof PagePermission && this.findPermission(permission) == null) {
            this.m_permissions.add(permission);
            return true;
        }
        return false;
    }

    public boolean checkPermission(Permission permission) {
        return this.findPermission(permission) != null;
    }

    public synchronized Principal getPrincipal() {
        return this.m_principal;
    }

    public Enumeration permissions() {
        return this.m_permissions.elements();
    }

    public synchronized boolean removePermission(Permission permission) {
        Permission p = this.findPermission(permission);
        if (p != null) {
            this.m_permissions.remove(p);
            return true;
        }
        return false;
    }

    public synchronized boolean setPrincipal(Principal user) {
        if (this.m_principal != null || user == null) {
            return false;
        }
        this.m_principal = user;
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Principal p = this.getPrincipal();
        sb.append("[AclEntry ALLOW " + (p != null ? p.getName() : "null"));
        sb.append(" ");
        Iterator i = this.m_permissions.iterator();
        while (i.hasNext()) {
            Permission pp = (Permission)i.next();
            sb.append(pp.toString());
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private Permission findPermission(Permission p) {
        Iterator i = this.m_permissions.iterator();
        while (i.hasNext()) {
            Permission pp = (Permission)i.next();
            if (!pp.implies(p)) continue;
            return pp;
        }
        return null;
    }
}

