/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.acl;

import com.ecyrd.jspwiki.auth.acl.Acl;
import com.ecyrd.jspwiki.auth.acl.AclEntry;
import java.security.Permission;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class AclImpl
implements Acl {
    private final Vector m_entries = new Vector();

    public Principal[] findPrincipals(Permission permission) {
        Vector<Principal> principals = new Vector<Principal>();
        Enumeration entries = this.entries();
        while (entries.hasMoreElements()) {
            AclEntry entry = (AclEntry)entries.nextElement();
            Enumeration permissions = entry.permissions();
            while (permissions.hasMoreElements()) {
                Permission perm = (Permission)permissions.nextElement();
                if (!perm.implies(permission)) continue;
                principals.add(entry.getPrincipal());
            }
        }
        return principals.toArray(new Principal[principals.size()]);
    }

    private boolean hasEntry(AclEntry entry) {
        if (entry == null) {
            return false;
        }
        Iterator i = this.m_entries.iterator();
        while (i.hasNext()) {
            AclEntry e = (AclEntry)i.next();
            Principal ep = e.getPrincipal();
            Principal entryp = entry.getPrincipal();
            if (ep == null || entryp == null) {
                throw new IllegalArgumentException("Entry is null; check code, please (entry=" + entry + "; e=" + e + ")");
            }
            if (!ep.getName().equals(entryp.getName())) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean addEntry(AclEntry entry) {
        if (entry.getPrincipal() == null) {
            throw new IllegalArgumentException("Entry principal cannot be null");
        }
        if (this.hasEntry(entry)) {
            return false;
        }
        this.m_entries.add(entry);
        return true;
    }

    public synchronized boolean removeEntry(AclEntry entry) {
        return this.m_entries.remove(entry);
    }

    public Enumeration entries() {
        return this.m_entries.elements();
    }

    public AclEntry getEntry(Principal principal) {
        Enumeration e = this.m_entries.elements();
        while (e.hasMoreElements()) {
            AclEntry entry = (AclEntry)e.nextElement();
            if (!entry.getPrincipal().getName().equals(principal.getName())) continue;
            return entry;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration myEnum = this.entries();
        while (myEnum.hasMoreElements()) {
            AclEntry entry = (AclEntry)myEnum.nextElement();
            Principal pal = entry.getPrincipal();
            if (pal != null) {
                sb.append("  user = " + pal.getName() + ": ");
            } else {
                sb.append("  user = null: ");
            }
            sb.append("(");
            Enumeration perms = entry.permissions();
            while (perms.hasMoreElements()) {
                Permission perm = (Permission)perms.nextElement();
                sb.append(perm.toString());
            }
            sb.append(")\n");
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.m_entries.isEmpty();
    }
}

