/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.authorize;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.AuthenticationManager;
import com.ecyrd.jspwiki.auth.Authorizer;
import com.ecyrd.jspwiki.auth.GroupPrincipal;
import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.authorize.Group;
import com.ecyrd.jspwiki.auth.authorize.GroupDatabase;
import com.ecyrd.jspwiki.auth.authorize.XMLGroupDatabase;
import com.ecyrd.jspwiki.auth.user.UserProfile;
import com.ecyrd.jspwiki.event.WikiEvent;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.event.WikiEventManager;
import com.ecyrd.jspwiki.event.WikiSecurityEvent;
import com.ecyrd.jspwiki.ui.InputValidator;
import com.ecyrd.jspwiki.util.ClassUtil;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public final class GroupManager
implements Authorizer,
WikiEventListener {
    public static final String MESSAGES_KEY = "group";
    private static final String PROP_GROUPDATABASE = "jspwiki.groupdatabase";
    static final Logger log = Logger.getLogger((Class)GroupManager.class);
    protected WikiEngine m_engine;
    protected WikiEventListener m_groupListener;
    private GroupDatabase m_groupDatabase = null;
    private final Map m_groups = new HashMap();

    public Principal findRole(String name) {
        try {
            Group group = this.getGroup(name);
            return group.getPrincipal();
        }
        catch (NoSuchPrincipalException e) {
            return null;
        }
    }

    public final Group getGroup(String name) throws NoSuchPrincipalException {
        Group group = (Group)this.m_groups.get(new GroupPrincipal(name));
        if (group != null) {
            return group;
        }
        throw new NoSuchPrincipalException("Group " + name + " not found.");
    }

    public final GroupDatabase getGroupDatabase() throws WikiSecurityException {
        if (this.m_groupDatabase != null) {
            return this.m_groupDatabase;
        }
        String dbClassName = "<unknown>";
        String dbInstantiationError = null;
        Exception cause = null;
        try {
            Properties props = this.m_engine.getWikiProperties();
            dbClassName = props.getProperty(PROP_GROUPDATABASE);
            if (dbClassName == null) {
                dbClassName = XMLGroupDatabase.class.getName();
            }
            log.info((Object)("Attempting to load group database class " + dbClassName));
            Class dbClass = ClassUtil.findClass("com.ecyrd.jspwiki.auth.authorize", dbClassName);
            this.m_groupDatabase = (GroupDatabase)dbClass.newInstance();
            this.m_groupDatabase.initialize(this.m_engine, this.m_engine.getWikiProperties());
            log.info((Object)"Group database initialized.");
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("GroupDatabase class " + dbClassName + " cannot be found."), (Throwable)e);
            dbInstantiationError = "Failed to locate GroupDatabase class " + dbClassName;
            cause = e;
        }
        catch (InstantiationException e) {
            log.error((Object)("GroupDatabase class " + dbClassName + " cannot be created."), (Throwable)e);
            dbInstantiationError = "Failed to create GroupDatabase class " + dbClassName;
            cause = e;
        }
        catch (IllegalAccessException e) {
            log.error((Object)("You are not allowed to access group database class " + dbClassName + "."), (Throwable)e);
            dbInstantiationError = "Access GroupDatabase class " + dbClassName + " denied";
            cause = e;
        }
        catch (NoRequiredPropertyException e) {
            log.error((Object)("Missing property: " + e.getMessage() + "."));
            dbInstantiationError = "Missing property: " + e.getMessage();
            cause = e;
        }
        if (dbInstantiationError != null) {
            throw new WikiSecurityException(dbInstantiationError + " Cause: " + (cause != null ? cause.getMessage() : ""));
        }
        return this.m_groupDatabase;
    }

    public final Principal[] getRoles() {
        return this.m_groups.keySet().toArray(new Principal[this.m_groups.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize(WikiEngine engine, Properties props) throws WikiSecurityException {
        this.m_engine = engine;
        try {
            this.m_groupDatabase = this.getGroupDatabase();
        }
        catch (WikiException e) {
            throw new WikiSecurityException(e.getMessage());
        }
        Group[] groups = this.m_groupDatabase.groups();
        Map map = this.m_groups;
        synchronized (map) {
            for (int i = 0; i < groups.length; ++i) {
                Group group = groups[i];
                this.m_groups.put(group.getPrincipal(), group);
                this.fireEvent(46, group);
            }
        }
        engine.getUserManager().addWikiEventListener(this);
        log.info((Object)("Authorizer GroupManager initialized successfully; loaded " + groups.length + " group(s)."));
    }

    public final boolean isUserInRole(WikiSession session, Principal role) {
        if (session == null || role == null || !(role instanceof GroupPrincipal) || !session.isAuthenticated()) {
            return false;
        }
        Group group = (Group)this.m_groups.get(role);
        if (group == null) {
            return false;
        }
        Principal[] principals = session.getPrincipals();
        for (int i = 0; i < principals.length; ++i) {
            if (!AuthenticationManager.isUserPrincipal(principals[i]) || !group.isMember(principals[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Group parseGroup(String name, String memberLine, boolean create) throws WikiSecurityException {
        String[] members;
        Group group;
        block8: {
            if (name == null) {
                if (!create) throw new WikiSecurityException("Group name cannot be blank.");
                name = "MyGroup";
            } else if (ArrayUtils.contains((Object[])Group.RESTRICTED_GROUPNAMES, (Object)name)) {
                throw new WikiSecurityException("Illegal group name: " + name);
            }
            name = name.trim();
            if (InputValidator.isBlank(memberLine)) {
                memberLine = "";
            }
            memberLine = memberLine.trim();
            group = new Group(name, this.m_engine.getApplicationName());
            try {
                Group existingGroup = this.getGroup(name);
                group.setCreator(existingGroup.getCreator());
                group.setCreated(existingGroup.getCreated());
                group.setModifier(existingGroup.getModifier());
                group.setLastModified(existingGroup.getLastModified());
                Principal[] existingMembers = existingGroup.members();
                for (int i = 0; i < existingMembers.length; ++i) {
                    group.add(existingMembers[i]);
                }
            }
            catch (NoSuchPrincipalException e) {
                if (create) break block8;
                throw new NoSuchPrincipalException("Group '" + name + "' does not exist.");
            }
        }
        if ((members = this.extractMembers(memberLine)).length <= 0) return group;
        group.clear();
        for (int i = 0; i < members.length; ++i) {
            group.add(new WikiPrincipal(members[i]));
        }
        return group;
    }

    public final Group parseGroup(WikiContext context, boolean create) throws WikiSecurityException {
        String memberLine;
        HttpServletRequest request = context.getHttpRequest();
        String name = request.getParameter(MESSAGES_KEY);
        Group group = this.parseGroup(name, memberLine = request.getParameter("members"), create);
        if (group.members().length == 0) {
            group.add(context.getWikiSession().getUserPrincipal());
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeGroup(String index) throws WikiSecurityException {
        if (index == null) {
            throw new IllegalArgumentException("Group cannot be null.");
        }
        Group group = (Group)this.m_groups.get(new GroupPrincipal(index));
        if (group == null) {
            throw new NoSuchPrincipalException("Group " + index + " not found");
        }
        Map map = this.m_groups;
        synchronized (map) {
            this.m_groups.remove(group.getPrincipal());
        }
        this.m_groupDatabase.delete(group);
        this.fireEvent(47, group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setGroup(WikiSession session, Group group) throws WikiSecurityException {
        Map map;
        Group oldGroup = (Group)this.m_groups.get(group.getPrincipal());
        if (oldGroup != null) {
            this.fireEvent(47, oldGroup);
            map = this.m_groups;
            synchronized (map) {
                this.m_groups.remove(oldGroup.getPrincipal());
            }
        }
        if (oldGroup != null) {
            group.setCreator(oldGroup.getCreator());
            group.setCreated(oldGroup.getCreated());
            group.setModifier(oldGroup.getModifier());
            group.setLastModified(oldGroup.getLastModified());
        }
        map = this.m_groups;
        synchronized (map) {
            this.m_groups.put(group.getPrincipal(), group);
        }
        this.fireEvent(46, group);
        try {
            this.m_groupDatabase.save(group, session.getUserPrincipal());
        }
        catch (WikiSecurityException e) {
            if (oldGroup != null) {
                this.fireEvent(47, group);
                this.fireEvent(46, oldGroup);
                Map map2 = this.m_groups;
                synchronized (map2) {
                    this.m_groups.put(oldGroup.getPrincipal(), oldGroup);
                }
                throw new WikiSecurityException(e.getMessage() + " (rolled back to previous version).");
            }
            throw new WikiSecurityException(e.getMessage());
        }
    }

    public final void validateGroup(WikiContext context, Group group) {
        WikiSession session = context.getWikiSession();
        InputValidator validator = new InputValidator(MESSAGES_KEY, session);
        try {
            this.checkGroupName(session, group.getName());
        }
        catch (WikiSecurityException e) {
            // empty catch block
        }
        Principal[] members = group.members();
        for (int i = 0; i < members.length; ++i) {
            validator.validateNotNull(members[i].getName(), "Full name", 2);
        }
    }

    protected final String[] extractMembers(String memberLine) {
        HashSet<String> members = new HashSet<String>();
        if (memberLine != null) {
            StringTokenizer tok = new StringTokenizer(memberLine, "\n");
            while (tok.hasMoreTokens()) {
                String uid = tok.nextToken().trim();
                if (uid == null || uid.length() <= 0) continue;
                members.add(uid);
            }
        }
        return members.toArray(new String[members.size()]);
    }

    protected final void checkGroupName(WikiSession session, String name) throws WikiSecurityException {
        if (session == null) {
            throw new WikiSecurityException("Session cannot be null.");
        }
        InputValidator validator = new InputValidator(MESSAGES_KEY, session);
        validator.validateNotNull(name, "Group name");
        if (ArrayUtils.contains((Object[])Group.RESTRICTED_GROUPNAMES, (Object)name)) {
            throw new WikiSecurityException("The group name '" + name + "' is illegal. Choose another.");
        }
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type, Object target) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent(this, type, target));
        }
    }

    public void actionPerformed(WikiEvent event) {
        if (!(event instanceof WikiSecurityEvent)) {
            return;
        }
        WikiSecurityEvent se = (WikiSecurityEvent)event;
        if (se.getType() == 54) {
            WikiSession session = (WikiSession)se.getSource();
            UserProfile[] profiles = (UserProfile[])se.getTarget();
            Principal[] oldPrincipals = new Principal[]{new WikiPrincipal(profiles[0].getLoginName()), new WikiPrincipal(profiles[0].getFullname()), new WikiPrincipal(profiles[0].getWikiName())};
            WikiPrincipal newPrincipal = new WikiPrincipal(profiles[1].getFullname());
            int groupsChanged = 0;
            try {
                Group[] groups = this.m_groupDatabase.groups();
                for (int i = 0; i < groups.length; ++i) {
                    boolean groupChanged = false;
                    Group group = groups[i];
                    for (int j = 0; j < oldPrincipals.length; ++j) {
                        if (!group.isMember(oldPrincipals[j])) continue;
                        group.remove(oldPrincipals[j]);
                        group.add(newPrincipal);
                        groupChanged = true;
                    }
                    if (!groupChanged) continue;
                    this.setGroup(session, group);
                    ++groupsChanged;
                }
            }
            catch (WikiException e) {
                log.error((Object)("Could not change user name in Group lists because of GroupDatabase error:" + e.getMessage()));
            }
            log.info((Object)("Profile name change for '" + ((Object)newPrincipal).toString() + "' caused " + groupsChanged + " groups to change also."));
        }
    }
}

