/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.login;

import com.ecyrd.jspwiki.auth.WikiPrincipal;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;

public abstract class AbstractLoginModule
implements LoginModule {
    private static final Logger log = Logger.getLogger((Class)AbstractLoginModule.class);
    protected CallbackHandler m_handler;
    protected Map m_options;
    protected Collection m_previousWikiPrincipals;
    protected Collection m_principals;
    protected Collection m_principalsToRemove;
    protected Collection m_principalsToOverwrite;
    protected Map m_state;
    protected Subject m_subject;
    protected static final String NULL = "(null)";

    public final boolean abort() throws LoginException {
        this.removePrincipals(this.m_principals);
        this.removePrincipals(this.m_principalsToRemove);
        this.m_principals.clear();
        this.m_principalsToRemove.clear();
        return true;
    }

    public final boolean commit() throws LoginException {
        if (this.succeeded()) {
            this.removePrincipals(this.m_previousWikiPrincipals);
            Iterator it = this.m_principals.iterator();
            while (it.hasNext()) {
                Principal principal = (Principal)it.next();
                this.m_subject.getPrincipals().add(principal);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Committed Principal " + principal.getName()));
            }
            this.removePrincipals(this.m_principalsToOverwrite);
            return true;
        }
        this.removePrincipals(this.m_principals);
        this.removePrincipals(this.m_principalsToRemove);
        this.m_principals.clear();
        this.m_principalsToRemove.clear();
        return false;
    }

    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.m_previousWikiPrincipals = new HashSet();
        this.m_principals = new HashSet();
        this.m_principalsToRemove = new HashSet();
        this.m_principalsToOverwrite = new HashSet();
        this.m_subject = subject;
        this.m_handler = callbackHandler;
        this.m_state = sharedState;
        this.m_options = options;
        if (subject == null) {
            throw new IllegalStateException("Subject cannot be null");
        }
        if (callbackHandler == null) {
            throw new IllegalStateException("Callback handler cannot be null");
        }
        this.m_previousWikiPrincipals.addAll(subject.getPrincipals(WikiPrincipal.class));
    }

    public abstract boolean login() throws LoginException;

    public final boolean logout() throws LoginException {
        this.removePrincipals(this.m_principals);
        this.removePrincipals(this.m_principalsToRemove);
        this.m_principals.clear();
        this.m_principalsToRemove.clear();
        return true;
    }

    private final boolean succeeded() {
        return this.m_principals.size() > 0;
    }

    private final void removePrincipals(Collection principals) {
        Iterator it = principals.iterator();
        while (it.hasNext()) {
            Principal principal = (Principal)it.next();
            if (!this.m_subject.getPrincipals().contains(principal)) continue;
            this.m_subject.getPrincipals().remove(principal);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Removed Principal " + principal.getName()));
        }
    }
}

