/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.login;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.authorize.Role;
import com.ecyrd.jspwiki.auth.login.AbstractLoginModule;
import com.ecyrd.jspwiki.auth.login.HttpRequestCallback;
import com.ecyrd.jspwiki.util.HttpUtil;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class CookieAssertionLoginModule
extends AbstractLoginModule {
    public static final String PREFS_COOKIE_NAME = "JSPWikiAssertedName";
    public static final String PROMPT = "User name";
    protected static final Logger log = Logger.getLogger((Class)CookieAssertionLoginModule.class);

    public boolean login() throws LoginException {
        if (this.m_subject.getPrincipals().contains(Role.AUTHENTICATED)) {
            this.m_principalsToRemove.add(Role.ASSERTED);
            return false;
        }
        HttpRequestCallback hcb = new HttpRequestCallback();
        Callback[] callbacks = new Callback[]{hcb};
        try {
            this.m_handler.handle(callbacks);
            HttpServletRequest request = hcb.getRequest();
            HttpSession session = request == null ? null : request.getSession(false);
            String sid = session == null ? "(null)" : session.getId();
            String name = CookieAssertionLoginModule.getUserCookie(request);
            if (name == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No cookie JSPWikiAssertedName present in session ID=:  " + sid));
                }
                throw new FailedLoginException("The user cookie was not found.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Logged in session ID=" + sid));
                log.debug((Object)("Added Principals " + name + ",Role.ASSERTED,Role.ALL"));
            }
            this.m_principals.add(new WikiPrincipal(name, "fullName"));
            this.m_principals.add(Role.ASSERTED);
            this.m_principals.add(Role.ALL);
            this.m_principalsToOverwrite.add(WikiPrincipal.GUEST);
            this.m_principalsToOverwrite.add(Role.ANONYMOUS);
            this.m_principalsToRemove.add(Role.ASSERTED);
            return true;
        }
        catch (IOException e) {
            log.error((Object)("IOException: " + e.getMessage()));
            return false;
        }
        catch (UnsupportedCallbackException e) {
            String message = "Unable to handle callback, disallowing login.";
            log.error((Object)message, (Throwable)e);
            throw new LoginException(message);
        }
    }

    public static String getUserCookie(HttpServletRequest request) {
        String cookie = HttpUtil.retrieveCookieValue(request, PREFS_COOKIE_NAME);
        return TextUtil.urlDecodeUTF8(cookie);
    }

    public static void setUserCookie(HttpServletResponse response, String name) {
        name = TextUtil.urlEncodeUTF8(name);
        Cookie userId = new Cookie(PREFS_COOKIE_NAME, name);
        userId.setMaxAge(86486400);
        response.addCookie(userId);
    }

    public static void clearUserCookie(HttpServletResponse response) {
        Cookie userId = new Cookie(PREFS_COOKIE_NAME, "");
        userId.setMaxAge(0);
        response.addCookie(userId);
    }
}

