/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.login;

import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.authorize.Role;
import com.ecyrd.jspwiki.auth.login.AbstractLoginModule;
import com.ecyrd.jspwiki.auth.login.PrincipalWrapper;
import com.ecyrd.jspwiki.auth.login.UserDatabaseCallback;
import com.ecyrd.jspwiki.auth.user.UserDatabase;
import com.ecyrd.jspwiki.auth.user.UserProfile;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

public class UserDatabaseLoginModule
extends AbstractLoginModule {
    private static final Logger log = Logger.getLogger((Class)UserDatabaseLoginModule.class);

    public boolean login() throws LoginException {
        UserDatabaseCallback ucb = new UserDatabaseCallback();
        NameCallback ncb = new NameCallback("User name");
        PasswordCallback pcb = new PasswordCallback("Password", false);
        Callback[] callbacks = new Callback[]{ucb, ncb, pcb};
        try {
            this.m_handler.handle(callbacks);
            UserDatabase db = ucb.getUserDatabase();
            String username = ncb.getName();
            String password = new String(pcb.getPassword());
            if (db == null) {
                throw new FailedLoginException("No user database: check the callback handler code!");
            }
            UserProfile profile = db.findByLoginName(username);
            String storedPassword = profile.getPassword();
            if (storedPassword != null && db.validatePassword(username, password)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Logged in loginName=" + username));
                    log.debug((Object)"Added Principals Role.AUTHENTICATED,Role.ALL");
                }
                this.m_principals.add(new PrincipalWrapper(new WikiPrincipal(username, "loginName")));
                this.m_principals.add(Role.AUTHENTICATED);
                this.m_principals.add(Role.ALL);
                this.m_principalsToOverwrite.add(WikiPrincipal.GUEST);
                this.m_principalsToOverwrite.add(Role.ANONYMOUS);
                this.m_principalsToOverwrite.add(Role.ASSERTED);
                this.m_principalsToRemove.add(Role.AUTHENTICATED);
                return true;
            }
            throw new FailedLoginException("The username or password is incorrect.");
        }
        catch (IOException e) {
            String message = "IO exception; disallowing login.";
            log.error((Object)message, (Throwable)e);
            throw new LoginException(message);
        }
        catch (UnsupportedCallbackException e) {
            String message = "Unable to handle callback; disallowing login.";
            log.error((Object)message, (Throwable)e);
            throw new LoginException(message);
        }
        catch (NoSuchPrincipalException e) {
            throw new FailedLoginException("The username or password is incorrect.");
        }
    }
}

