/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.login;

import com.ecyrd.jspwiki.auth.Authorizer;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.authorize.Role;
import com.ecyrd.jspwiki.auth.authorize.WebAuthorizer;
import com.ecyrd.jspwiki.auth.login.AbstractLoginModule;
import com.ecyrd.jspwiki.auth.login.AuthorizerCallback;
import com.ecyrd.jspwiki.auth.login.HttpRequestCallback;
import com.ecyrd.jspwiki.auth.login.PrincipalWrapper;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class WebContainerLoginModule
extends AbstractLoginModule {
    protected static final Logger log = Logger.getLogger((Class)WebContainerLoginModule.class);

    public boolean login() throws LoginException {
        HttpRequestCallback rcb = new HttpRequestCallback();
        AuthorizerCallback acb = new AuthorizerCallback();
        Callback[] callbacks = new Callback[]{rcb, acb};
        String userId = null;
        try {
            this.m_handler.handle(callbacks);
            HttpServletRequest request = rcb.getRequest();
            if (request == null) {
                throw new LoginException("No Http request supplied.");
            }
            HttpSession session = request.getSession(false);
            String sid = session == null ? "(null)" : session.getId();
            Principal principal = request.getUserPrincipal();
            if (principal == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No userPrincipal found for session ID=" + sid));
                }
                if ((userId = request.getRemoteUser()) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No remoteUser found for session ID=" + sid));
                    }
                    throw new FailedLoginException("No remote user found");
                }
                principal = new WikiPrincipal(userId, "loginName");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added Principal " + principal.getName() + ",Role.ANONYMOUS,Role.ALL"));
            }
            this.m_principals.add(new PrincipalWrapper(principal));
            this.injectWebAuthorizerRoles(acb.getAuthorizer(), request);
            this.m_principals.add(Role.AUTHENTICATED);
            this.m_principals.add(Role.ALL);
            this.m_principalsToOverwrite.add(WikiPrincipal.GUEST);
            this.m_principalsToOverwrite.add(Role.ANONYMOUS);
            this.m_principalsToOverwrite.add(Role.ASSERTED);
            this.m_principalsToRemove.add(Role.AUTHENTICATED);
            return true;
        }
        catch (IOException e) {
            log.error((Object)("IOException: " + e.getMessage()));
            return false;
        }
        catch (UnsupportedCallbackException e) {
            log.error((Object)("UnsupportedCallbackException: " + e.getMessage()));
            return false;
        }
    }

    private final void injectWebAuthorizerRoles(Authorizer authorizer, HttpServletRequest request) {
        Principal[] roles = authorizer.getRoles();
        HashSet<Principal> foundRoles = new HashSet<Principal>();
        if (authorizer instanceof WebAuthorizer) {
            WebAuthorizer wa = (WebAuthorizer)authorizer;
            for (int i = 0; i < roles.length; ++i) {
                if (!wa.isUserInRole(request, roles[i])) continue;
                foundRoles.add(roles[i]);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added Principal " + roles[i].getName() + "."));
            }
        }
        this.m_principals.addAll(foundRoles);
        this.m_principalsToRemove.addAll(foundRoles);
    }
}

