/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.permissions;

import com.ecyrd.jspwiki.auth.permissions.AllPermissionCollection;
import com.ecyrd.jspwiki.auth.permissions.GroupPermission;
import com.ecyrd.jspwiki.auth.permissions.PagePermission;
import com.ecyrd.jspwiki.auth.permissions.WikiPermission;
import java.security.Permission;
import java.security.PermissionCollection;

public final class AllPermission
extends Permission {
    private static final long serialVersionUID = 1L;
    private static final String WILDCARD = "*";
    private final String m_wiki;

    public AllPermission(String wiki) {
        super(wiki);
        this.m_wiki = wiki == null ? WILDCARD : wiki;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof AllPermission)) {
            return false;
        }
        AllPermission p = (AllPermission)obj;
        return p.m_wiki != null && p.m_wiki.equals(this.m_wiki);
    }

    public final String getActions() {
        return null;
    }

    public final String getWiki() {
        return this.m_wiki;
    }

    public final int hashCode() {
        return this.m_wiki.hashCode();
    }

    public final boolean implies(Permission permission) {
        if (!AllPermission.isJSPWikiPermission(permission)) {
            return false;
        }
        String wiki = null;
        if (permission instanceof AllPermission) {
            wiki = ((AllPermission)permission).getWiki();
        } else if (permission instanceof PagePermission) {
            wiki = ((PagePermission)permission).getWiki();
        }
        if (permission instanceof WikiPermission) {
            wiki = ((WikiPermission)permission).getWiki();
        }
        if (permission instanceof GroupPermission) {
            wiki = ((GroupPermission)permission).getWiki();
        }
        return PagePermission.isSubset(this.m_wiki, wiki);
    }

    public PermissionCollection newPermissionCollection() {
        return new AllPermissionCollection();
    }

    public final String toString() {
        return "(\"" + this.getClass().getName() + "\",\"" + this.m_wiki + "\")";
    }

    protected static final boolean isJSPWikiPermission(Permission permission) {
        return permission instanceof WikiPermission || permission instanceof PagePermission || permission instanceof GroupPermission || permission instanceof AllPermission;
    }
}

