/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.permissions;

import com.ecyrd.jspwiki.auth.permissions.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

public class AllPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 1L;
    private boolean m_notEmpty = false;
    private boolean m_readOnly = false;
    protected final Hashtable m_permissions = new Hashtable();

    public void add(Permission permission) {
        if (!AllPermission.isJSPWikiPermission(permission)) {
            throw new IllegalArgumentException("Permission must be of type com.ecyrd.jspwiki.permissions.*Permission.");
        }
        if (this.m_readOnly) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.m_notEmpty = true;
        this.m_permissions.put(permission, permission);
    }

    public Enumeration elements() {
        return this.m_permissions.elements();
    }

    public boolean implies(Permission permission) {
        if (!this.m_notEmpty) {
            return false;
        }
        if (!AllPermission.isJSPWikiPermission(permission)) {
            return false;
        }
        Enumeration permEnum = this.m_permissions.elements();
        while (permEnum.hasMoreElements()) {
            Permission storedPermission = (Permission)permEnum.nextElement();
            if (!storedPermission.implies(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly() {
        this.m_readOnly = true;
    }
}

