/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.permissions;

import com.ecyrd.jspwiki.auth.GroupPrincipal;
import com.ecyrd.jspwiki.auth.permissions.PagePermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;

public final class GroupPermission
extends Permission {
    public static final String MEMBER_TOKEN = "<groupmember>";
    private static final long serialVersionUID = 1L;
    public static final String DELETE_ACTION = "delete";
    public static final String EDIT_ACTION = "edit";
    public static final String VIEW_ACTION = "view";
    protected static final int DELETE_MASK = 4;
    protected static final int EDIT_MASK = 2;
    protected static final int VIEW_MASK = 1;
    public static final GroupPermission DELETE = new GroupPermission("delete");
    public static final GroupPermission EDIT = new GroupPermission("edit");
    public static final GroupPermission VIEW = new GroupPermission("view");
    private static final String ACTION_SEPARATOR = ",";
    private static final String WILDCARD = "*";
    private static final String WIKI_SEPARATOR = ":";
    private final String m_actionString;
    private final int m_mask;
    private final String m_group;
    private final String m_wiki;

    private GroupPermission(String actions) {
        this("*:*", actions);
    }

    public GroupPermission(String group, String actions) {
        super(group);
        String groupName;
        String[] pathParams = group.split(WIKI_SEPARATOR);
        if (pathParams.length >= 2) {
            this.m_wiki = pathParams[0].length() > 0 ? pathParams[0] : null;
            groupName = pathParams[1];
        } else {
            this.m_wiki = WILDCARD;
            groupName = pathParams[0];
        }
        this.m_group = groupName;
        String[] groupActions = actions.toLowerCase().split(ACTION_SEPARATOR);
        Arrays.sort(groupActions, String.CASE_INSENSITIVE_ORDER);
        this.m_mask = GroupPermission.createMask(actions);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < groupActions.length; ++i) {
            buffer.append(groupActions[i]);
            if (i >= groupActions.length - 1) continue;
            buffer.append(ACTION_SEPARATOR);
        }
        this.m_actionString = buffer.toString();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof GroupPermission)) {
            return false;
        }
        GroupPermission p = (GroupPermission)obj;
        return p.m_mask == this.m_mask && p.m_group.equals(this.m_group) && p.m_wiki != null && p.m_wiki.equals(this.m_wiki);
    }

    public final String getActions() {
        return this.m_actionString;
    }

    public final String getGroup() {
        return this.m_group;
    }

    public final String getWiki() {
        return this.m_wiki;
    }

    public final int hashCode() {
        String wiki = this.m_wiki != null ? this.m_wiki : "dummy_value";
        return this.m_mask + 13 * this.m_actionString.hashCode() * 23 * wiki.hashCode();
    }

    public final boolean implies(Permission permission) {
        if (!(permission instanceof GroupPermission)) {
            return false;
        }
        GroupPermission p = (GroupPermission)permission;
        int impliedMask = GroupPermission.impliedMask(this.m_mask);
        if ((impliedMask & p.m_mask) != p.m_mask) {
            return false;
        }
        boolean impliedWiki = PagePermission.isSubset(this.m_wiki, p.m_wiki);
        boolean impliedGroup = MEMBER_TOKEN.equals(p.m_group) ? MEMBER_TOKEN.equals(this.m_group) : PagePermission.isSubset(this.m_group, p.m_group);
        boolean impliedMember = this.impliesMember(p);
        return impliedWiki && (impliedGroup || impliedMember);
    }

    public final String toString() {
        String wiki = this.m_wiki == null ? "" : this.m_wiki;
        return "(\"" + this.getClass().getName() + "\",\"" + wiki + WIKI_SEPARATOR + this.m_group + "\",\"" + this.getActions() + "\")";
    }

    protected static final int impliedMask(int mask) {
        if ((mask & 4) > 0) {
            mask |= 2;
        }
        if ((mask & 2) > 0) {
            mask |= 1;
        }
        return mask;
    }

    protected static final int createMask(String actions) {
        if (actions == null || actions.length() == 0) {
            throw new IllegalArgumentException("Actions cannot be blank or null");
        }
        int mask = 0;
        String[] actionList = actions.split(ACTION_SEPARATOR);
        for (int i = 0; i < actionList.length; ++i) {
            String action = actionList[i];
            if (action.equalsIgnoreCase(VIEW_ACTION)) {
                mask |= 1;
                continue;
            }
            if (action.equalsIgnoreCase(EDIT_ACTION)) {
                mask |= 2;
                continue;
            }
            if (action.equalsIgnoreCase(DELETE_ACTION)) {
                mask |= 4;
                continue;
            }
            throw new IllegalArgumentException("Unrecognized action: " + action);
        }
        return mask;
    }

    protected final boolean impliesMember(Permission permission) {
        if (!(permission instanceof GroupPermission)) {
            return false;
        }
        GroupPermission gp = (GroupPermission)permission;
        if (!MEMBER_TOKEN.equals(this.m_group)) {
            return false;
        }
        AccessControlContext acc = AccessController.getContext();
        DomainCombiner dc = acc.getDomainCombiner();
        if (dc != null && dc instanceof SubjectDomainCombiner) {
            Subject subject = ((SubjectDomainCombiner)dc).getSubject();
            Set principals = subject.getPrincipals(GroupPrincipal.class);
            Iterator it = principals.iterator();
            while (it.hasNext()) {
                Principal principal = (Principal)it.next();
                if (!principal.getName().equals(gp.m_group)) continue;
                return true;
            }
        }
        return false;
    }
}

