/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.user;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.user.AbstractUserDatabase;
import com.ecyrd.jspwiki.auth.user.DefaultUserProfile;
import com.ecyrd.jspwiki.auth.user.DuplicateUserException;
import com.ecyrd.jspwiki.auth.user.UserProfile;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JDBCUserDatabase
extends AbstractUserDatabase {
    private static final String NOTHING = "";
    public static final String DEFAULT_DB_CREATED = "created";
    public static final String DEFAULT_DB_EMAIL = "email";
    public static final String DEFAULT_DB_FULL_NAME = "full_name";
    public static final String DEFAULT_DB_HASH_PREFIX = "true";
    public static final String DEFAULT_DB_JNDI_NAME = "jdbc/UserDatabase";
    public static final String DEFAULT_DB_MODIFIED = "modified";
    public static final String DEFAULT_DB_ROLE = "role";
    public static final String DEFAULT_DB_ROLE_TABLE = "roles";
    public static final String DEFAULT_DB_TABLE = "users";
    public static final String DEFAULT_DB_LOGIN_NAME = "login_name";
    public static final String DEFAULT_DB_PASSWORD = "password";
    public static final String DEFAULT_DB_WIKI_NAME = "wiki_name";
    public static final String PROP_DB_CREATED = "jspwiki.userdatabase.created";
    public static final String PROP_DB_EMAIL = "jspwiki.userdatabase.email";
    public static final String PROP_DB_FULL_NAME = "jspwiki.userdatabase.fullName";
    public static final String PROP_DB_DATASOURCE = "jspwiki.userdatabase.datasource";
    public static final String PROP_DB_HASH_PREFIX = "jspwiki.userdatabase.hashPrefix";
    public static final String PROP_DB_LOGIN_NAME = "jspwiki.userdatabase.loginName";
    public static final String PROP_DB_MODIFIED = "jspwiki.userdatabase.modified";
    public static final String PROP_DB_PASSWORD = "jspwiki.userdatabase.password";
    public static final String PROP_DB_ROLE = "jspwiki.userdatabase.role";
    public static final String PROP_DB_ROLE_TABLE = "jspwiki.userdatabase.roleTable";
    public static final String PROP_DB_TABLE = "jspwiki.userdatabase.table";
    public static final String PROP_DB_WIKI_NAME = "jspwiki.userdatabase.wikiName";
    private DataSource m_ds = null;
    private String m_deleteUserByLoginName = null;
    private String m_deleteRoleByLoginName = null;
    private String m_findByEmail = null;
    private String m_findByFullName = null;
    private String m_findByLoginName = null;
    private String m_findByWikiName = null;
    private String m_renameProfile = null;
    private String m_renameRoles = null;
    private String m_updateProfile = null;
    private String m_findAll = null;
    private String m_findRoles = null;
    private String m_initialRole = "Authenticated";
    private String m_insertProfile = null;
    private String m_insertRole = null;
    private String m_userTable = null;
    private String m_email = null;
    private String m_fullName = null;
    private boolean m_hashPrefix = true;
    private String m_loginName = null;
    private String m_password = null;
    private String m_role = null;
    private String m_roleTable = null;
    private String m_wikiName = null;
    private String m_created = null;
    private String m_modified = null;
    private boolean m_sharedWithContainer = false;
    private boolean m_supportsCommits = false;

    public void deleteByLoginName(String loginName) throws NoSuchPrincipalException, WikiSecurityException {
        this.findByLoginName(loginName);
        Connection conn = null;
        try {
            conn = this.m_ds.getConnection();
            if (this.m_supportsCommits) {
                conn.setAutoCommit(false);
            }
            PreparedStatement ps = conn.prepareStatement(this.m_deleteUserByLoginName);
            ps.setString(1, loginName);
            ps.execute();
            ps.close();
            ps = conn.prepareStatement(this.m_deleteRoleByLoginName);
            ps.setString(1, loginName);
            ps.execute();
            ps.close();
            if (this.m_supportsCommits) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            throw new WikiSecurityException(e.getMessage());
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public UserProfile findByEmail(String index) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByEmail, index);
    }

    public UserProfile findByFullName(String index) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByFullName, index);
    }

    public UserProfile findByLoginName(String index) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByLoginName, index);
    }

    public UserProfile findByWikiName(String index) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByWikiName, index);
    }

    public Principal[] getWikiNames() throws WikiSecurityException {
        HashSet<WikiPrincipal> principals = new HashSet<WikiPrincipal>();
        Connection conn = null;
        try {
            conn = this.m_ds.getConnection();
            PreparedStatement ps = conn.prepareStatement(this.m_findAll);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String wikiName = rs.getString(this.m_wikiName);
                if (wikiName == null) {
                    log.warn((Object)"Detected null wiki name in XMLUserDataBase. Check your user database.");
                    continue;
                }
                WikiPrincipal principal = new WikiPrincipal(wikiName, "wikiName");
                principals.add(principal);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new WikiSecurityException(e.getMessage());
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
        return principals.toArray(new Principal[principals.size()]);
    }

    public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException {
        String jndiName = props.getProperty(PROP_DB_DATASOURCE, DEFAULT_DB_JNDI_NAME);
        try {
            InitialContext initCtx = new InitialContext();
            Context ctx = (Context)initCtx.lookup("java:comp/env");
            this.m_ds = (DataSource)ctx.lookup(jndiName);
            this.m_userTable = props.getProperty(PROP_DB_TABLE, DEFAULT_DB_TABLE);
            this.m_email = props.getProperty(PROP_DB_EMAIL, DEFAULT_DB_EMAIL);
            this.m_fullName = props.getProperty(PROP_DB_FULL_NAME, DEFAULT_DB_FULL_NAME);
            this.m_hashPrefix = Boolean.valueOf(props.getProperty(PROP_DB_HASH_PREFIX, DEFAULT_DB_HASH_PREFIX));
            this.m_loginName = props.getProperty(PROP_DB_LOGIN_NAME, DEFAULT_DB_LOGIN_NAME);
            this.m_password = props.getProperty(PROP_DB_PASSWORD, DEFAULT_DB_PASSWORD);
            this.m_wikiName = props.getProperty(PROP_DB_WIKI_NAME, DEFAULT_DB_WIKI_NAME);
            this.m_created = props.getProperty(PROP_DB_CREATED, DEFAULT_DB_CREATED);
            this.m_modified = props.getProperty(PROP_DB_MODIFIED, DEFAULT_DB_MODIFIED);
            this.m_findAll = "SELECT * FROM " + this.m_userTable;
            this.m_findByEmail = "SELECT * FROM " + this.m_userTable + " WHERE " + this.m_email + "=?";
            this.m_findByFullName = "SELECT * FROM " + this.m_userTable + " WHERE " + this.m_fullName + "=?";
            this.m_findByLoginName = "SELECT * FROM " + this.m_userTable + " WHERE " + this.m_loginName + "=?";
            this.m_findByWikiName = "SELECT * FROM " + this.m_userTable + " WHERE " + this.m_wikiName + "=?";
            this.m_insertProfile = "INSERT INTO " + this.m_userTable + " (" + this.m_email + "," + this.m_fullName + "," + this.m_password + "," + this.m_wikiName + "," + this.m_modified + "," + this.m_loginName + "," + this.m_created + ") VALUES (?,?,?,?,?,?,?)";
            this.m_updateProfile = "UPDATE " + this.m_userTable + " SET " + this.m_email + "=?," + this.m_fullName + "=?," + this.m_password + "=?," + this.m_wikiName + "=?," + this.m_modified + "=? WHERE " + this.m_loginName + "=?";
            this.m_roleTable = props.getProperty(PROP_DB_ROLE_TABLE, DEFAULT_DB_ROLE_TABLE);
            this.m_role = props.getProperty(PROP_DB_ROLE, DEFAULT_DB_ROLE);
            this.m_insertRole = "INSERT INTO " + this.m_roleTable + " (" + this.m_loginName + "," + this.m_role + ") VALUES (?,?)";
            this.m_findRoles = "SELECT * FROM " + this.m_roleTable + " WHERE " + this.m_loginName + "=?";
            this.m_deleteUserByLoginName = "DELETE FROM " + this.m_userTable + " WHERE " + this.m_loginName + "=?";
            this.m_deleteRoleByLoginName = "DELETE FROM " + this.m_roleTable + " WHERE " + this.m_loginName + "=?";
            this.m_renameProfile = "UPDATE " + this.m_userTable + " SET " + this.m_loginName + "=?," + this.m_modified + "=? WHERE " + this.m_loginName + "=?";
            this.m_renameRoles = "UPDATE " + this.m_roleTable + " SET " + this.m_loginName + "=? WHERE " + this.m_loginName + "=?";
            this.m_sharedWithContainer = TextUtil.isPositive(props.getProperty("jspwiki.userdatabase.isSharedWithContainer", "false"));
        }
        catch (NamingException e) {
            log.error((Object)("JDBCUserDatabase initialization error: " + e.getMessage()));
            throw new NoRequiredPropertyException(PROP_DB_DATASOURCE, "JDBCUserDatabase initialization error: " + e.getMessage());
        }
        Connection conn = null;
        try {
            conn = this.m_ds.getConnection();
            PreparedStatement ps = conn.prepareStatement(this.m_findAll);
            ps.executeQuery();
            ps.close();
        }
        catch (SQLException e) {
            log.error((Object)("JDBCUserDatabase initialization error: " + e.getMessage()));
            throw new NoRequiredPropertyException(PROP_DB_DATASOURCE, "JDBCUserDatabase initialization error: " + e.getMessage());
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
        log.info((Object)("JDBCUserDatabase initialized from JNDI DataSource: " + jndiName));
        try {
            conn = this.m_ds.getConnection();
            DatabaseMetaData dmd = conn.getMetaData();
            if (dmd.supportsTransactions()) {
                this.m_supportsCommits = true;
                conn.setAutoCommit(false);
                log.info((Object)"JDBCUserDatabase supports transactions. Good; we will use them.");
            }
        }
        catch (SQLException e) {
            log.warn((Object)("JDBCUserDatabase warning: user database doesn't seem to support transactions. Reason: " + e.getMessage()));
            throw new NoRequiredPropertyException(PROP_DB_DATASOURCE, "JDBCUserDatabase initialization error: " + e.getMessage());
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public boolean isSharedWithContainer() {
        return this.m_sharedWithContainer;
    }

    public void rename(String loginName, String newName) throws NoSuchPrincipalException, DuplicateUserException, WikiSecurityException {
        UserProfile profile = this.findByLoginName(loginName);
        try {
            UserProfile otherProfile = this.findByLoginName(newName);
            if (otherProfile != null) {
                throw new DuplicateUserException("Cannot rename: the login name '" + newName + "' is already taken.");
            }
        }
        catch (NoSuchPrincipalException e) {
            // empty catch block
        }
        Connection conn = null;
        try {
            conn = this.m_ds.getConnection();
            if (this.m_supportsCommits) {
                conn.setAutoCommit(false);
            }
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            Date modDate = new Date(ts.getTime());
            PreparedStatement ps = conn.prepareStatement(this.m_renameProfile);
            ps.setString(1, newName);
            ps.setTimestamp(2, ts);
            ps.setString(3, loginName);
            ps.execute();
            ps.close();
            ps = conn.prepareStatement(this.m_renameRoles);
            ps.setString(1, newName);
            ps.setString(2, loginName);
            ps.execute();
            ps.close();
            profile.setLoginName(newName);
            profile.setLastModified(modDate);
            if (this.m_supportsCommits) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            throw new WikiSecurityException(e.getMessage());
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public void save(UserProfile profile) throws WikiSecurityException {
        String existingPassword;
        String loginName = profile.getLoginName();
        PreparedStatement ps = null;
        UserProfile existingProfile = null;
        try {
            existingProfile = this.findByLoginName(loginName);
        }
        catch (NoSuchPrincipalException e) {
            // empty catch block
        }
        String password = profile.getPassword();
        String string = existingPassword = existingProfile == null ? null : existingProfile.getPassword();
        if (NOTHING.equals(password)) {
            password = null;
        }
        if (password == null) {
            password = existingPassword;
        }
        if (!password.equals(existingPassword)) {
            password = this.m_hashPrefix ? "{SHA}" + this.getHash(password) : this.getHash(password);
        }
        Connection conn = null;
        try {
            conn = this.m_ds.getConnection();
            if (this.m_supportsCommits) {
                conn.setAutoCommit(false);
            }
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            Date modDate = new Date(ts.getTime());
            if (existingProfile == null) {
                ps = conn.prepareStatement(this.m_insertProfile);
                ps.setString(1, profile.getEmail());
                ps.setString(2, profile.getFullname());
                ps.setString(3, password);
                ps.setString(4, profile.getWikiName());
                ps.setTimestamp(5, ts);
                ps.setString(6, profile.getLoginName());
                ps.setTimestamp(7, ts);
                ps.execute();
                ps.close();
                if (this.m_sharedWithContainer) {
                    ps = conn.prepareStatement(this.m_findRoles);
                    ps.setString(1, profile.getLoginName());
                    ResultSet rs = ps.executeQuery();
                    int roles = 0;
                    while (rs.next()) {
                        ++roles;
                    }
                    ps.close();
                    if (roles == 0) {
                        ps = conn.prepareStatement(this.m_insertRole);
                        ps.setString(1, profile.getLoginName());
                        ps.setString(2, this.m_initialRole);
                        ps.execute();
                        ps.close();
                    }
                }
                profile.setCreated(modDate);
            } else {
                ps = conn.prepareStatement(this.m_updateProfile);
                ps.setString(1, profile.getEmail());
                ps.setString(2, profile.getFullname());
                ps.setString(3, password);
                ps.setString(4, profile.getWikiName());
                ps.setTimestamp(5, ts);
                ps.setString(6, profile.getLoginName());
                ps.execute();
                ps.close();
            }
            profile.setLastModified(modDate);
            if (this.m_supportsCommits) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            throw new WikiSecurityException(e.getMessage());
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    private UserProfile findByPreparedStatement(String sql, String index) throws NoSuchPrincipalException {
        DefaultUserProfile profile = null;
        boolean found = false;
        boolean unique = true;
        Connection conn = null;
        try {
            conn = this.m_ds.getConnection();
            if (this.m_supportsCommits) {
                conn.setAutoCommit(false);
            }
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, index);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (profile != null) {
                    unique = false;
                    break;
                }
                profile = new DefaultUserProfile();
                profile.setCreated(rs.getTimestamp(this.m_created));
                profile.setEmail(rs.getString(this.m_email));
                profile.setFullname(rs.getString(this.m_fullName));
                profile.setLastModified(rs.getTimestamp(this.m_modified));
                profile.setLoginName(rs.getString(this.m_loginName));
                profile.setPassword(rs.getString(this.m_password));
                found = true;
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new NoSuchPrincipalException(e.getMessage());
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
        if (!found) {
            throw new NoSuchPrincipalException("Could not find profile in database!");
        }
        if (!unique) {
            throw new NoSuchPrincipalException("More than one profile in database!");
        }
        return profile;
    }
}

