/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.dav;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.dav.DavPath;
import com.ecyrd.jspwiki.dav.DavProvider;
import com.ecyrd.jspwiki.dav.items.AttachmentItem;
import com.ecyrd.jspwiki.dav.items.DavItem;
import com.ecyrd.jspwiki.dav.items.DirectoryItem;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class AttachmentDavProvider
implements DavProvider {
    protected WikiEngine m_engine;
    protected static final Logger log = Logger.getLogger((Class)AttachmentDavProvider.class);

    public AttachmentDavProvider(WikiEngine engine) {
        this.m_engine = engine;
    }

    public WikiEngine getEngine() {
        return this.m_engine;
    }

    private Collection listAllPagesWithAttachments() {
        Iterator i;
        ArrayList<String> pageNames = new ArrayList<String>();
        try {
            Collection atts = this.m_engine.getAttachmentManager().getAllAttachments();
            i = atts.iterator();
            while (i.hasNext()) {
                Attachment att = (Attachment)i.next();
                String pageName = att.getParentName();
                if (pageNames.contains(pageName)) continue;
                pageNames.add(pageName);
            }
        }
        catch (ProviderException e) {
            log.error((Object)"Unable to get all attachments", (Throwable)e);
        }
        Collections.sort(pageNames);
        ArrayList<DirectoryItem> result = new ArrayList<DirectoryItem>();
        i = pageNames.iterator();
        while (i.hasNext()) {
            DirectoryItem di = new DirectoryItem(this, new DavPath((String)i.next()));
            result.add(di);
        }
        return result;
    }

    protected Collection listAttachmentsOfPage(DavPath path) {
        String pageName = path.getName();
        log.debug((Object)("Listing attachments for page " + pageName));
        ArrayList<AttachmentItem> result = new ArrayList<AttachmentItem>();
        try {
            WikiPage page = this.m_engine.getPage(pageName);
            Collection attachments = this.m_engine.getAttachmentManager().listAttachments(page);
            Iterator i = attachments.iterator();
            while (i.hasNext()) {
                Attachment att = (Attachment)i.next();
                DavPath thisPath = new DavPath("/");
                thisPath.append(att.getName());
                AttachmentItem ai = new AttachmentItem(this, thisPath, att);
                result.add(ai);
            }
        }
        catch (ProviderException e) {
            log.error((Object)"Unable to list attachments, returning what I got", (Throwable)e);
        }
        return result;
    }

    public DavItem getItem(DavPath path) {
        if (path.isRoot()) {
            DirectoryItem di = new DirectoryItem(this, new DavPath(""));
            di.addDavItems(this.listAllPagesWithAttachments());
            return di;
        }
        if (path.isDirectory()) {
            DirectoryItem di = new DirectoryItem(this, path);
            di.addDavItems(this.listAttachmentsOfPage(path));
            return di;
        }
        String attName = path.getPath();
        try {
            Attachment att = this.m_engine.getAttachmentManager().getAttachmentInfo(attName);
            if (att != null) {
                AttachmentItem ai = new AttachmentItem(this, path, att);
                return ai;
            }
        }
        catch (ProviderException e) {
            log.error((Object)("Unable to get the attachment data for " + attName), (Throwable)e);
        }
        return null;
    }

    public void setItem(DavPath path, DavItem item) {
    }

    public String getURL(DavPath path) {
        String p = path.getPath();
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        return this.m_engine.getURL(WikiContext.ATTACH, p, null, true);
    }
}

