/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.dav;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.dav.DavPath;
import com.ecyrd.jspwiki.dav.DavUtil;
import com.ecyrd.jspwiki.dav.RawPagesDavProvider;
import com.ecyrd.jspwiki.dav.items.DavItem;
import com.ecyrd.jspwiki.dav.items.DirectoryItem;
import com.ecyrd.jspwiki.dav.items.HTMLPageDavItem;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class HTMLPagesDavProvider
extends RawPagesDavProvider {
    public HTMLPagesDavProvider(WikiEngine engine) {
        super(engine);
    }

    private Collection listDirContents(DavPath path) {
        String st = path.getName();
        log.info((Object)("Listing contents for dir " + st));
        ArrayList<HTMLPageDavItem> davItems = new ArrayList<HTMLPageDavItem>();
        try {
            Collection allPages = this.m_engine.getPageManager().getAllPages();
            Iterator i = allPages.iterator();
            while (i.hasNext()) {
                WikiPage p = (WikiPage)i.next();
                if (!p.getName().toLowerCase().startsWith(st)) continue;
                DavPath dp = new DavPath(path);
                dp.append(p.getName() + ".html");
                HTMLPageDavItem di = new HTMLPageDavItem(this, dp, p);
                davItems.add(di);
            }
        }
        catch (ProviderException e) {
            log.error((Object)"Unable to fetch a list of all pages", (Throwable)e);
        }
        return davItems;
    }

    protected DavItem getItemNoCache(DavPath path) {
        WikiPage page;
        String pname = path.filePart();
        if (path.isRoot()) {
            log.info((Object)("Adding DAV items from path " + path));
            DirectoryItem di = new DirectoryItem(this, path);
            di.addDavItems(this.listAlphabeticals(path));
            return di;
        }
        if (path.isDirectory()) {
            log.info((Object)("Listing pages in path " + path));
            DirectoryItem di = new DirectoryItem(this, path);
            di.addDavItems(this.listDirContents(path));
            return di;
        }
        if (pname.endsWith(".html") && pname.length() > 5) {
            pname = pname.substring(0, pname.length() - 5);
        }
        if ((page = this.m_engine.getPage(pname)) != null) {
            return new HTMLPageDavItem(this, path, page);
        }
        return null;
    }

    public String getURL(DavPath path) {
        return this.m_engine.getURL(WikiContext.NONE, DavUtil.combineURL("dav/html", path.getPath()), null, true);
    }
}

