/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.dav;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.dav.DavPath;
import com.ecyrd.jspwiki.dav.DavUtil;
import com.ecyrd.jspwiki.dav.WikiDavProvider;
import com.ecyrd.jspwiki.dav.items.DavItem;
import com.ecyrd.jspwiki.dav.items.DirectoryItem;
import com.ecyrd.jspwiki.dav.items.PageDavItem;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.NeedsRefreshException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class RawPagesDavProvider
extends WikiDavProvider {
    protected static final Logger log = Logger.getLogger((Class)RawPagesDavProvider.class);
    private Cache m_davItemCache = new Cache(true, false, false);
    private int m_refreshPeriod = 30000;

    public RawPagesDavProvider(WikiEngine engine) {
        super(engine);
    }

    protected Collection listAlphabeticals(DavPath path) {
        Iterator i;
        ArrayList<Character> charList = new ArrayList<Character>();
        try {
            Collection allPages = this.m_engine.getPageManager().getAllPages();
            i = allPages.iterator();
            while (i.hasNext()) {
                String pageName = ((WikiPage)i.next()).getName();
                Character firstChar = new Character(Character.toLowerCase(pageName.charAt(0)));
                if (charList.contains(firstChar)) continue;
                charList.add(firstChar);
            }
        }
        catch (ProviderException e) {
            log.error((Object)"Could not fetch a list of all pages:", (Throwable)e);
        }
        Collections.sort(charList);
        ArrayList<DirectoryItem> result = new ArrayList<DirectoryItem>();
        i = charList.iterator();
        while (i.hasNext()) {
            Character c = (Character)i.next();
            result.add(new DirectoryItem(this, new DavPath(c.toString())));
        }
        return result;
    }

    private Collection listDirContents(DavPath path) {
        String st = path.getName();
        log.info((Object)("Listing contents for dir " + st));
        ArrayList<PageDavItem> davItems = new ArrayList<PageDavItem>();
        try {
            Collection allPages = this.m_engine.getPageManager().getAllPages();
            Iterator i = allPages.iterator();
            while (i.hasNext()) {
                WikiPage p = (WikiPage)i.next();
                if (!p.getName().toLowerCase().startsWith(st)) continue;
                DavPath np = new DavPath(path);
                np.append(p.getName() + ".txt");
                PageDavItem di = new PageDavItem(this, np, p);
                davItems.add(di);
            }
        }
        catch (ProviderException e) {
            log.error((Object)"Unable to fetch a list of all pages", (Throwable)e);
        }
        return davItems;
    }

    public Collection listItems(DavPath path) {
        log.info((Object)("Listing dav path " + path + ", size=" + path.size()));
        switch (path.size()) {
            case 1: {
                return this.listAlphabeticals(path);
            }
            case 2: {
                return this.listDirContents(path);
            }
        }
        return null;
    }

    protected String getRelativePath(String path) {
        if (path.length() > 0) {
            char c = Character.toLowerCase(path.charAt(0));
            return Character.toString(c);
        }
        return "";
    }

    public String getURL(DavPath path) {
        return this.m_engine.getURL(WikiContext.NONE, DavUtil.combineURL("dav/raw/", path.getPath()), null, true);
    }

    public DavItem getItem(DavPath dp) {
        DavItem di = null;
        try {
            di = (DavItem)this.m_davItemCache.getFromCache(dp.toString(), this.m_refreshPeriod);
            if (di == null) {
                di = this.getItemNoCache(dp);
            }
        }
        catch (NeedsRefreshException e) {
            DavItem old = (DavItem)e.getCacheContent();
            if (old != null && old instanceof PageDavItem) {
                WikiPage cached = ((PageDavItem)old).getPage();
                if (cached != null) {
                    WikiPage current = this.m_engine.getPage(cached.getName());
                    if (cached.getLastModified().equals(current.getLastModified())) {
                        di = old;
                    }
                }
            }
            di = this.getItemNoCache(dp);
        }
        this.m_davItemCache.putInCache(dp.toString(), (Object)di);
        return di;
    }

    protected DavItem getItemNoCache(DavPath path) {
        WikiPage page;
        String pname = path.filePart();
        if (path.isRoot()) {
            log.info((Object)("Adding DAV items from path " + path));
            DirectoryItem di = new DirectoryItem(this, path);
            di.addDavItems(this.listAlphabeticals(path));
            return di;
        }
        if (path.isDirectory()) {
            log.info((Object)("Listing pages in path " + path));
            DirectoryItem di = new DirectoryItem(this, path);
            di.addDavItems(this.listDirContents(path));
            return di;
        }
        if (pname.endsWith(".txt") && pname.length() > 4) {
            pname = pname.substring(0, pname.length() - 4);
        }
        if ((page = this.m_engine.getPage(pname)) != null) {
            return new PageDavItem(this, path, page);
        }
        return null;
    }

    public void setItem(DavPath path, DavItem item) {
    }
}

